/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.io.ByteArrayInputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.jcp.xml.dsig.internal.dom.DOMX509IssuerSerial;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMX509Data
extends DOMStructure
implements X509Data {
    private final List content;
    private CertificateFactory cf;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DOMX509Data(List list2) {
        if (list2 == null) {
            throw new NullPointerException("content cannot be null");
        }
        ArrayList arrayList = new ArrayList(list2);
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException("content cannot be empty");
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object e2 = arrayList.get(i);
            if (e2 instanceof String) {
                new X500Principal((String)e2);
                continue;
            }
            if (e2 instanceof byte[] || e2 instanceof X509Certificate || e2 instanceof X509CRL || e2 instanceof XMLStructure) continue;
            throw new ClassCastException("content[" + i + "] is not a valid X509Data type");
        }
        this.content = Collections.unmodifiableList(arrayList);
    }

    public DOMX509Data(Element element2) throws MarshalException {
        NodeList nodeList = element2.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            Node node4 = nodeList.item(i);
            if (node4.getNodeType() != 1) continue;
            Element element3 = (Element)node4;
            String string2 = element3.getLocalName();
            if (string2.equals("X509Certificate")) {
                arrayList.add(this.unmarshalX509Certificate(element3));
                continue;
            }
            if (string2.equals("X509IssuerSerial")) {
                arrayList.add(new DOMX509IssuerSerial(element3));
                continue;
            }
            if (string2.equals("X509SubjectName")) {
                arrayList.add(element3.getFirstChild().getNodeValue());
                continue;
            }
            if (string2.equals("X509SKI")) {
                try {
                    arrayList.add(Base64.decode(element3));
                    continue;
                }
                catch (Base64DecodingException base64DecodingException) {
                    throw new MarshalException("cannot decode X509SKI", base64DecodingException);
                }
            }
            if (string2.equals("X509CRL")) {
                arrayList.add(this.unmarshalX509CRL(element3));
                continue;
            }
            arrayList.add(new javax.xml.crypto.dom.DOMStructure(element3));
        }
        this.content = Collections.unmodifiableList(arrayList);
    }

    public List getContent() {
        return this.content;
    }

    public void marshal(Node node4, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Document document2 = DOMUtils.getOwnerDocument(node4);
        Element element2 = DOMUtils.createElement(document2, "X509Data", "http://www.w3.org/2000/09/xmldsig#", string2);
        int n = this.content.size();
        for (int i = 0; i < n; ++i) {
            Object e2 = this.content.get(i);
            if (e2 instanceof X509Certificate) {
                this.marshalCert((X509Certificate)e2, element2, document2, string2);
                continue;
            }
            if (e2 instanceof XMLStructure) {
                if (e2 instanceof X509IssuerSerial) {
                    ((DOMX509IssuerSerial)e2).marshal(element2, string2, dOMCryptoContext);
                    continue;
                }
                javax.xml.crypto.dom.DOMStructure dOMStructure = (javax.xml.crypto.dom.DOMStructure)e2;
                DOMUtils.appendChild(element2, dOMStructure.getNode());
                continue;
            }
            if (e2 instanceof byte[]) {
                this.marshalSKI((byte[])e2, element2, document2, string2);
                continue;
            }
            if (e2 instanceof String) {
                this.marshalSubjectName((String)e2, element2, document2, string2);
                continue;
            }
            if (!(e2 instanceof X509CRL)) continue;
            this.marshalCRL((X509CRL)e2, element2, document2, string2);
        }
        node4.appendChild(element2);
    }

    private void marshalSKI(byte[] byArray, Node node4, Document document2, String string2) {
        Element element2 = DOMUtils.createElement(document2, "X509SKI", "http://www.w3.org/2000/09/xmldsig#", string2);
        element2.appendChild(document2.createTextNode(Base64.encode(byArray)));
        node4.appendChild(element2);
    }

    private void marshalSubjectName(String string2, Node node4, Document document2, String string3) {
        Element element2 = DOMUtils.createElement(document2, "X509SubjectName", "http://www.w3.org/2000/09/xmldsig#", string3);
        element2.appendChild(document2.createTextNode(string2));
        node4.appendChild(element2);
    }

    private void marshalCert(X509Certificate x509Certificate, Node node4, Document document2, String string2) throws MarshalException {
        Element element2 = DOMUtils.createElement(document2, "X509Certificate", "http://www.w3.org/2000/09/xmldsig#", string2);
        try {
            element2.appendChild(document2.createTextNode(Base64.encode(x509Certificate.getEncoded())));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new MarshalException("Error encoding X509Certificate", certificateEncodingException);
        }
        node4.appendChild(element2);
    }

    private void marshalCRL(X509CRL x509CRL, Node node4, Document document2, String string2) throws MarshalException {
        Element element2 = DOMUtils.createElement(document2, "X509CRL", "http://www.w3.org/2000/09/xmldsig#", string2);
        try {
            element2.appendChild(document2.createTextNode(Base64.encode(x509CRL.getEncoded())));
        }
        catch (CRLException cRLException) {
            throw new MarshalException("Error encoding X509CRL", cRLException);
        }
        node4.appendChild(element2);
    }

    private X509Certificate unmarshalX509Certificate(Element element2) throws MarshalException {
        try {
            ByteArrayInputStream byteArrayInputStream = this.unmarshalBase64Binary(element2);
            return (X509Certificate)this.cf.generateCertificate(byteArrayInputStream);
        }
        catch (CertificateException certificateException) {
            throw new MarshalException("Cannot create X509Certificate", certificateException);
        }
    }

    private X509CRL unmarshalX509CRL(Element element2) throws MarshalException {
        try {
            ByteArrayInputStream byteArrayInputStream = this.unmarshalBase64Binary(element2);
            return (X509CRL)this.cf.generateCRL(byteArrayInputStream);
        }
        catch (CRLException cRLException) {
            throw new MarshalException("Cannot create X509CRL", cRLException);
        }
    }

    private ByteArrayInputStream unmarshalBase64Binary(Element element2) throws MarshalException {
        try {
            if (this.cf == null) {
                this.cf = CertificateFactory.getInstance("X.509");
            }
            return new ByteArrayInputStream(Base64.decode(element2));
        }
        catch (CertificateException certificateException) {
            throw new MarshalException("Cannot create CertificateFactory", certificateException);
        }
        catch (Base64DecodingException base64DecodingException) {
            throw new MarshalException("Cannot decode Base64-encoded val", base64DecodingException);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509Data)) {
            return false;
        }
        X509Data x509Data = (X509Data)object;
        List list2 = x509Data.getContent();
        int n = this.content.size();
        if (n != list2.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Object e2 = this.content.get(i);
            Object e3 = list2.get(i);
            if (!(e2 instanceof byte[] ? !(e3 instanceof byte[]) || !Arrays.equals((byte[])e2, (byte[])e3) : !e2.equals(e3))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 56;
    }

    static {
        $assertionsDisabled = !DOMX509Data.class.desiredAssertionStatus();
    }
}

