/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.math.BigInteger;
import javax.security.auth.x500.X500Principal;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMX509IssuerSerial
extends DOMStructure
implements X509IssuerSerial {
    private final String issuerName;
    private final BigInteger serialNumber;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DOMX509IssuerSerial(String string2, BigInteger bigInteger) {
        if (string2 == null) {
            throw new NullPointerException("issuerName cannot be null");
        }
        if (bigInteger == null) {
            throw new NullPointerException("serialNumber cannot be null");
        }
        new X500Principal(string2);
        this.issuerName = string2;
        this.serialNumber = bigInteger;
    }

    public DOMX509IssuerSerial(Element element2) {
        Element element3 = DOMUtils.getFirstChildElement(element2);
        Element element4 = DOMUtils.getNextSiblingElement(element3);
        this.issuerName = element3.getFirstChild().getNodeValue();
        this.serialNumber = new BigInteger(element4.getFirstChild().getNodeValue());
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public void marshal(Node node4, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Document document2 = DOMUtils.getOwnerDocument(node4);
        Element element2 = DOMUtils.createElement(document2, "X509IssuerSerial", "http://www.w3.org/2000/09/xmldsig#", string2);
        Element element3 = DOMUtils.createElement(document2, "X509IssuerName", "http://www.w3.org/2000/09/xmldsig#", string2);
        Element element4 = DOMUtils.createElement(document2, "X509SerialNumber", "http://www.w3.org/2000/09/xmldsig#", string2);
        element3.appendChild(document2.createTextNode(this.issuerName));
        element4.appendChild(document2.createTextNode(this.serialNumber.toString()));
        element2.appendChild(element3);
        element2.appendChild(element4);
        node4.appendChild(element2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509IssuerSerial)) {
            return false;
        }
        X509IssuerSerial x509IssuerSerial = (X509IssuerSerial)object;
        return this.issuerName.equals(x509IssuerSerial.getIssuerName()) && this.serialNumber.equals(x509IssuerSerial.getSerialNumber());
    }

    public int hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 52;
    }

    static {
        $assertionsDisabled = !DOMX509IssuerSerial.class.desiredAssertionStatus();
    }
}

