/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.jcp.xml.dsig.internal.dom.DOMKeyInfo;
import org.jcp.xml.dsig.internal.dom.DOMReference;
import org.jcp.xml.dsig.internal.dom.DOMSignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMSignedInfo;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.jcp.xml.dsig.internal.dom.DOMXMLObject;
import org.jcp.xml.dsig.internal.dom.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMXMLSignature
extends DOMStructure
implements XMLSignature {
    private static Logger log;
    private String id;
    private XMLSignature.SignatureValue sv;
    private KeyInfo ki;
    private List objects;
    private SignedInfo si;
    private Document ownerDoc = null;
    private Element localSigElem = null;
    private Element sigElem = null;
    private boolean validationStatus;
    private boolean validated = false;
    private KeySelectorResult ksr;
    private HashMap signatureIdMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DOMXMLSignature(SignedInfo signedInfo, KeyInfo keyInfo, List list2, String string2, String string3) {
        if (signedInfo == null) {
            throw new NullPointerException("signedInfo cannot be null");
        }
        this.si = signedInfo;
        this.id = string2;
        this.sv = new DOMSignatureValue(string3);
        if (list2 == null) {
            this.objects = Collections.EMPTY_LIST;
        } else {
            ArrayList arrayList = new ArrayList(list2);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (arrayList.get(i) instanceof XMLObject) continue;
                throw new ClassCastException("objs[" + i + "] is not an XMLObject");
            }
            this.objects = Collections.unmodifiableList(arrayList);
        }
        this.ki = keyInfo;
    }

    public DOMXMLSignature(Element element2, XMLCryptoContext xMLCryptoContext, Provider provider) throws MarshalException {
        this.localSigElem = element2;
        this.ownerDoc = this.localSigElem.getOwnerDocument();
        this.id = DOMUtils.getAttributeValue(this.localSigElem, "Id");
        Element element3 = DOMUtils.getFirstChildElement(this.localSigElem);
        this.si = new DOMSignedInfo(element3, xMLCryptoContext, provider);
        Element element4 = DOMUtils.getNextSiblingElement(element3);
        this.sv = new DOMSignatureValue(element4);
        Element element5 = DOMUtils.getNextSiblingElement(element4);
        if (element5 != null && element5.getLocalName().equals("KeyInfo")) {
            this.ki = new DOMKeyInfo(element5, xMLCryptoContext, provider);
            element5 = DOMUtils.getNextSiblingElement(element5);
        }
        if (element5 == null) {
            this.objects = Collections.EMPTY_LIST;
        } else {
            ArrayList<DOMXMLObject> arrayList = new ArrayList<DOMXMLObject>();
            while (element5 != null) {
                arrayList.add(new DOMXMLObject(element5, xMLCryptoContext, provider));
                element5 = DOMUtils.getNextSiblingElement(element5);
            }
            this.objects = Collections.unmodifiableList(arrayList);
        }
    }

    public String getId() {
        return this.id;
    }

    public KeyInfo getKeyInfo() {
        return this.ki;
    }

    public SignedInfo getSignedInfo() {
        return this.si;
    }

    public List getObjects() {
        return this.objects;
    }

    public XMLSignature.SignatureValue getSignatureValue() {
        return this.sv;
    }

    public KeySelectorResult getKeySelectorResult() {
        return this.ksr;
    }

    public void marshal(Node node4, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        this.marshal(node4, null, string2, dOMCryptoContext);
    }

    public void marshal(Node node4, Node node5, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        this.ownerDoc = DOMUtils.getOwnerDocument(node4);
        this.sigElem = DOMUtils.createElement(this.ownerDoc, "Signature", "http://www.w3.org/2000/09/xmldsig#", string2);
        if (string2 == null || string2.length() == 0) {
            this.sigElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        } else {
            this.sigElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string2, "http://www.w3.org/2000/09/xmldsig#");
        }
        ((DOMSignedInfo)this.si).marshal(this.sigElem, string2, dOMCryptoContext);
        ((DOMSignatureValue)this.sv).marshal(this.sigElem, string2, dOMCryptoContext);
        if (this.ki != null) {
            ((DOMKeyInfo)this.ki).marshal(this.sigElem, null, string2, dOMCryptoContext);
        }
        int n = this.objects.size();
        for (int i = 0; i < n; ++i) {
            ((DOMXMLObject)this.objects.get(i)).marshal(this.sigElem, string2, dOMCryptoContext);
        }
        DOMUtils.setAttributeID(this.sigElem, "Id", this.id);
        node4.insertBefore(this.sigElem, node5);
    }

    public boolean validate(XMLValidateContext xMLValidateContext) throws XMLSignatureException {
        int n;
        boolean bl;
        if (xMLValidateContext == null) {
            throw new NullPointerException("validateContext is null");
        }
        if (!(xMLValidateContext instanceof DOMValidateContext)) {
            throw new ClassCastException("validateContext must be of type DOMValidateContext");
        }
        if (this.validated) {
            return this.validationStatus;
        }
        boolean bl2 = this.sv.validate(xMLValidateContext);
        if (!bl2) {
            this.validationStatus = false;
            this.validated = true;
            return this.validationStatus;
        }
        List list2 = this.si.getReferences();
        boolean bl3 = true;
        int n2 = list2.size();
        for (n = 0; bl3 && n < n2; bl3 &= bl, ++n) {
            Reference reference = (Reference)list2.get(n);
            bl = reference.validate(xMLValidateContext);
            if (!log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "Reference[" + reference.getURI() + "] is valid: " + bl);
        }
        if (!bl3) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Couldn't validate the References");
            }
            this.validationStatus = false;
            this.validated = true;
            return this.validationStatus;
        }
        n = 1;
        if (Boolean.TRUE.equals(xMLValidateContext.getProperty("org.jcp.xml.dsig.validateManifests"))) {
            int n3 = this.objects.size();
            for (n2 = 0; n != 0 && n2 < n3; ++n2) {
                XMLObject xMLObject = (XMLObject)this.objects.get(n2);
                List list3 = xMLObject.getContent();
                int n4 = list3.size();
                for (int i = 0; n != 0 && i < n4; ++i) {
                    int n5;
                    XMLStructure xMLStructure = (XMLStructure)list3.get(i);
                    if (!(xMLStructure instanceof Manifest)) continue;
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "validating manifest");
                    }
                    Manifest manifest2 = (Manifest)xMLStructure;
                    List list4 = manifest2.getReferences();
                    int n6 = list4.size();
                    for (int j = 0; n != 0 && j < n6; n &= n5, ++j) {
                        Reference reference = (Reference)list4.get(j);
                        n5 = reference.validate(xMLValidateContext);
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.log(Level.FINE, "Manifest ref[" + reference.getURI() + "] is valid: " + (n5 != 0));
                    }
                }
            }
        }
        this.validationStatus = n;
        this.validated = true;
        return this.validationStatus;
    }

    public void sign(XMLSignContext xMLSignContext) throws MarshalException, XMLSignatureException {
        Object object;
        int n;
        if (xMLSignContext == null) {
            throw new NullPointerException("signContext cannot be null");
        }
        DOMSignContext dOMSignContext = (DOMSignContext)xMLSignContext;
        if (dOMSignContext != null) {
            this.marshal(dOMSignContext.getParent(), dOMSignContext.getNextSibling(), DOMUtils.getSignaturePrefix(dOMSignContext), dOMSignContext);
        }
        ArrayList<Reference> arrayList = new ArrayList<Reference>(this.si.getReferences());
        this.signatureIdMap = new HashMap();
        this.signatureIdMap.put(this.id, this);
        this.signatureIdMap.put(this.si.getId(), this.si);
        List list2 = this.si.getReferences();
        int n2 = list2.size();
        for (n = 0; n < n2; ++n) {
            object = (Reference)list2.get(n);
            this.signatureIdMap.put(object.getId(), object);
        }
        n2 = this.objects.size();
        for (n = 0; n < n2; ++n) {
            object = (XMLObject)this.objects.get(n);
            this.signatureIdMap.put(object.getId(), object);
            List list3 = object.getContent();
            int n3 = list3.size();
            for (int i = 0; i < n3; ++i) {
                XMLStructure xMLStructure = (XMLStructure)list3.get(i);
                if (!(xMLStructure instanceof Manifest)) continue;
                Manifest manifest2 = (Manifest)xMLStructure;
                this.signatureIdMap.put(manifest2.getId(), manifest2);
                List list4 = manifest2.getReferences();
                int n4 = list4.size();
                for (int j = 0; j < n4; ++j) {
                    Reference reference = (Reference)list4.get(j);
                    arrayList.add(reference);
                    this.signatureIdMap.put(reference.getId(), reference);
                }
            }
        }
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = (DOMReference)arrayList.get(n);
            this.digestReference((DOMReference)object, xMLSignContext);
        }
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = (DOMReference)arrayList.get(n);
            if (((DOMReference)object).isDigested()) continue;
            ((DOMReference)object).digest(xMLSignContext);
        }
        Key key = null;
        KeySelectorResult keySelectorResult = null;
        try {
            keySelectorResult = xMLSignContext.getKeySelector().select(this.ki, KeySelector.Purpose.SIGN, this.si.getSignatureMethod(), xMLSignContext);
            key = keySelectorResult.getKey();
            if (key == null) {
                throw new XMLSignatureException("the keySelector did not find a signing key");
            }
        }
        catch (KeySelectorException keySelectorException) {
            throw new XMLSignatureException("cannot find signing key", keySelectorException);
        }
        object = null;
        try {
            object = ((DOMSignatureMethod)this.si.getSignatureMethod()).sign(key, (DOMSignedInfo)this.si, xMLSignContext);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException(invalidKeyException);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "SignatureValue = " + object);
        }
        ((DOMSignatureValue)this.sv).setValue((byte[])object);
        this.localSigElem = this.sigElem;
        this.ksr = keySelectorResult;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (!(object instanceof XMLSignature)) {
            return false;
        }
        XMLSignature xMLSignature = (XMLSignature)object;
        boolean bl2 = this.id == null ? xMLSignature.getId() == null : (bl = this.id.equals(xMLSignature.getId()));
        boolean bl3 = this.ki == null ? xMLSignature.getKeyInfo() == null : this.ki.equals(xMLSignature.getKeyInfo());
        return bl && bl3 && this.sv.equals(xMLSignature.getSignatureValue()) && this.si.equals(xMLSignature.getSignedInfo()) && ((Object)this.objects).equals(xMLSignature.getObjects());
    }

    public int hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 54;
    }

    private void digestReference(DOMReference dOMReference, XMLSignContext xMLSignContext) throws XMLSignatureException {
        if (dOMReference.isDigested()) {
            return;
        }
        String string2 = dOMReference.getURI();
        if (Utils.sameDocumentURI(string2)) {
            List<Object> list2;
            String string3 = Utils.parseIdFromSameDocumentURI(string2);
            if (string3 != null && this.signatureIdMap.containsKey(string3)) {
                list2 = this.signatureIdMap.get(string3);
                if (list2 instanceof DOMReference) {
                    this.digestReference((DOMReference)((Object)list2), xMLSignContext);
                } else if (list2 instanceof Manifest) {
                    Manifest manifest2 = (Manifest)((Object)list2);
                    List list3 = manifest2.getReferences();
                    int n = list3.size();
                    for (int i = 0; i < n; ++i) {
                        this.digestReference((DOMReference)list3.get(i), xMLSignContext);
                    }
                }
            }
            if (string2.length() == 0) {
                list2 = dOMReference.getTransforms();
                int n = list2.size();
                for (int i = 0; i < n; ++i) {
                    Transform transform2 = (Transform)list2.get(i);
                    String string4 = transform2.getAlgorithm();
                    if (!string4.equals("http://www.w3.org/TR/1999/REC-xpath-19991116") && !string4.equals("http://www.w3.org/2002/06/xmldsig-filter2")) continue;
                    return;
                }
            }
        }
        dOMReference.digest(xMLSignContext);
    }

    static {
        $assertionsDisabled = !DOMXMLSignature.class.desiredAssertionStatus();
        log = Logger.getLogger("org.jcp.xml.dsig.internal.dom");
        Init.init();
    }

    public class DOMSignatureValue
    extends DOMStructure
    implements XMLSignature.SignatureValue {
        private String id;
        private byte[] value;
        private String valueBase64;
        private Element sigValueElem;
        private boolean validated = false;
        private boolean validationStatus;

        DOMSignatureValue(String string2) {
            this.id = string2;
        }

        DOMSignatureValue(Element element2) throws MarshalException {
            try {
                this.value = Base64.decode(element2);
            }
            catch (Base64DecodingException base64DecodingException) {
                throw new MarshalException(base64DecodingException);
            }
            this.id = DOMUtils.getAttributeValue(element2, "Id");
            this.sigValueElem = element2;
        }

        public String getId() {
            return this.id;
        }

        public byte[] getValue() {
            return this.value == null ? null : (byte[])this.value.clone();
        }

        public boolean validate(XMLValidateContext xMLValidateContext) throws XMLSignatureException {
            KeySelectorResult keySelectorResult;
            if (xMLValidateContext == null) {
                throw new NullPointerException("context cannot be null");
            }
            if (this.validated) {
                return this.validationStatus;
            }
            SignatureMethod signatureMethod = DOMXMLSignature.this.si.getSignatureMethod();
            Key key = null;
            try {
                keySelectorResult = xMLValidateContext.getKeySelector().select(DOMXMLSignature.this.ki, KeySelector.Purpose.VERIFY, signatureMethod, xMLValidateContext);
                key = keySelectorResult.getKey();
                if (key == null) {
                    throw new XMLSignatureException("the keyselector did not find a validation key");
                }
            }
            catch (KeySelectorException keySelectorException) {
                throw new XMLSignatureException("cannot find validation key", keySelectorException);
            }
            try {
                this.validationStatus = ((DOMSignatureMethod)signatureMethod).verify(key, (DOMSignedInfo)DOMXMLSignature.this.si, this.value, xMLValidateContext);
            }
            catch (Exception exception) {
                throw new XMLSignatureException(exception);
            }
            this.validated = true;
            DOMXMLSignature.this.ksr = keySelectorResult;
            return this.validationStatus;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof XMLSignature.SignatureValue)) {
                return false;
            }
            XMLSignature.SignatureValue signatureValue = (XMLSignature.SignatureValue)object;
            boolean bl = this.id == null ? signatureValue.getId() == null : this.id.equals(signatureValue.getId());
            return bl;
        }

        public int hashCode() {
            return 55;
        }

        public void marshal(Node node4, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
            this.sigValueElem = DOMUtils.createElement(DOMXMLSignature.this.ownerDoc, "SignatureValue", "http://www.w3.org/2000/09/xmldsig#", string2);
            if (this.valueBase64 != null) {
                this.sigValueElem.appendChild(DOMXMLSignature.this.ownerDoc.createTextNode(this.valueBase64));
            }
            DOMUtils.setAttributeID(this.sigValueElem, "Id", this.id);
            node4.appendChild(this.sigValueElem);
        }

        void setValue(byte[] byArray) {
            this.value = byArray;
            this.valueBase64 = Base64.encode(byArray);
            this.sigValueElem.appendChild(DOMXMLSignature.this.ownerDoc.createTextNode(this.valueBase64));
        }
    }
}

