/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.DigestMethodParameterSpec;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.jcp.xml.dsig.internal.dom.DOMCanonicalizationMethod;
import org.jcp.xml.dsig.internal.dom.DOMDigestMethod;
import org.jcp.xml.dsig.internal.dom.DOMHMACSignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMManifest;
import org.jcp.xml.dsig.internal.dom.DOMReference;
import org.jcp.xml.dsig.internal.dom.DOMSignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMSignatureProperties;
import org.jcp.xml.dsig.internal.dom.DOMSignatureProperty;
import org.jcp.xml.dsig.internal.dom.DOMSignedInfo;
import org.jcp.xml.dsig.internal.dom.DOMTransform;
import org.jcp.xml.dsig.internal.dom.DOMURIDereferencer;
import org.jcp.xml.dsig.internal.dom.DOMXMLObject;
import org.jcp.xml.dsig.internal.dom.DOMXMLSignature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMXMLSignatureFactory
extends XMLSignatureFactory {
    public XMLSignature newXMLSignature(SignedInfo signedInfo, KeyInfo keyInfo) {
        return new DOMXMLSignature(signedInfo, keyInfo, null, null, null);
    }

    public XMLSignature newXMLSignature(SignedInfo signedInfo, KeyInfo keyInfo, List list2, String string2, String string3) {
        return new DOMXMLSignature(signedInfo, keyInfo, list2, string2, string3);
    }

    public Reference newReference(String string2, DigestMethod digestMethod) {
        return this.newReference(string2, digestMethod, null, null, null);
    }

    public Reference newReference(String string2, DigestMethod digestMethod, List list2, String string3, String string4) {
        return new DOMReference(string2, string3, digestMethod, list2, string4, this.getProvider());
    }

    public Reference newReference(String string2, DigestMethod digestMethod, List list2, Data data2, List list3, String string3, String string4) {
        if (list2 == null) {
            throw new NullPointerException("appliedTransforms cannot be null");
        }
        if (list2.isEmpty()) {
            throw new NullPointerException("appliedTransforms cannot be empty");
        }
        if (data2 == null) {
            throw new NullPointerException("result cannot be null");
        }
        return new DOMReference(string2, string3, digestMethod, list2, data2, list3, string4, this.getProvider());
    }

    public Reference newReference(String string2, DigestMethod digestMethod, List list2, String string3, String string4, byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("digestValue cannot be null");
        }
        return new DOMReference(string2, string3, digestMethod, null, null, list2, string4, byArray, this.getProvider());
    }

    public SignedInfo newSignedInfo(CanonicalizationMethod canonicalizationMethod, SignatureMethod signatureMethod, List list2) {
        return this.newSignedInfo(canonicalizationMethod, signatureMethod, list2, null);
    }

    public SignedInfo newSignedInfo(CanonicalizationMethod canonicalizationMethod, SignatureMethod signatureMethod, List list2, String string2) {
        return new DOMSignedInfo(canonicalizationMethod, signatureMethod, list2, string2);
    }

    public XMLObject newXMLObject(List list2, String string2, String string3, String string4) {
        return new DOMXMLObject(list2, string2, string3, string4);
    }

    public Manifest newManifest(List list2) {
        return this.newManifest(list2, null);
    }

    public Manifest newManifest(List list2, String string2) {
        return new DOMManifest(list2, string2);
    }

    public SignatureProperties newSignatureProperties(List list2, String string2) {
        return new DOMSignatureProperties(list2, string2);
    }

    public SignatureProperty newSignatureProperty(List list2, String string2, String string3) {
        return new DOMSignatureProperty(list2, string2, string3);
    }

    public XMLSignature unmarshalXMLSignature(XMLValidateContext xMLValidateContext) throws MarshalException {
        if (xMLValidateContext == null) {
            throw new NullPointerException("context cannot be null");
        }
        return this.unmarshal(((DOMValidateContext)xMLValidateContext).getNode(), xMLValidateContext);
    }

    public XMLSignature unmarshalXMLSignature(XMLStructure xMLStructure) throws MarshalException {
        if (xMLStructure == null) {
            throw new NullPointerException("xmlStructure cannot be null");
        }
        return this.unmarshal(((DOMStructure)xMLStructure).getNode(), null);
    }

    private XMLSignature unmarshal(Node node4, XMLValidateContext xMLValidateContext) throws MarshalException {
        node4.normalize();
        Element element2 = null;
        if (node4.getNodeType() == 9) {
            element2 = ((Document)node4).getDocumentElement();
        } else if (node4.getNodeType() == 1) {
            element2 = (Element)node4;
        } else {
            throw new MarshalException("Signature element is not a proper Node");
        }
        String string2 = element2.getLocalName();
        if (string2 == null) {
            throw new MarshalException("Document implementation must support DOM Level 2 and be namespace aware");
        }
        if (string2.equals("Signature")) {
            return new DOMXMLSignature(element2, xMLValidateContext, this.getProvider());
        }
        throw new MarshalException("invalid Signature tag: " + string2);
    }

    public boolean isFeatureSupported(String string2) {
        if (string2 == null) {
            throw new NullPointerException();
        }
        return false;
    }

    public DigestMethod newDigestMethod(String string2, DigestMethodParameterSpec digestMethodParameterSpec) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (string2 == null) {
            throw new NullPointerException();
        }
        if (string2.equals("http://www.w3.org/2000/09/xmldsig#sha1")) {
            return new DOMDigestMethod.SHA1(digestMethodParameterSpec);
        }
        if (string2.equals("http://www.w3.org/2001/04/xmlenc#sha256")) {
            return new DOMDigestMethod.SHA256(digestMethodParameterSpec);
        }
        if (string2.equals("http://www.w3.org/2001/04/xmldsig-more#sha384")) {
            return new DOMDigestMethod.SHA384(digestMethodParameterSpec);
        }
        if (string2.equals("http://www.w3.org/2001/04/xmlenc#sha512")) {
            return new DOMDigestMethod.SHA512(digestMethodParameterSpec);
        }
        throw new NoSuchAlgorithmException("unsupported algorithm");
    }

    public SignatureMethod newSignatureMethod(String string2, SignatureMethodParameterSpec signatureMethodParameterSpec) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (string2 == null) {
            throw new NullPointerException();
        }
        if (string2.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
            return new DOMSignatureMethod.SHA1withRSA(signatureMethodParameterSpec);
        }
        if (string2.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256")) {
            return new DOMSignatureMethod.SHA256withRSA(signatureMethodParameterSpec);
        }
        if (string2.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384")) {
            return new DOMSignatureMethod.SHA384withRSA(signatureMethodParameterSpec);
        }
        if (string2.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512")) {
            return new DOMSignatureMethod.SHA512withRSA(signatureMethodParameterSpec);
        }
        if (string2.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
            return new DOMSignatureMethod.SHA1withDSA(signatureMethodParameterSpec);
        }
        if (string2.equals("http://www.w3.org/2000/09/xmldsig#hmac-sha1")) {
            return new DOMHMACSignatureMethod.SHA1(signatureMethodParameterSpec);
        }
        if (string2.equals("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256")) {
            return new DOMHMACSignatureMethod.SHA256(signatureMethodParameterSpec);
        }
        if (string2.equals("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384")) {
            return new DOMHMACSignatureMethod.SHA384(signatureMethodParameterSpec);
        }
        if (string2.equals("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512")) {
            return new DOMHMACSignatureMethod.SHA512(signatureMethodParameterSpec);
        }
        throw new NoSuchAlgorithmException("unsupported algorithm");
    }

    public Transform newTransform(String string2, TransformParameterSpec transformParameterSpec) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        TransformService transformService;
        try {
            transformService = TransformService.getInstance(string2, "DOM");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            transformService = TransformService.getInstance(string2, "DOM", this.getProvider());
        }
        transformService.init(transformParameterSpec);
        return new DOMTransform(transformService);
    }

    public Transform newTransform(String string2, XMLStructure xMLStructure) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        TransformService transformService;
        try {
            transformService = TransformService.getInstance(string2, "DOM");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            transformService = TransformService.getInstance(string2, "DOM", this.getProvider());
        }
        if (xMLStructure == null) {
            transformService.init(null);
        } else {
            transformService.init(xMLStructure, null);
        }
        return new DOMTransform(transformService);
    }

    public CanonicalizationMethod newCanonicalizationMethod(String string2, C14NMethodParameterSpec c14NMethodParameterSpec) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        TransformService transformService;
        try {
            transformService = TransformService.getInstance(string2, "DOM");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            transformService = TransformService.getInstance(string2, "DOM", this.getProvider());
        }
        transformService.init(c14NMethodParameterSpec);
        return new DOMCanonicalizationMethod(transformService);
    }

    public CanonicalizationMethod newCanonicalizationMethod(String string2, XMLStructure xMLStructure) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        TransformService transformService;
        try {
            transformService = TransformService.getInstance(string2, "DOM");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            transformService = TransformService.getInstance(string2, "DOM", this.getProvider());
        }
        if (xMLStructure == null) {
            transformService.init(null);
        } else {
            transformService.init(xMLStructure, null);
        }
        return new DOMCanonicalizationMethod(transformService);
    }

    public URIDereferencer getURIDereferencer() {
        return DOMURIDereferencer.INSTANCE;
    }
}

