/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.HashMap;
import java.util.Map;

public final class MessageFormatter {
    static final char DELIM_START = '{';
    static final char DELIM_STOP = '}';
    static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    public static final String format(String messagePattern, Object arg) {
        return MessageFormatter.arrayFormat(messagePattern, new Object[]{arg});
    }

    public static final String format(String messagePattern, Object arg1, Object arg2) {
        return MessageFormatter.arrayFormat(messagePattern, new Object[]{arg1, arg2});
    }

    public static final String arrayFormat(String messagePattern, Object[] argArray) {
        if (messagePattern == null) {
            return null;
        }
        if (argArray == null) {
            return messagePattern;
        }
        int i = 0;
        StringBuffer sbuf = new StringBuffer(messagePattern.length() + 50);
        for (int L = 0; L < argArray.length; ++L) {
            int j = messagePattern.indexOf(DELIM_STR, i);
            if (j == -1) {
                if (i == 0) {
                    return messagePattern;
                }
                sbuf.append(messagePattern.substring(i, messagePattern.length()));
                return sbuf.toString();
            }
            if (MessageFormatter.isEscapedDelimeter(messagePattern, j)) {
                if (!MessageFormatter.isDoubleEscaped(messagePattern, j)) {
                    --L;
                    sbuf.append(messagePattern.substring(i, j - 1));
                    sbuf.append('{');
                    i = j + 1;
                    continue;
                }
                sbuf.append(messagePattern.substring(i, j - 1));
                MessageFormatter.deeplyAppendParameter(sbuf, argArray[L], new HashMap());
                i = j + 2;
                continue;
            }
            sbuf.append(messagePattern.substring(i, j));
            MessageFormatter.deeplyAppendParameter(sbuf, argArray[L], new HashMap());
            i = j + 2;
        }
        sbuf.append(messagePattern.substring(i, messagePattern.length()));
        return sbuf.toString();
    }

    static final boolean isEscapedDelimeter(String messagePattern, int delimeterStartIndex) {
        if (delimeterStartIndex == 0) {
            return false;
        }
        char potentialEscape = messagePattern.charAt(delimeterStartIndex - 1);
        return potentialEscape == '\\';
    }

    static final boolean isDoubleEscaped(String messagePattern, int delimeterStartIndex) {
        return delimeterStartIndex >= 2 && messagePattern.charAt(delimeterStartIndex - 2) == '\\';
    }

    private static void deeplyAppendParameter(StringBuffer sbuf, Object o, Map seenMap) {
        if (o == null) {
            sbuf.append("null");
            return;
        }
        if (!o.getClass().isArray()) {
            MessageFormatter.safeObjectAppend(sbuf, o);
        } else if (o instanceof boolean[]) {
            MessageFormatter.booleanArrayAppend(sbuf, (boolean[])o);
        } else if (o instanceof byte[]) {
            MessageFormatter.byteArrayAppend(sbuf, (byte[])o);
        } else if (o instanceof char[]) {
            MessageFormatter.charArrayAppend(sbuf, (char[])o);
        } else if (o instanceof short[]) {
            MessageFormatter.shortArrayAppend(sbuf, (short[])o);
        } else if (o instanceof int[]) {
            MessageFormatter.intArrayAppend(sbuf, (int[])o);
        } else if (o instanceof long[]) {
            MessageFormatter.longArrayAppend(sbuf, (long[])o);
        } else if (o instanceof float[]) {
            MessageFormatter.floatArrayAppend(sbuf, (float[])o);
        } else if (o instanceof double[]) {
            MessageFormatter.doubleArrayAppend(sbuf, (double[])o);
        } else {
            MessageFormatter.objectArrayAppend(sbuf, (Object[])o, seenMap);
        }
    }

    private static void safeObjectAppend(StringBuffer sbuf, Object o) {
        try {
            String oAsString = o.toString();
            sbuf.append(oAsString);
        }
        catch (Throwable t2) {
            System.err.println("SLF4J: Failed toString() invocation on an object of type [" + o.getClass().getName() + "]");
            t2.printStackTrace();
            sbuf.append("[FAILED toString()]");
        }
    }

    private static void objectArrayAppend(StringBuffer sbuf, Object[] a2, Map seenMap) {
        sbuf.append('[');
        if (!seenMap.containsKey(a2)) {
            seenMap.put(a2, null);
            int len2 = a2.length;
            for (int i = 0; i < len2; ++i) {
                MessageFormatter.deeplyAppendParameter(sbuf, a2[i], seenMap);
                if (i == len2 - 1) continue;
                sbuf.append(", ");
            }
            seenMap.remove(a2);
        } else {
            sbuf.append("...");
        }
        sbuf.append(']');
    }

    private static void booleanArrayAppend(StringBuffer sbuf, boolean[] a2) {
        sbuf.append('[');
        int len2 = a2.length;
        for (int i = 0; i < len2; ++i) {
            sbuf.append(a2[i]);
            if (i == len2 - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void byteArrayAppend(StringBuffer sbuf, byte[] a2) {
        sbuf.append('[');
        int len2 = a2.length;
        for (int i = 0; i < len2; ++i) {
            sbuf.append(a2[i]);
            if (i == len2 - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void charArrayAppend(StringBuffer sbuf, char[] a2) {
        sbuf.append('[');
        int len2 = a2.length;
        for (int i = 0; i < len2; ++i) {
            sbuf.append(a2[i]);
            if (i == len2 - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void shortArrayAppend(StringBuffer sbuf, short[] a2) {
        sbuf.append('[');
        int len2 = a2.length;
        for (int i = 0; i < len2; ++i) {
            sbuf.append(a2[i]);
            if (i == len2 - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void intArrayAppend(StringBuffer sbuf, int[] a2) {
        sbuf.append('[');
        int len2 = a2.length;
        for (int i = 0; i < len2; ++i) {
            sbuf.append(a2[i]);
            if (i == len2 - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void longArrayAppend(StringBuffer sbuf, long[] a2) {
        sbuf.append('[');
        int len2 = a2.length;
        for (int i = 0; i < len2; ++i) {
            sbuf.append(a2[i]);
            if (i == len2 - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void floatArrayAppend(StringBuffer sbuf, float[] a2) {
        sbuf.append('[');
        int len2 = a2.length;
        for (int i = 0; i < len2; ++i) {
            sbuf.append(a2[i]);
            if (i == len2 - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void doubleArrayAppend(StringBuffer sbuf, double[] a2) {
        sbuf.append('[');
        int len2 = a2.length;
        for (int i = 0; i < len2; ++i) {
            sbuf.append(a2[i]);
            if (i == len2 - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }
}

