/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.io;

import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import org.specs2.control.Exceptions$;
import org.specs2.io.MockFileSystem;
import org.specs2.xml.Nodex$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Predef$Pair$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.io.Source;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.parsing.XhtmlParser$;

public abstract class MockFileSystem$class {
    public static IndexedSeq readLines(MockFileSystem $this, String path2) {
        return Predef$.MODULE$.refArrayOps((Object[])$this.readFile(path2).split("\n")).toIndexedSeq();
    }

    public static String readFile(MockFileSystem $this, String path2) {
        return $this.files().apply(path2);
    }

    public static List filePaths(MockFileSystem $this, String basePath, String path2, boolean verbose) {
        return $this.files().keySet().toList();
    }

    public static String filePaths$default$1(MockFileSystem $this) {
        return ".";
    }

    public static String filePaths$default$2(MockFileSystem $this) {
        return "*";
    }

    public static boolean filePaths$default$3(MockFileSystem $this) {
        return false;
    }

    public static void addFile(MockFileSystem $this, String content2) {
        $this.addFile($this.defaultFilePath(), content2);
    }

    public static void addFile(MockFileSystem $this, String path2, String content2) {
        $this.files().$plus$eq((Tuple2)Predef$Pair$.MODULE$.apply(path2, content2));
        $this.readableFiles_$eq($this.readableFiles().$colon$colon(path2));
        $this.writableFiles_$eq($this.writableFiles().$colon$colon(path2));
    }

    public static void addChild(MockFileSystem $this, String parent2, String child) {
        Option<ListBuffer<String>> option;
        block4: {
            block3: {
                Serializable serializable2;
                block2: {
                    Some x2;
                    option = $this.children().get(parent2);
                    if (!(option instanceof Some) || (x2 = (Some)option) == null) break block2;
                    ListBuffer l = (ListBuffer)x2.x();
                    serializable2 = BoxedUnit.UNIT;
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<ListBuffer<String>> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                Option<ListBuffer<String>> x3 = option;
                serializable2 = $this.children().put(parent2, new ListBuffer());
            }
            $this.children().get(parent2).get().$plus$eq((Object)child);
            return;
        }
        throw new MatchError(option);
    }

    public static String setReadable(MockFileSystem $this, String path2) {
        if (!$this.canRead(path2)) {
            $this.readableFiles_$eq($this.readableFiles().$colon$colon(path2));
        }
        return path2;
    }

    public static String setWritable(MockFileSystem $this, String path2) {
        if (!$this.canWrite(path2)) {
            $this.writableFiles_$eq($this.writableFiles().$colon$colon(path2));
        }
        return path2;
    }

    public static String setNotReadable(MockFileSystem $this, String path2) {
        $this.readableFiles_$eq((List)$this.readableFiles().filterNot((Function1<String, Object>)((Object)new scala.Serializable($this, path2){
            public static final long serialVersionUID = 0L;
            private final String path$1;

            public final boolean apply(String x$1) {
                String string2 = x$1;
                String string3 = this.path$1;
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }
            {
                this.path$1 = path$1;
            }
        })));
        return path2;
    }

    public static String setNotWritable(MockFileSystem $this, String path2) {
        $this.writableFiles_$eq((List)$this.writableFiles().filterNot((Function1<String, Object>)((Object)new scala.Serializable($this, path2){
            public static final long serialVersionUID = 0L;
            private final String path$2;

            public final boolean apply(String x$2) {
                String string2 = x$2;
                String string3 = this.path$2;
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }
            {
                this.path$2 = path$2;
            }
        })));
        return path2;
    }

    public static boolean canRead(MockFileSystem $this, String path2) {
        return $this.readableFiles().exists((Function1<String, Object>)((Object)new scala.Serializable($this, path2){
            public static final long serialVersionUID = 0L;
            private final String path$3;

            public final boolean apply(String x$3) {
                String string2 = x$3;
                String string3 = this.path$3;
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }
            {
                this.path$3 = path$3;
            }
        }));
    }

    public static boolean canWrite(MockFileSystem $this, String path2) {
        return $this.writableFiles().exists((Function1<String, Object>)((Object)new scala.Serializable($this, path2){
            public static final long serialVersionUID = 0L;
            private final String path$4;

            public final boolean apply(String x$4) {
                String string2 = x$4;
                String string3 = this.path$4;
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }
            {
                this.path$4 = path$4;
            }
        }));
    }

    public static boolean isAbsolute(MockFileSystem $this, String path2) {
        return path2.startsWith("/") || path2.startsWith("\\");
    }

    public static boolean isHidden(MockFileSystem $this, String path2) {
        return path2.startsWith(".");
    }

    public static boolean isFile(MockFileSystem $this, String path2) {
        return path2.matches(".*\\..*");
    }

    public static boolean isDirectory(MockFileSystem $this, String path2) {
        return !$this.isFile(path2);
    }

    public static List listFiles(MockFileSystem $this, String path2) {
        return $this.children().get(path2.replaceAll("\\\\", "/")).map(new scala.Serializable($this){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(ListBuffer<String> x$5) {
                return x$5.toList();
            }
        }).getOrElse(new scala.Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        });
    }

    public static String defaultFilePath(MockFileSystem $this) {
        return new StringBuilder().append((Object)"name").append(BoxesRunTime.boxToInteger($this.files().size())).append((Object)$this.defaultExtension()).toString();
    }

    public static boolean createFile(MockFileSystem $this, String path2) {
        $this.files().$plus$eq((Tuple2)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(path2), ""));
        return true;
    }

    public static boolean delete(MockFileSystem $this, String path2) {
        $this.files().$minus$eq((Object)path2);
        return true;
    }

    public static boolean mkdirs(MockFileSystem $this, String path2) {
        String string2 = path2;
        $this.createdDirs_$eq($this.createdDirs().$colon$colon(string2));
        return true;
    }

    public static boolean createDir(MockFileSystem $this, String path2) {
        return $this.mkdirs(path2);
    }

    public static MockFileSystem.MockFileWriter getWriter(MockFileSystem $this, String path2, boolean append2) {
        return new MockFileSystem.MockFileWriter($this, path2);
    }

    public static boolean getWriter$default$2(MockFileSystem $this) {
        return false;
    }

    public static MockFileSystem reset(MockFileSystem $this) {
        $this.files_$eq(new HashMap<String, String>());
        $this.children_$eq(new HashMap<String, ListBuffer<String>>());
        $this.readableFiles_$eq(Nil$.MODULE$);
        $this.writableFiles_$eq(Nil$.MODULE$);
        return $this;
    }

    public static boolean exists(MockFileSystem $this, String path2) {
        return $this.files().keys().exists((Function1<String, Object>)((Object)new scala.Serializable($this, path2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MockFileSystem $outer;
            private final String path$5;

            public final boolean apply(String f2) {
                return this.$outer.samePath(f2, this.path$5);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.path$5 = path$5;
            }
        }));
    }

    public static InputStream inputStream(MockFileSystem $this, String filePath) {
        return new InputStream($this, filePath){
            private final StringReader reader;

            private StringReader reader() {
                return this.reader;
            }

            public int read() {
                return this.reader().read();
            }
            {
                this.reader = new StringReader($outer.readFile(filePath$1));
            }
        };
    }

    public static NodeSeq loadXmlFile(MockFileSystem $this, String filePath, Function1 report2) {
        return Exceptions$.MODULE$.tryo(new scala.Serializable($this, filePath){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MockFileSystem $outer;
            private final String filePath$2;

            public final NodeSeq apply() {
                Source xhtml = Source$.MODULE$.fromString(new StringBuilder().append((Object)"<e>").append((Object)this.$outer.readFile(this.filePath$2)).append((Object)"</e>").toString());
                return Nodex$.MODULE$.reducable(XhtmlParser$.MODULE$.apply(xhtml).$bslash$bslash("e").apply(0).child()).reduceNodes();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.filePath$2 = filePath$2;
            }
        }, (Function1<Exception, BoxedUnit>)((Object)new scala.Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(Object t2) {
                Exceptions$.MODULE$.implicitUnit(t2);
            }
        })).getOrElse(new scala.Serializable($this){
            public static final long serialVersionUID = 0L;

            public final NodeSeq apply() {
                return NodeSeq$.MODULE$.Empty();
            }
        });
    }

    public static Function1 loadXmlFile$default$2(MockFileSystem $this, String filePath) {
        return new scala.Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(Exception e2) {
                e2.printStackTrace();
            }
        };
    }

    public static void $init$(MockFileSystem $this) {
        $this.defaultExtension_$eq("");
        $this.files_$eq(new HashMap<String, String>());
        $this.createdDirs_$eq(Nil$.MODULE$);
        $this.children_$eq(new HashMap<String, ListBuffer<String>>());
        $this.readableFiles_$eq(Nil$.MODULE$);
        $this.writableFiles_$eq(Nil$.MODULE$);
    }
}

