/*
 * Decompiled with CFR 0.152.
 */
package org.spin.identity;

import org.apache.log4j.Logger;
import org.spin.identity.IdentityService;
import org.spin.identity.IdentityServiceException;
import org.spin.tools.ClassTools;
import org.spin.tools.DynamicLoadingException;
import org.spin.tools.Util;
import org.spin.tools.config.NodeConfig;
import org.spin.tools.crypto.signature.Identity;

public final class LazyIdentityService
implements IdentityService {
    private static final Logger log = Logger.getLogger(LazyIdentityService.class);
    private static final boolean INFO = log.isInfoEnabled();
    private final NodeConfig config;
    private volatile IdentityService delegate = null;
    private final boolean isAuthenticator;
    private final Object lock = new Object();

    LazyIdentityService(NodeConfig config) {
        Util.guardNotNull(config);
        Util.guardNotNull(config.isAuthenticator());
        this.config = config;
        this.isAuthenticator = config.isAuthenticator();
    }

    IdentityService getDelegate() {
        return this.delegate;
    }

    @Override
    public Identity certify(String domain, String username, String password) throws IdentityServiceException {
        if (this.isAuthenticator) {
            this.initDelegate();
            return this.delegate.certify(domain, username, password);
        }
        if (INFO) {
            log.info("certify() invoked on an IdentityService not configured as an authenticator; returning null.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void initDelegate() throws IdentityServiceException {
        Object object = this.lock;
        synchronized (object) {
            if (this.delegate == null) {
                Util.guardNotNull(this.config.getIdentityServiceClass());
                try {
                    this.delegate = ClassTools.createInstance(this.config.getIdentityServiceClass(), IdentityService.class);
                }
                catch (DynamicLoadingException e2) {
                    throw new IdentityServiceException(e2);
                }
            }
        }
    }
}

