/*
 * Decompiled with CFR 0.152.
 */
package org.spin.message;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.spin.message.HasOrigin;
import org.spin.message.StatusCode;
import org.spin.tools.Util;
import org.spin.tools.crypto.signature.CertID;

@XmlType(name="AckNack")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
@XmlSeeAlso(value={StatusCode.class})
public final class AckNack
implements Serializable,
HasOrigin {
    private static final long serialVersionUID = 1L;
    @XmlElement(required=true, name="queryID")
    private final String queryId;
    @XmlElement(required=true)
    private final CertID origin;
    @XmlElement(required=true)
    private final Set<StatusCode> statuses = EnumSet.noneOf(StatusCode.class);
    private static final CertID dummyCertId = new CertID("-1", "DUMMY");

    private AckNack() {
        this("DUMMY QUERY ID", dummyCertId, Collections.emptyList());
    }

    public AckNack(String queryId, CertID origin2, Collection<StatusCode> statuses) {
        Util.guardNotNull(queryId);
        Util.guardNotNull(origin2);
        Util.guardNotNull(statuses);
        this.queryId = queryId;
        this.origin = origin2;
        this.statuses.addAll(statuses);
    }

    public AckNack(String queryId, CertID origin2, StatusCode ... statuses) {
        this(queryId, origin2, Arrays.asList(statuses));
    }

    public static AckNack copyOf(AckNack other) {
        if (other == null) {
            return null;
        }
        return new AckNack(other.queryId, other.origin, other.statuses);
    }

    @Override
    public boolean isFor(CertID nodeId) {
        return this.origin.equals(nodeId);
    }

    public String getQueryId() {
        return this.queryId;
    }

    @Override
    public CertID getOrigin() {
        return this.origin;
    }

    public Set<StatusCode> getStatuses() {
        return this.statuses;
    }

    public void addStatus(StatusCode ... statusCodes) {
        Util.guardNotNull(statusCodes);
        this.addStatuses(Arrays.asList(statusCodes));
    }

    public void addStatuses(Collection<StatusCode> statusCodes) {
        Util.guardNotNull(statusCodes);
        this.statuses.addAll(statusCodes);
    }

    public final boolean isOk() {
        return !this.isError();
    }

    public final boolean isError() {
        for (StatusCode statusCode : this.statuses) {
            if (!statusCode.isError()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "AckNack [queryID=" + this.queryId + ", origin=" + this.origin + ", statuses=" + this.statuses + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.origin == null ? 0 : this.origin.hashCode());
        result2 = 31 * result2 + (this.queryId == null ? 0 : this.queryId.hashCode());
        result2 = 31 * result2 + (this.statuses == null ? 0 : this.statuses.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AckNack other = (AckNack)obj;
        if (this.origin == null ? other.origin != null : !this.origin.equals(other.origin)) {
            return false;
        }
        if (this.queryId == null ? other.queryId != null : !this.queryId.equals(other.queryId)) {
            return false;
        }
        return !(this.statuses == null ? other.statuses != null : !this.statuses.equals(other.statuses));
    }
}

