/*
 * Decompiled with CFR 0.152.
 */
package org.spin.message;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.message.FailureBroadcastResult;
import org.spin.message.GoodBroadcastResult;
import org.spin.message.StatusCode;
import org.spin.message.TimeoutBroadcastResult;
import org.spin.tools.Util;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="BroadcastResults")
@XmlRootElement
public final class BroadcastResults {
    private final String url;
    private final List<GoodBroadcastResult> successes = Util.makeArrayList();
    private final List<FailureBroadcastResult> errors = Util.makeArrayList();
    private final List<TimeoutBroadcastResult> timeouts = Util.makeArrayList();

    public static final BroadcastResults empty(String url) {
        return new BroadcastResults(url, Collections.<GoodBroadcastResult>emptyList(), Collections.<FailureBroadcastResult>emptyList(), Collections.<TimeoutBroadcastResult>emptyList());
    }

    private BroadcastResults() {
        this(null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public BroadcastResults(String url, List<GoodBroadcastResult> successes, List<FailureBroadcastResult> errors, List<TimeoutBroadcastResult> timeouts) {
        this.url = url;
        this.successes.addAll(successes);
        this.errors.addAll(errors);
        this.timeouts.addAll(timeouts);
    }

    public List<GoodBroadcastResult> getSuccesses() {
        return this.successes;
    }

    public List<FailureBroadcastResult> getErrors() {
        return this.errors;
    }

    public List<TimeoutBroadcastResult> getTimeouts() {
        return this.timeouts;
    }

    public int getTotalBroadcastTo() {
        return this.successes.size() + this.errors.size() + this.timeouts.size();
    }

    public String getUrl() {
        return this.url;
    }

    public Set<StatusCode> getStatuses() {
        EnumSet<StatusCode> toReturn = EnumSet.noneOf(StatusCode.class);
        for (GoodBroadcastResult goodResult : this.getSuccesses()) {
            toReturn.addAll(goodResult.getAckNack().getStatuses());
        }
        return toReturn;
    }

    public void addAll(BroadcastResults other) {
        Util.guardNotNull(other);
        this.successes.addAll(other.successes);
        this.errors.addAll(other.errors);
        this.timeouts.addAll(other.timeouts);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.errors == null ? 0 : this.errors.hashCode());
        result2 = 31 * result2 + (this.successes == null ? 0 : this.successes.hashCode());
        result2 = 31 * result2 + (this.timeouts == null ? 0 : this.timeouts.hashCode());
        result2 = 31 * result2 + (this.url == null ? 0 : this.url.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BroadcastResults other = (BroadcastResults)obj;
        if (this.errors == null ? other.errors != null : !this.errors.equals(other.errors)) {
            return false;
        }
        if (this.successes == null ? other.successes != null : !this.successes.equals(other.successes)) {
            return false;
        }
        if (this.timeouts == null ? other.timeouts != null : !this.timeouts.equals(other.timeouts)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public String toString() {
        return "BroadcastResults [url=" + this.url + ", successes=" + this.successes + ", errors=" + this.errors + ", timeouts=" + this.timeouts + "]";
    }

    public static BroadcastResults copyOf(BroadcastResults broadcastResults) {
        if (broadcastResults == null) {
            return null;
        }
        return new BroadcastResults(broadcastResults.url, Util.makeArrayList(broadcastResults.successes), Util.makeArrayList(broadcastResults.errors), Util.makeArrayList(broadcastResults.timeouts));
    }
}

