/*
 * Decompiled with CFR 0.152.
 */
package org.spin.message;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.tools.crypto.signature.CertID;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Encryption")
@XmlRootElement
public class EncryptionParams {
    public static final EncryptionParams NoEncryption = new NoEncryptionParams();
    final CertID encryptFor;

    public static final EncryptionParams encryptFor(CertID encryptFor) {
        if (encryptFor == null) {
            return NoEncryption;
        }
        return new EncryptionParams(encryptFor);
    }

    private EncryptionParams() {
        this((CertID)null);
    }

    private EncryptionParams(CertID encryptFor) {
        this.encryptFor = encryptFor;
    }

    public final boolean encryptionRequested() {
        return this.encryptFor != null;
    }

    public final CertID getEncryptFor() {
        return this.encryptFor;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.encryptFor == null ? 0 : this.encryptFor.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionParams)) {
            return false;
        }
        EncryptionParams other = (EncryptionParams)obj;
        return !(this.encryptFor == null ? other.encryptFor != null : !this.encryptFor.equals(other.encryptFor));
    }

    public String toString() {
        return "EncryptionParams [encryptFor=" + this.encryptFor + "]";
    }

    @XmlRootElement
    private static final class NoEncryptionParams
    extends EncryptionParams {
        NoEncryptionParams() {
        }

        @Override
        public String toString() {
            return "NoEncryption";
        }
    }
}

