/*
 * Decompiled with CFR 0.152.
 */
package org.spin.message;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.message.Response;
import org.spin.tools.Interval;
import org.spin.tools.config.ConfigException;
import org.spin.tools.crypto.Envelope;
import org.spin.tools.crypto.PKITool;
import org.spin.tools.crypto.signature.CertID;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Result")
@XmlRootElement
public final class Result
extends Response {
    public static final Result Null = new Result();
    private final Envelope payload;
    private final Interval executionTime;

    private Result() {
        this(null, null, null, null);
    }

    public Result(CertID origin2, Envelope payload, Interval executionTime) {
        this(origin2, null, payload, executionTime);
    }

    public Result(CertID origin2, String description2, Envelope payload, Interval executionTime) {
        super(origin2, description2);
        this.payload = payload;
        this.executionTime = executionTime;
    }

    public static final Result of(Envelope payload, Interval executionTime) throws ConfigException {
        return Result.of(PKITool.getInstance().getMyCertID(), payload, executionTime);
    }

    public static final Result of(String payload, Interval executionTime) throws ConfigException {
        return Result.of(Envelope.unencrypted(payload), executionTime);
    }

    public static final Result of(CertID origin2, Envelope payload, Interval executionTime) {
        return Result.of(origin2, null, payload, executionTime);
    }

    public static final Result of(CertID origin2, String description2, Envelope payload, Interval executionTime) {
        return new Result(origin2, description2, payload, executionTime);
    }

    public static final Result of(CertID origin2, String payload, Interval executionTime) {
        return Result.of(origin2, null, payload, executionTime);
    }

    public static final Result of(CertID origin2, String description2, String payload, Interval executionTime) {
        return Result.of(origin2, description2, Envelope.unencrypted(payload), executionTime);
    }

    @Override
    public boolean isFailure() {
        return false;
    }

    public final boolean isEncrypted() {
        return this.payload.getEncryptedFor() != null;
    }

    public final boolean isSigned() {
        return this.payload.isSigned();
    }

    public final Envelope getPayload() {
        return this.payload;
    }

    public Result withPayload(Envelope newPayload) {
        return new Result(this.origin, this.description, newPayload, this.executionTime);
    }

    public Interval getExecutionTime() {
        return this.executionTime;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.origin == null ? 0 : this.origin.hashCode());
        result2 = 31 * result2 + (this.payload == null ? 0 : this.payload.hashCode());
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Result other = (Result)obj;
        if (this.origin == null ? other.origin != null : !this.origin.equals(other.origin)) {
            return false;
        }
        return !(this.payload == null ? other.payload != null : !this.payload.equals(other.payload));
    }

    public String toString() {
        return "Result [getOrigin()=" + this.getOrigin() + ", executionTime=" + this.executionTime + ", description=" + this.description + ", payload= " + this.payload.getData().length() + " chars]";
    }
}

