/*
 * Decompiled with CFR 0.152.
 */
package org.spin.message;

import java.util.Collection;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.message.Failure;
import org.spin.message.Response;
import org.spin.message.Result;
import org.spin.tools.ConcatenatedIterator;
import org.spin.tools.Util;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ResultSet")
@XmlRootElement
public final class ResultSet
implements Iterable<Response> {
    private final String queryID;
    private final boolean complete;
    private final Integer totalExpected;
    private final Collection<Result> results = Util.makeArrayList();
    private final Collection<Failure> failures = Util.makeArrayList();

    public static ResultSet of(String queryID, boolean complete2, Integer total2, Collection<Result> results2, Collection<Failure> failures) {
        return new ResultSet(queryID, complete2, total2, results2, failures);
    }

    private ResultSet() {
        this(null, false, null, null, null);
    }

    private ResultSet(String queryID, boolean complete2, Integer totalExpected, Collection<Result> results2, Collection<Failure> failures) {
        this.queryID = queryID;
        this.complete = complete2;
        this.totalExpected = totalExpected;
        if (results2 != null) {
            this.results.addAll(results2);
        }
        if (failures != null) {
            this.failures.addAll(failures);
        }
    }

    public boolean totalIsKnown() {
        return this.totalExpected != null;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public int size() {
        return this.results.size() + this.failures.size();
    }

    @Override
    public Iterator<Response> iterator() {
        return ConcatenatedIterator.from(this.results.iterator(), this.failures.iterator());
    }

    public Integer getTotalExpected() {
        return this.totalExpected;
    }

    public Collection<Result> getResults() {
        return this.results;
    }

    public Collection<Failure> getFailures() {
        return this.failures;
    }

    public String getQueryID() {
        return this.queryID;
    }

    public ResultSet withResults(Collection<Result> newResults) {
        return new ResultSet(this.queryID, this.complete, this.totalExpected, newResults, this.failures);
    }

    public ResultSet withErrors(Collection<Failure> newFailures) {
        return new ResultSet(this.queryID, this.complete, this.totalExpected, this.results, newFailures);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.complete ? 1231 : 1237);
        result2 = 31 * result2 + (this.failures == null ? 0 : this.failures.hashCode());
        result2 = 31 * result2 + (this.queryID == null ? 0 : this.queryID.hashCode());
        result2 = 31 * result2 + (this.results == null ? 0 : this.results.hashCode());
        result2 = 31 * result2 + (this.totalExpected == null ? 0 : this.totalExpected.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResultSet other = (ResultSet)obj;
        if (this.complete != other.complete) {
            return false;
        }
        if (this.failures == null ? other.failures != null : !this.failures.equals(other.failures)) {
            return false;
        }
        if (this.queryID == null ? other.queryID != null : !this.queryID.equals(other.queryID)) {
            return false;
        }
        if (this.results == null ? other.results != null : !this.results.equals(other.results)) {
            return false;
        }
        return !(this.totalExpected == null ? other.totalExpected != null : !this.totalExpected.equals(other.totalExpected));
    }

    public String toString() {
        return "ResultSet [queryID=" + this.queryID + ", complete=" + this.complete + ", totalExpected=" + this.totalExpected + ", results=" + this.results + ", failures=" + this.failures + "]";
    }
}

