/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.spin.node.QueryActionMap;
import org.spin.node.UnknownQueryTypeException;

public abstract class DestroyableQueryActionMap
implements QueryActionMap {
    private static final Logger log = Logger.getLogger(DestroyableQueryActionMap.class);
    private volatile boolean isDestroyed = false;
    protected final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.lock.lock();
        try {
            for (String queryType : this.getQueryTypes()) {
                try {
                    this.getQueryAction(queryType).destroy();
                }
                catch (UnknownQueryTypeException e2) {
                    log.error("Error destroying unknown query '" + queryType + "'");
                }
            }
            this.isDestroyed = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        this.lock.lock();
        try {
            boolean bl = this.isDestroyed;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

