/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import org.spin.node.QueryActionMap;
import org.spin.node.UnknownQueryTypeException;
import org.spin.node.cache.ReadOnlyResultStore;
import org.spin.tools.Util;
import org.spin.tools.config.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ModuleVersionInfo")
@XmlRootElement
public final class ModuleVersionInfo {
    private static final Logger log = Logger.getLogger(ModuleVersionInfo.class);
    private final Map<String, String> mapModuleToVersion = Util.makeHashMap();
    private final String resultStoreClassName;

    private ModuleVersionInfo() {
        this.resultStoreClassName = null;
    }

    public ModuleVersionInfo(Class<?> clazz2, ReadOnlyResultStore readOnlyResultStore, QueryActionMap queryActionMap) {
        Field[] fields;
        this.resultStoreClassName = readOnlyResultStore != null ? readOnlyResultStore.getClass().getSimpleName() : null;
        for (Field field2 : fields = clazz2.getDeclaredFields()) {
            Class<?> fieldClass = field2.getType();
            String fieldClassName = fieldClass.getName();
            if (!fieldClassName.startsWith("org.spin")) continue;
            this.mapModuleToVersion.put(Version.getModule(fieldClass), Version.getVersion(fieldClass));
        }
        this.mapModuleToVersion.put(Version.getModule(clazz2), Version.getVersion(clazz2));
        ArrayList<String> queryMapTypes = Util.makeArrayList();
        queryMapTypes.addAll(queryActionMap.getQueryTypes());
        for (String queryType : queryMapTypes) {
            try {
                Class<?> queryActionClass = queryActionMap.getQueryAction(queryType).getClass();
                this.mapModuleToVersion.put(Version.getModule(queryActionClass), Version.getVersion(queryActionClass));
            }
            catch (UnknownQueryTypeException e2) {
                log.warn("Initializing versionInfo, unknown query type '" + e2.getMessage() + "': is another thread modifying the QueryMap?");
            }
        }
    }

    public final Map<String, String> getModuleNameToVersion() {
        return Util.makeHashMap(this.mapModuleToVersion);
    }

    public final String getResultStoreClassName() {
        return this.resultStoreClassName;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.resultStoreClassName == null ? 0 : this.resultStoreClassName.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleVersionInfo other = (ModuleVersionInfo)obj;
        return !(this.resultStoreClassName == null ? other.resultStoreClassName != null : !this.resultStoreClassName.equals(other.resultStoreClassName));
    }
}

