/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node;

import org.spin.node.HasNodeConfig;
import org.spin.node.HasNodeID;
import org.spin.node.HasNodeURL;
import org.spin.node.HasQueryMap;
import org.spin.node.HasRoutingTable;
import org.spin.node.QueryActionMap;
import org.spin.tools.Util;
import org.spin.tools.config.NodeConfig;
import org.spin.tools.config.RoutingTable;
import org.spin.tools.crypto.signature.CertID;

public abstract class NodeContext
implements HasNodeURL,
HasNodeID,
HasNodeConfig,
HasRoutingTable,
HasQueryMap {
    public static final NodeContext Null = new LiteralNodeContext(null, null, null, null, null);

    protected NodeContext() {
    }

    public static NodeContext withNodeConfig(final NodeConfig nodeConfig, NodeContext delegate) {
        Util.guardNotNull(delegate);
        return new DelegatingNodeContext(delegate){

            @Override
            public NodeConfig getNodeConfig() {
                return nodeConfig;
            }
        };
    }

    public static NodeContext withNodeURLSource(final HasNodeURL nodeURLSource, NodeContext delegate) {
        Util.guardNotNull(nodeURLSource);
        Util.guardNotNull(delegate);
        return new DelegatingNodeContext(delegate){

            @Override
            public String getNodeURL() {
                return nodeURLSource.getNodeURL();
            }
        };
    }

    public static NodeContext instance(String nodeURL, CertID nodeID, NodeConfig nodeConfig, HasRoutingTable routingTableSource, QueryActionMap queryMap) {
        return new LiteralNodeContext(nodeURL, nodeID, nodeConfig, routingTableSource, queryMap);
    }

    public static NodeContext instance(final HasNodeURL nodeURLSource, CertID nodeID, NodeConfig nodeConfig, HasRoutingTable routingTableSource, QueryActionMap queryMap) {
        Util.guardNotNull(nodeURLSource);
        return new LiteralNodeContext(null, nodeID, nodeConfig, routingTableSource, queryMap){

            @Override
            public String getNodeURL() {
                return nodeURLSource.getNodeURL();
            }
        };
    }

    private static class DelegatingNodeContext
    extends NodeContext {
        final NodeContext delegate;

        DelegatingNodeContext(NodeContext delegate) {
            Util.guardNotNull(delegate);
            this.delegate = delegate;
        }

        @Override
        public String getNodeURL() {
            return this.delegate.getNodeURL();
        }

        @Override
        public NodeConfig getNodeConfig() {
            return this.delegate.getNodeConfig();
        }

        @Override
        public CertID getNodeID() {
            return this.delegate.getNodeID();
        }

        @Override
        public RoutingTable getRoutingTable() {
            return this.delegate.getRoutingTable();
        }

        @Override
        public QueryActionMap getQueryMap() {
            return this.delegate.getQueryMap();
        }
    }

    private static class LiteralNodeContext
    extends NodeContext {
        private final String nodeURL;
        private final CertID nodeID;
        private final NodeConfig nodeConfig;
        private final HasRoutingTable routingTableSource;
        private final QueryActionMap queryMap;

        LiteralNodeContext(String nodeURL, CertID nodeID, NodeConfig nodeConfig, HasRoutingTable routingTableSource, QueryActionMap queryMap) {
            this.nodeURL = nodeURL;
            this.nodeID = nodeID;
            this.nodeConfig = nodeConfig;
            this.routingTableSource = routingTableSource;
            this.queryMap = queryMap;
        }

        @Override
        public String getNodeURL() {
            return this.nodeURL;
        }

        @Override
        public CertID getNodeID() {
            return this.nodeID;
        }

        @Override
        public NodeConfig getNodeConfig() {
            return this.nodeConfig;
        }

        @Override
        public RoutingTable getRoutingTable() {
            return this.routingTableSource.getRoutingTable();
        }

        @Override
        public QueryActionMap getQueryMap() {
            return this.queryMap;
        }
    }
}

