/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.cache;

import java.util.Collection;
import java.util.GregorianCalendar;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.xml.security.signature.XMLSignatureException;
import org.spin.message.BroadcastResults;
import org.spin.message.PropagationFlag;
import org.spin.message.QueryInfo;
import org.spin.message.Response;
import org.spin.message.ResultSet;
import org.spin.message.StatusCode;
import org.spin.node.cache.Cache;
import org.spin.node.cache.CacheException;
import org.spin.node.cache.MemoryResidentCache$;
import org.spin.node.cache.MemoryResidentCache$ShouldDelete$;
import org.spin.node.cache.MemoryResidentCache$ShouldNotDelete$;
import org.spin.node.cache.QueryCompletionSignaller;
import org.spin.node.cache.QueryNotFoundException;
import org.spin.node.cache.QueryState;
import org.spin.node.cache.ReadOnlyResultStore;
import org.spin.node.cache.ResponseNode;
import org.spin.node.cache.ResultStore;
import org.spin.node.cache.SimpleInMemoryResultStore;
import org.spin.tools.NetworkTime;
import org.spin.tools.config.NodeConfig;
import org.spin.tools.crypto.XMLSignatureUtil;
import org.spin.tools.crypto.signature.CertID;
import org.spin.tools.crypto.signature.Identity;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Product$class;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\rEu!B\u0001\u0003\u0011\u0003Y\u0011aE'f[>\u0014\u0018PU3tS\u0012,g\u000e^\"bG\",'BA\u0002\u0005\u0003\u0015\u0019\u0017m\u00195f\u0015\t)a!\u0001\u0003o_\u0012,'BA\u0004\t\u0003\u0011\u0019\b/\u001b8\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0001\"\u0001D\u0007\u000e\u0003\t1QA\u0004\u0002\t\u0002=\u00111#T3n_JL(+Z:jI\u0016tGoQ1dQ\u0016\u001c2!\u0004\t\u0019!\t\tb#D\u0001\u0013\u0015\t\u0019B#\u0001\u0003mC:<'\"A\u000b\u0002\t)\fg/Y\u0005\u0003/I\u0011aa\u00142kK\u000e$\bCA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"\u0001D*fe&\fG.\u001b>bE2,\u0007\"B\u0010\u000e\t\u0003\u0001\u0013A\u0002\u001fj]&$h\bF\u0001\f\u0011\u001d\u0011SB1A\u0005\n\r\n1\u0001\\8h+\u0005!\u0003CA\u0013+\u001b\u00051#BA\u0014)\u0003\u0015awn\u001a\u001bk\u0015\tI\u0003\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003W\u0019\u0012a\u0001T8hO\u0016\u0014\bBB\u0017\u000eA\u0003%A%\u0001\u0003m_\u001e\u0004\u0003bB\u0018\u000e\u0005\u0004%I\u0001M\u0001\u0005\u0013:3u*F\u00012!\tI\"'\u0003\u000245\t9!i\\8mK\u0006t\u0007BB\u001b\u000eA\u0003%\u0011'A\u0003J\u001d\u001a{\u0005\u0005C\u00048\u001b\t\u0007I\u0011\u0002\u0019\u0002\u000b\u0011+%)V$\t\rej\u0001\u0015!\u00032\u0003\u0019!UIQ+HA\u0019)1(DA\u0015y\taA)\u001a7fi&|gN\u00127bON\u0011!\b\u0005\u0005\t}i\u0012)\u0019!C\u0001a\u0005a1\u000f[8vY\u0012$U\r\\3uK\"A\u0001I\u000fB\u0001B\u0003%\u0011'A\u0007tQ>,H\u000e\u001a#fY\u0016$X\r\t\u0005\u0006?i\"\tA\u0011\u000b\u0003\u0007\u0016\u0003\"\u0001\u0012\u001e\u000e\u00035AQAP!A\u0002EJ3AO${\r\u0015AU\u0002##J\u00051\u0019\u0006n\\;mI\u0012+G.\u001a;f'\u001195I\u0013\r\u0011\u0005eY\u0015B\u0001'\u001b\u0005\u001d\u0001&o\u001c3vGRDQaH$\u0005\u00029#\u0012a\u0014\t\u0003\t\u001eCq!U$\u0002\u0002\u0013\u0005#+A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002'B\u0011\u0011\u0003V\u0005\u0003+J\u0011aa\u0015;sS:<\u0007bB,H\u0003\u0003%\t\u0001W\u0001\raJ|G-^2u\u0003JLG/_\u000b\u00023B\u0011\u0011DW\u0005\u00037j\u00111!\u00138u\u0011\u001div)!A\u0005\u0002y\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0002`EB\u0011\u0011\u0004Y\u0005\u0003Cj\u00111!\u00118z\u0011\u001d\u0019G,!AA\u0002e\u000b1\u0001\u001f\u00132\u0011\u001d)w)!A\u0005B\u0019\fq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0002OB\u0019\u0001n[0\u000e\u0003%T!A\u001b\u000e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002mS\nA\u0011\n^3sCR|'\u000fC\u0004o\u000f\u0006\u0005I\u0011A8\u0002\u0011\r\fg.R9vC2$\"!\r9\t\u000f\rl\u0017\u0011!a\u0001?\"9!oRA\u0001\n\u0003\u001a\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003eCq!^$\u0002\u0002\u0013\u0005c/\u0001\u0005u_N#(/\u001b8h)\u0005\u0019\u0006b\u0002=H\u0003\u0003%I!_\u0001\fe\u0016\fGMU3t_24X\rF\u0001\u0011\r\u0015YX\u0002##}\u0005=\u0019\u0006n\\;mI:{G\u000fR3mKR,7\u0003\u0002>D\u0015bAQa\b>\u0005\u0002y$\u0012a \t\u0003\tjDq!\u0015>\u0002\u0002\u0013\u0005#\u000bC\u0004Xu\u0006\u0005I\u0011\u0001-\t\u0011uS\u0018\u0011!C\u0001\u0003\u000f!2aXA\u0005\u0011!\u0019\u0017QAA\u0001\u0002\u0004I\u0006bB3{\u0003\u0003%\tE\u001a\u0005\t]j\f\t\u0011\"\u0001\u0002\u0010Q\u0019\u0011'!\u0005\t\u0011\r\fi!!AA\u0002}CqA\u001d>\u0002\u0002\u0013\u00053\u000fC\u0004vu\u0006\u0005I\u0011\t<\t\u000faT\u0018\u0011!C\u0005s\u001e1\u00111D\u0007\t\n>\u000bAb\u00155pk2$G)\u001a7fi\u0016<a!a\b\u000e\u0011\u0013{\u0018aD*i_VdGMT8u\t\u0016dW\r^3\t\u0013\u0005\rR\"!A\u0005\u0002\u0006\u0015\u0012!B1qa2LHCCA\u0014\u0007k\u001a9h!\u001f\u0004|A\u0019A\"!\u000b\u0007\u000b9\u0011!)a\u000b\u0014\u000f\u0005%\u0002#!\fK1A\u0019A\"a\f\n\u0007\u0005E\"AA\u0003DC\u000eDW\rC\u0006\u00026\u0005%\"Q1A\u0005\n\u0005]\u0012AF7bq\u0006;WMQ3g_J,W\t\u001f9je\u0006$\u0018n\u001c8\u0016\u0005\u0005e\u0002cA\r\u0002<%\u0019\u0011Q\b\u000e\u0003\t1{gn\u001a\u0005\f\u0003\u0003\nIC!E!\u0002\u0013\tI$A\fnCb\fu-\u001a\"fM>\u0014X-\u0012=qSJ\fG/[8oA!Y\u0011QIA\u0015\u0005\u000b\u0007I\u0011BA$\u0003=)gn\u00197pg&twMT8eK&#WCAA%!\u0011\tY%!\u0017\u000e\u0005\u00055#\u0002BA(\u0003#\n\u0011b]5h]\u0006$XO]3\u000b\t\u0005M\u0013QK\u0001\u0007GJL\b\u000f^8\u000b\u0007\u0005]c!A\u0003u_>d7/\u0003\u0003\u0002\\\u00055#AB\"feRLE\tC\u0006\u0002`\u0005%\"\u0011#Q\u0001\n\u0005%\u0013\u0001E3oG2|7/\u001b8h\u001d>$W-\u00133!\u0011-\t\u0019'!\u000b\u0003\u0006\u0004%I!!\u001a\u0002!alGnU5h]\u0006$XO]3Vi&dWCAA4!\u0011\tI'a\u001b\u000e\u0005\u0005E\u0013\u0002BA7\u0003#\u0012\u0001\u0003W'M'&<g.\u0019;ve\u0016,F/\u001b7\t\u0017\u0005E\u0014\u0011\u0006B\tB\u0003%\u0011qM\u0001\u0012q6d7+[4oCR,(/Z+uS2\u0004\u0003bCA;\u0003S\u0011)\u0019!C\u0005\u0003o\n\u0011b]5h]\u0006dG.\u001a:\u0016\u0005\u0005e\u0004c\u0001\u0007\u0002|%\u0019\u0011Q\u0010\u0002\u00031E+XM]=D_6\u0004H.\u001a;j_:\u001c\u0016n\u001a8bY2,'\u000fC\u0006\u0002\u0002\u0006%\"\u0011#Q\u0001\n\u0005e\u0014AC:jO:\fG\u000e\\3sA!9q$!\u000b\u0005\u0002\u0005\u0015ECCA\u0014\u0003\u000f\u000bI)a#\u0002\u000e\"A\u0011QGAB\u0001\u0004\tI\u0004\u0003\u0005\u0002F\u0005\r\u0005\u0019AA%\u0011!\t\u0019'a!A\u0002\u0005\u001d\u0004\u0002CA;\u0003\u0007\u0003\r!!\u001f\t\u000f}\tI\u0003\"\u0001\u0002\u0012RA\u0011qEAJ\u0003/\u000b9\u000b\u0003\u0005\u0002\u0016\u0006=\u0005\u0019AA%\u0003\u0019qw\u000eZ3JI\"A\u0011\u0011TAH\u0001\u0004\tY*\u0001\u0006o_\u0012,7i\u001c8gS\u001e\u0004B!!(\u0002$6\u0011\u0011q\u0014\u0006\u0005\u0003C\u000b)&\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003K\u000byJ\u0001\u0006O_\u0012,7i\u001c8gS\u001eD\u0001\"!\u001e\u0002\u0010\u0002\u0007\u0011\u0011\u0010\u0005\f\u0003W\u000bIC1A\u0005\u0002\t\ti+A\u0006sKN,H\u000e^*u_J,WCAAX!\ra\u0011\u0011W\u0005\u0004\u0003g\u0013!a\u0003*fgVdGo\u0015;pe\u0016D\u0011\"a.\u0002*\u0001\u0006I!a,\u0002\u0019I,7/\u001e7u'R|'/\u001a\u0011\t\u0011\u0005m\u0016\u0011\u0006C\u0001\u0003{\u000bAd^5uQF+XM]=D_6\u0004H.\u001a;j_:\u001c\u0016n\u001a8bY2,'\u000f\u0006\u0003\u0002(\u0005}\u0006\u0002CAa\u0003s\u0003\r!!\u001f\u0002\u00199,woU5h]\u0006dG.\u001a:\t\u0011\u0005\u0015\u0017\u0011\u0006C\u0001\u0003\u000f\fabZ3u%\u0016\u001cX\u000f\u001c;Ti>\u0014X-\u0006\u0002\u0002JB\u0019A\"a3\n\u0007\u00055'AA\nSK\u0006$wJ\u001c7z%\u0016\u001cX\u000f\u001c;Ti>\u0014X\r\u0003\u0005\u0002R\u0006%B\u0011AA$\u0003%9W\r\u001e(pI\u0016LE\t\u0003\u0005\u0002V\u0006%B\u0011AAl\u0003\u001d!Wm\u001d;s_f$\"!!7\u0011\u0007e\tY.C\u0002\u0002^j\u0011A!\u00168ji\"9\u0011\u0011]A\u0015\t\u0003\u0001\u0014aC5t\t\u0016\u001cHO]8zK\u0012D\u0001\"!:\u0002*\u0011\u0005\u0013q]\u0001\nS:LG/U;fef$B!!7\u0002j\"A\u00111^Ar\u0001\u0004\ti/A\u0005rk\u0016\u0014\u00180\u00138g_B!\u0011q^A{\u001b\t\t\tPC\u0002\u0002t\u001a\tq!\\3tg\u0006<W-\u0003\u0003\u0002x\u0006E(!C)vKJL\u0018J\u001c4p\u0011!\tY0!\u000b\u0005B\u0005u\u0018!C1hOJ,w-\u0019;f)\u0019\tI.a@\u0003\u0002!A\u00111^A}\u0001\u0004\ti\u000f\u0003\u0005\u0003\u0004\u0005e\b\u0019\u0001B\u0003\u0003!\u0011Xm\u001d9p]N,\u0007\u0003BAx\u0005\u000fIAA!\u0003\u0002r\nA!+Z:q_:\u001cX\r\u0003\u0005\u0003\u000e\u0005%B\u0011\tB\b\u0003%9W\r\u001e*fgVdG\u000f\u0006\u0004\u0003\u0012\t]!q\u0005\t\u0005\u0003_\u0014\u0019\"\u0003\u0003\u0003\u0016\u0005E(!\u0003*fgVdGoU3u\u0011!\u0011IBa\u0003A\u0002\tm\u0011aB9vKJL\u0018\n\u001a\t\u0005\u0005;\u0011\u0019CD\u0002\u001a\u0005?I1A!\t\u001b\u0003\u0019\u0001&/\u001a3fM&\u0019QK!\n\u000b\u0007\t\u0005\"\u0004\u0003\u0005\u0003*\t-\u0001\u0019\u0001B\u0016\u0003-\u0011X-];fgR|'/\u00133\u0011\t\u0005-#QF\u0005\u0005\u0005_\tiE\u0001\u0005JI\u0016tG/\u001b;z\u0011!\u0011\u0019$!\u000b\u0005B\tU\u0012!E4fiJ+7/\u001e7u\u001d>$U\r\\3uKR1!\u0011\u0003B\u001c\u0005sA\u0001B!\u0007\u00032\u0001\u0007!1\u0004\u0005\t\u0005S\u0011\t\u00041\u0001\u0003,!A!QHA\u0015\t\u0003\u0012y$\u0001\bd_VtGOU3ta>t7/Z:\u0015\u0007e\u0013\t\u0005\u0003\u0005\u0003\u001a\tm\u0002\u0019\u0001B\u000e\u0011!\u0011)%!\u000b\u0005B\t\u001d\u0013AC5t\u0007>l\u0007\u000f\\3uKR\u0019\u0011G!\u0013\t\u0011\te!1\ta\u0001\u00057A\u0001B!\u0014\u0002*\u0011\u0005#qJ\u0001\nQ\u0006\u001cX\u000b\u001d3bi\u0016$R!\rB)\u0005'B\u0001B!\u0007\u0003L\u0001\u0007!1\u0004\u0005\b\u0005+\u0012Y\u00051\u0001Z\u00035qW/\u001c*fgB|g\u000eZ3sg\"A!\u0011LA\u0015\t\u0003\u0012Y&\u0001\bfqB,7\r\u001e*fgB|gn]3\u0015\u0011\tu#1\rB3\u0005w\u0002B!a<\u0003`%!!\u0011MAy\u0005=\u0001&o\u001c9bO\u0006$\u0018n\u001c8GY\u0006<\u0007\u0002CAv\u0005/\u0002\r!!<\t\u0011\t\u001d$q\u000ba\u0001\u0005S\n\u0001b\u001d;biV\u001cXm\u001d\t\u0007\u0005W\u0012\tH!\u001e\u000e\u0005\t5$b\u0001B8)\u0005!Q\u000f^5m\u0013\u0011\u0011\u0019H!\u001c\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0005\u0003\u0002p\n]\u0014\u0002\u0002B=\u0003c\u0014!b\u0015;biV\u001c8i\u001c3f\u0011!\u0011iHa\u0016A\u0002\t}\u0014\u0001\u00052s_\u0006$7-Y:u%\u0016\u001cX\u000f\u001c;t!\u0011\tyO!!\n\t\t\r\u0015\u0011\u001f\u0002\u0011\u0005J|\u0017\rZ2bgR\u0014Vm];miND\u0001B!\u0004\u0002*\u0011%!q\u0011\u000b\t\u0005#\u0011IIa#\u0003\u000e\"A!\u0011\u0004BC\u0001\u0004\u0011Y\u0002\u0003\u0005\u0003*\t\u0015\u0005\u0019\u0001B\u0016\u0011!\u0011yI!\"A\u0002\tE\u0015A\u00055poR{\u0007*\u00198eY\u0016\u0014Vm];miN\u00042Aa%;\u001d\ta\u0001\u0001\u0003\u0005\u0003\u0018\u0006%B\u0011\u0002BM\u0003\u0019\u0011X-\\8wKR!\u0011\u0011\u001cBN\u0011!\u0011IB!&A\u0002\tm\u0001\u0002\u0003BP\u0003S!IA!)\u0002\u001b\u001d,G/U;fef\u001cF/\u0019;f)\u0011\u0011\u0019Ka,\u0011\u000be\u0011)K!+\n\u0007\t\u001d&D\u0001\u0004PaRLwN\u001c\t\u0004\u0019\t-\u0016b\u0001BW\u0005\tQ\u0011+^3ssN#\u0018\r^3\t\u0011\te!Q\u0014a\u0001\u00057A\u0001Ba-\u0002*\u0011%!QW\u0001\u0015O\u0016$\u0018+^3ssN#\u0018\r^3PeRC'o\\<\u0015\t\t%&q\u0017\u0005\t\u00053\u0011\t\f1\u0001\u0003\u001c!A!1XA\u0015\t\u0013\u0011i,\u0001\nfqBL'/Z)vKJLWm]!gi\u0016\u0014X\u0003\u0002B`\u0005\u000b$BA!1\u0003RB!!1\u0019Bc\u0019\u0001!\u0001Ba2\u0003:\n\u0007!\u0011\u001a\u0002\u0002)F\u0019!1Z0\u0011\u0007e\u0011i-C\u0002\u0003Pj\u0011qAT8uQ&tw\rC\u0005\u0003T\neF\u00111\u0001\u0003V\u0006\ta\rE\u0003\u001a\u0005/\u0014\t-C\u0002\u0003Zj\u0011\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\t\u0005;\fI\u0003\"\u0003\u0002X\u0006\u00012\r[3dW\u000e\u000b7\r[3FqBL'/\u001f\u0005\t\u0005C\fI\u0003\"\u0003\u0003d\u0006qr-^1sIF+XM]=J\t\n+Gn\u001c8hgR{'+Z9vKN$xN\u001d\u000b\u0007\u00033\u0014)Oa:\t\u0011\te!q\u001ca\u0001\u00057A\u0001B!\u000b\u0003`\u0002\u0007!1\u0006\u0005\t\u0005W\fI\u0003\"\u0003\u0003n\u0006Qr-^1sI&\u001b\u0018)\u001e;i_JL'0\u001a3SKF,Xm\u001d;peR1\u0011\u0011\u001cBx\u0005cD\u0001B!\u0007\u0003j\u0002\u0007!1\u0004\u0005\t\u0005S\u0011I\u000f1\u0001\u0003,!A!Q_A\u0015\t\u0013\u001190A\fdQ\u0016\u001c7NR8s\u0007>l\u0007\u000f\\3uS>t\u0017I\u001a;feV!!\u0011 B\u0000)\u0011\u0011Yp!\u0002\u0015\t\tu8\u0011\u0001\t\u0005\u0005\u0007\u0014y\u0010\u0002\u0005\u0003H\nM(\u0019\u0001Be\u0011%\u0011\u0019Na=\u0005\u0002\u0004\u0019\u0019\u0001E\u0003\u001a\u0005/\u0014i\u0010\u0003\u0005\u0003\u001a\tM\b\u0019\u0001B\u000e\u0011)\u0019I!!\u000b\u0002\u0002\u0013\u000511B\u0001\u0005G>\u0004\u0018\u0010\u0006\u0006\u0002(\r51qBB\t\u0007'A!\"!\u000e\u0004\bA\u0005\t\u0019AA\u001d\u0011)\t)ea\u0002\u0011\u0002\u0003\u0007\u0011\u0011\n\u0005\u000b\u0003G\u001a9\u0001%AA\u0002\u0005\u001d\u0004BCA;\u0007\u000f\u0001\n\u00111\u0001\u0002z!Q1qCA\u0015#\u0003%\ta!\u0007\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u001111\u0004\u0016\u0005\u0003s\u0019ib\u000b\u0002\u0004 A!1\u0011EB\u0016\u001b\t\u0019\u0019C\u0003\u0003\u0004&\r\u001d\u0012!C;oG\",7m[3e\u0015\r\u0019ICG\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\u0017\u0007G\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\u0019\t$!\u000b\u0012\u0002\u0013\u000511G\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019)D\u000b\u0003\u0002J\ru\u0001BCB\u001d\u0003S\t\n\u0011\"\u0001\u0004<\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAB\u001fU\u0011\t9g!\b\t\u0015\r\u0005\u0013\u0011FI\u0001\n\u0003\u0019\u0019%\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r\u0015#\u0006BA=\u0007;A!b!\u0013\u0002*-\u0005I\u0011AA\u001c\u0003ai\u0017\r_!hK\n+gm\u001c:f\u000bb\u0004\u0018N]1uS>tG%\r\u0005\u000b\u0007\u001b\nIc#A\u0005\u0002\u0005\u001d\u0013!E3oG2|7/\u001b8h\u001d>$W-\u00133%c!Q1\u0011KA\u0015\u0017\u0003%\t!!\u001a\u0002%alGnU5h]\u0006$XO]3Vi&dG%\r\u0005\u000b\u0007+\nIc#A\u0005\u0002\u0005]\u0014aC:jO:\fG\u000e\\3sIEB\u0001\"UA\u0015\u0003\u0003%\tE\u0015\u0005\t/\u0006%\u0012\u0011!C\u00011\"IQ,!\u000b\u0002\u0002\u0013\u00051Q\f\u000b\u0004?\u000e}\u0003\u0002C2\u0004\\\u0005\u0005\t\u0019A-\t\u0011\u0015\fI#!A\u0005B\u0019D\u0011B\\A\u0015\u0003\u0003%\ta!\u001a\u0015\u0007E\u001a9\u0007\u0003\u0005d\u0007G\n\t\u00111\u0001`\u0011!\u0011\u0018\u0011FA\u0001\n\u0003\u001a\b\u0002C;\u0002*\u0005\u0005I\u0011\t<\t\u0015\r=\u0014\u0011FA\u0001\n\u0003\u001a\t(\u0001\u0004fcV\fGn\u001d\u000b\u0004c\rM\u0004\u0002C2\u0004n\u0005\u0005\t\u0019A0\t\u0011\u0005U\u0012\u0011\u0005a\u0001\u0003sA\u0001\"!\u0012\u0002\"\u0001\u0007\u0011\u0011\n\u0005\t\u0003G\n\t\u00031\u0001\u0002h!A\u0011QOA\u0011\u0001\u0004\tI\bC\u0005\u0004\u00005\t\t\u0011\"!\u0004\u0002\u00069QO\\1qa2LH\u0003BBB\u0007\u0017\u0003R!\u0007BS\u0007\u000b\u00032\"GBD\u0003s\tI%a\u001a\u0002z%\u00191\u0011\u0012\u000e\u0003\rQ+\b\u000f\\35\u0011!\u0019ii! A\u0002\u0005\u001d\u0012a\u0001=%a!9\u00010DA\u0001\n\u0013I\b")
public final class MemoryResidentCache
implements Cache,
Product,
Serializable {
    private final long org$spin$node$cache$MemoryResidentCache$$maxAgeBeforeExpiration;
    private final CertID org$spin$node$cache$MemoryResidentCache$$enclosingNodeId;
    private final XMLSignatureUtil org$spin$node$cache$MemoryResidentCache$$xmlSignatureUtil;
    private final QueryCompletionSignaller org$spin$node$cache$MemoryResidentCache$$signaller;
    private final ResultStore resultStore;

    public long maxAgeBeforeExpiration$1() {
        return this.org$spin$node$cache$MemoryResidentCache$$maxAgeBeforeExpiration;
    }

    public CertID enclosingNodeId$1() {
        return this.org$spin$node$cache$MemoryResidentCache$$enclosingNodeId;
    }

    public XMLSignatureUtil xmlSignatureUtil$1() {
        return this.org$spin$node$cache$MemoryResidentCache$$xmlSignatureUtil;
    }

    public QueryCompletionSignaller signaller$1() {
        return this.org$spin$node$cache$MemoryResidentCache$$signaller;
    }

    public long org$spin$node$cache$MemoryResidentCache$$maxAgeBeforeExpiration() {
        return this.org$spin$node$cache$MemoryResidentCache$$maxAgeBeforeExpiration;
    }

    public CertID org$spin$node$cache$MemoryResidentCache$$enclosingNodeId() {
        return this.org$spin$node$cache$MemoryResidentCache$$enclosingNodeId;
    }

    public XMLSignatureUtil org$spin$node$cache$MemoryResidentCache$$xmlSignatureUtil() {
        return this.org$spin$node$cache$MemoryResidentCache$$xmlSignatureUtil;
    }

    public QueryCompletionSignaller org$spin$node$cache$MemoryResidentCache$$signaller() {
        return this.org$spin$node$cache$MemoryResidentCache$$signaller;
    }

    public ResultStore resultStore() {
        return this.resultStore;
    }

    public MemoryResidentCache withQueryCompletionSignaller(QueryCompletionSignaller newSignaller) {
        QueryCompletionSignaller x$3 = newSignaller;
        long x$4 = this.copy$default$1();
        CertID x$5 = this.copy$default$2();
        XMLSignatureUtil x$6 = this.copy$default$3();
        return this.copy(x$4, x$5, x$6, x$3);
    }

    public ReadOnlyResultStore getResultStore() {
        return this.resultStore();
    }

    public CertID getNodeID() {
        return this.org$spin$node$cache$MemoryResidentCache$$enclosingNodeId();
    }

    public void destroy() {
        this.resultStore().shutdown();
    }

    public boolean isDestroyed() {
        return this.resultStore().isShutDown();
    }

    @Override
    public void initQuery(QueryInfo queryInfo) {
        String queryId = queryInfo.getQueryID();
        Identity requestorId = queryInfo.getIdentity();
        CertID rootId = this.org$spin$node$cache$MemoryResidentCache$$enclosingNodeId();
        ResultStore resultStore = this.resultStore();
        synchronized (resultStore) {
            this.resultStore().get(queryId).getOrElse(new Serializable(this, queryId, requestorId, rootId){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MemoryResidentCache $outer;
                private final String queryId$1;
                private final Identity requestorId$1;
                private final CertID rootId$1;

                /*
                 * WARNING - void declaration
                 */
                public final QueryState apply() {
                    void var1_1;
                    QueryState newQueryState = new QueryState(this.rootId$1, this.requestorId$1);
                    this.$outer.resultStore().$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(this.queryId$1), newQueryState));
                    return var1_1;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.queryId$1 = queryId$1;
                    this.requestorId$1 = requestorId$1;
                    this.rootId$1 = rootId$1;
                }
            });
            return;
        }
    }

    @Override
    public void aggregate(QueryInfo queryInfo, Response response) {
        this.checkForCompletionAfter(queryInfo.getQueryID(), (Function0)((Object)new Serializable(this, queryInfo, response){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemoryResidentCache $outer;
            private final QueryInfo queryInfo$1;
            private final Response response$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$spin$node$cache$MemoryResidentCache$$getQueryStateOrThrow(this.queryInfo$1.getQueryID()).addResponse(this.queryInfo$1, this.response$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.queryInfo$1 = queryInfo$1;
                this.response$1 = response$1;
            }
        }));
    }

    @Override
    public ResultSet getResult(String queryId, Identity requestorId) {
        return this.getResult(queryId, requestorId, MemoryResidentCache$ShouldDelete$.MODULE$);
    }

    @Override
    public ResultSet getResultNoDelete(String queryId, Identity requestorId) {
        return this.getResult(queryId, requestorId, MemoryResidentCache$ShouldNotDelete$.MODULE$);
    }

    @Override
    public int countResponses(String queryId) {
        return BoxesRunTime.unboxToInt(this.expireQueriesAfter((Function0)((Object)new Serializable(this, queryId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemoryResidentCache $outer;
            private final String queryId$4;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.org$spin$node$cache$MemoryResidentCache$$getQueryStateOrThrow(this.queryId$4).iterator().count((Function1<ResponseNode, Object>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ResponseNode x$1) {
                        return x$1.hasValue();
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.queryId$4 = queryId$4;
            }
        })));
    }

    @Override
    public boolean isComplete(String queryId) {
        return this.org$spin$node$cache$MemoryResidentCache$$getQueryStateOrThrow(queryId).isComplete();
    }

    @Override
    public boolean hasUpdate(String queryId, int numResponders) {
        return BoxesRunTime.unboxToBoolean(this.expireQueriesAfter((Function0)((Object)new Serializable(this, queryId, numResponders){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemoryResidentCache $outer;
            private final String queryId$5;
            private final int numResponders$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.countResponses(this.queryId$5) > this.numResponders$1;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.queryId$5 = queryId$5;
                this.numResponders$1 = numResponders$1;
            }
        })));
    }

    @Override
    public PropagationFlag expectResponse(QueryInfo queryInfo, Collection<StatusCode> statuses, BroadcastResults broadcastResults) {
        return this.checkForCompletionAfter(queryInfo.getQueryID(), (Function0)((Object)new Serializable(this, queryInfo, statuses, broadcastResults){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemoryResidentCache $outer;
            private final QueryInfo queryInfo$2;
            private final Collection statuses$1;
            private final BroadcastResults broadcastResults$1;

            public final PropagationFlag apply() {
                return this.$outer.org$spin$node$cache$MemoryResidentCache$$getQueryStateOrThrow(this.queryInfo$2.getQueryID()).setExpectations(this.queryInfo$2, ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.statuses$1).asScala()).toSet(), this.broadcastResults$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.queryInfo$2 = queryInfo$2;
                this.statuses$1 = statuses$1;
                this.broadcastResults$1 = broadcastResults$1;
            }
        }));
    }

    private ResultSet getResult(String queryId, Identity requestorId, DeletionFlag howToHandleResults) {
        return this.expireQueriesAfter((Function0)((Object)new Serializable(this, queryId, requestorId, howToHandleResults){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemoryResidentCache $outer;
            private final String queryId$3;
            private final Identity requestorId$2;
            private final DeletionFlag howToHandleResults$1;

            /*
             * WARNING - void declaration
             */
            public final ResultSet apply() {
                void var2_2;
                this.$outer.org$spin$node$cache$MemoryResidentCache$$guardIsAuthorizedRequestor(this.queryId$3, this.requestorId$2);
                this.$outer.org$spin$node$cache$MemoryResidentCache$$guardQueryIDBelongsToRequestor(this.queryId$3, this.requestorId$2);
                QueryState queryState = this.$outer.org$spin$node$cache$MemoryResidentCache$$getQueryStateOrThrow(this.queryId$3);
                ResultSet resultSet = queryState.toResultSet(this.queryId$3);
                if (queryState.isComplete() && this.howToHandleResults$1.shouldDelete()) {
                    this.$outer.org$spin$node$cache$MemoryResidentCache$$remove(this.queryId$3);
                }
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.queryId$3 = queryId$3;
                this.requestorId$2 = requestorId$2;
                this.howToHandleResults$1 = howToHandleResults$1;
            }
        }));
    }

    public void org$spin$node$cache$MemoryResidentCache$$remove(String queryId) {
        ResultStore resultStore = this.resultStore();
        synchronized (resultStore) {
            this.resultStore().$minus$eq(queryId);
            return;
        }
    }

    public Option<QueryState> org$spin$node$cache$MemoryResidentCache$$getQueryState(String queryId) {
        ResultStore resultStore = this.resultStore();
        synchronized (resultStore) {
            Option<QueryState> option = this.resultStore().get(queryId);
            return option;
        }
    }

    public QueryState org$spin$node$cache$MemoryResidentCache$$getQueryStateOrThrow(String queryId) {
        return (QueryState)((Object)this.org$spin$node$cache$MemoryResidentCache$$getQueryState(queryId).getOrElse(new Serializable(this, queryId){
            public static final long serialVersionUID = 0L;
            private final String queryId$2;

            public final Nothing$ apply() {
                throw new QueryNotFoundException(new StringBuilder().append((Object)"Couldn't find query '").append((Object)this.queryId$2).append((Object)"', is it expired, or not yet initialized?").toString());
            }
            {
                this.queryId$2 = queryId$2;
            }
        }));
    }

    private <T> T expireQueriesAfter(Function0<T> f2) {
        try {
            return f2.apply();
        }
        finally {
            this.checkCacheExpiry();
        }
    }

    private void checkCacheExpiry() {
        ResultStore resultStore = this.resultStore();
        synchronized (resultStore) {
            Set<String> queriesToRemove = this.resultStore().getStoredQueryIds().flatMap(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MemoryResidentCache $outer;

                public final Iterable<String> apply(String queryId) {
                    return Option$.MODULE$.option2Iterable(this.$outer.org$spin$node$cache$MemoryResidentCache$$getQueryState(queryId).filter((Function1<QueryState, Object>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$1 $outer;

                        public final boolean apply(QueryState queryState) {
                            return this.$outer.org$spin$node$cache$MemoryResidentCache$$anonfun$$$outer().org$spin$node$cache$MemoryResidentCache$$isExpired$1(queryState);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    })).map(new Serializable(this, queryId){
                        public static final long serialVersionUID = 0L;
                        private final String queryId$6;

                        public final String apply(QueryState expiredEntry) {
                            if (MemoryResidentCache$.MODULE$.org$spin$node$cache$MemoryResidentCache$$INFO()) {
                                XMLGregorianCalendar now = NetworkTime.makeXMLGregorianCalendar(new GregorianCalendar());
                                MemoryResidentCache$.MODULE$.org$spin$node$cache$MemoryResidentCache$$log().info(new StringBuilder().append((Object)"Removing expired query: ").append((Object)this.queryId$6).append((Object)", created on: ").append(BoxesRunTime.boxToLong(expiredEntry.root().timestamp())).append((Object)", current time: ").append(now).toString());
                            }
                            return this.queryId$6;
                        }
                        {
                            this.queryId$6 = queryId$6;
                        }
                    }));
                }

                public /* synthetic */ MemoryResidentCache org$spin$node$cache$MemoryResidentCache$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, Set$.MODULE$.canBuildFrom());
            queriesToRemove.foreach(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MemoryResidentCache $outer;

                public final void apply(String x$2) {
                    this.$outer.resultStore().$minus$eq(x$2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
    }

    public void org$spin$node$cache$MemoryResidentCache$$guardQueryIDBelongsToRequestor(String queryId, Identity requestorId) {
        String requestor = requestorId.getUsername();
        String owner = this.org$spin$node$cache$MemoryResidentCache$$getQueryStateOrThrow(queryId).requestorId().getUsername();
        boolean ownerUsernamesMatch = owner.equalsIgnoreCase(requestor);
        if (ownerUsernamesMatch) {
            return;
        }
        throw new CacheException(new StringBuilder().append((Object)"queryID ").append((Object)queryId).append((Object)" was issued by a different user, expected: ").append((Object)owner).toString());
    }

    public void org$spin$node$cache$MemoryResidentCache$$guardIsAuthorizedRequestor(String queryId, Identity requestorId) {
        Predef$.MODULE$.require(requestorId != null);
        try {
            boolean valid = this.org$spin$node$cache$MemoryResidentCache$$xmlSignatureUtil().verifySignature(requestorId);
            if (valid) {
                return;
            }
            throw new CacheException(new StringBuilder().append((Object)"Signature was invalid for queryId ").append((Object)queryId).toString());
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new CacheException(new StringBuilder().append((Object)"Error validating signature for user '").append((Object)requestorId.getUsername()).append((Object)"' requested query ").append((Object)queryId).toString(), xMLSignatureException);
        }
    }

    private <T> T checkForCompletionAfter(String queryId, Function0<T> f2) {
        try {
            return f2.apply();
        }
        finally {
            if (this.isComplete(queryId)) {
                this.org$spin$node$cache$MemoryResidentCache$$signaller().signalCompletionOf(queryId, this);
            }
        }
    }

    public MemoryResidentCache copy(long maxAgeBeforeExpiration, CertID enclosingNodeId, XMLSignatureUtil xmlSignatureUtil, QueryCompletionSignaller signaller) {
        return new MemoryResidentCache(maxAgeBeforeExpiration, enclosingNodeId, xmlSignatureUtil, signaller);
    }

    public long copy$default$1() {
        return this.org$spin$node$cache$MemoryResidentCache$$maxAgeBeforeExpiration();
    }

    public CertID copy$default$2() {
        return this.org$spin$node$cache$MemoryResidentCache$$enclosingNodeId();
    }

    public XMLSignatureUtil copy$default$3() {
        return this.org$spin$node$cache$MemoryResidentCache$$xmlSignatureUtil();
    }

    public QueryCompletionSignaller copy$default$4() {
        return this.org$spin$node$cache$MemoryResidentCache$$signaller();
    }

    @Override
    public String productPrefix() {
        return "MemoryResidentCache";
    }

    @Override
    public int productArity() {
        return 4;
    }

    @Override
    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
            }
            case 3: {
                object = this.signaller$1();
                break;
            }
            case 2: {
                object = this.xmlSignatureUtil$1();
                break;
            }
            case 1: {
                object = this.enclosingNodeId$1();
                break;
            }
            case 0: {
                object = BoxesRunTime.boxToLong(this.maxAgeBeforeExpiration$1());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator(this);
    }

    @Override
    public boolean canEqual(Object x$1) {
        return x$1 instanceof MemoryResidentCache;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix(n, Statics.longHash(this.maxAgeBeforeExpiration$1()));
        n = Statics.mix(n, Statics.anyHash(this.enclosingNodeId$1()));
        n = Statics.mix(n, Statics.anyHash(this.xmlSignatureUtil$1()));
        n = Statics.mix(n, Statics.anyHash(this.signaller$1()));
        return Statics.finalizeHash(n, 4);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        if (!(x$1 instanceof MemoryResidentCache)) return false;
        MemoryResidentCache memoryResidentCache = (MemoryResidentCache)x$1;
        if (this.maxAgeBeforeExpiration$1() != memoryResidentCache.maxAgeBeforeExpiration$1()) return false;
        CertID certID = this.enclosingNodeId$1();
        CertID certID2 = memoryResidentCache.enclosingNodeId$1();
        if (certID == null) {
            if (certID2 != null) {
                return false;
            }
        } else if (!((Object)certID).equals(certID2)) return false;
        XMLSignatureUtil xMLSignatureUtil = this.xmlSignatureUtil$1();
        XMLSignatureUtil xMLSignatureUtil2 = memoryResidentCache.xmlSignatureUtil$1();
        if (xMLSignatureUtil == null) {
            if (xMLSignatureUtil2 != null) {
                return false;
            }
        } else if (!xMLSignatureUtil.equals(xMLSignatureUtil2)) return false;
        QueryCompletionSignaller queryCompletionSignaller = this.signaller$1();
        QueryCompletionSignaller queryCompletionSignaller2 = memoryResidentCache.signaller$1();
        if (queryCompletionSignaller == null) {
            if (queryCompletionSignaller2 == null) return true;
            return false;
        } else {
            if (!queryCompletionSignaller.equals(queryCompletionSignaller2)) return false;
            return true;
        }
    }

    public final boolean org$spin$node$cache$MemoryResidentCache$$isExpired$1(QueryState queryState) {
        return queryState.isExpired(this.org$spin$node$cache$MemoryResidentCache$$maxAgeBeforeExpiration());
    }

    public MemoryResidentCache(long maxAgeBeforeExpiration, CertID enclosingNodeId, XMLSignatureUtil xmlSignatureUtil, QueryCompletionSignaller signaller) {
        this.org$spin$node$cache$MemoryResidentCache$$maxAgeBeforeExpiration = maxAgeBeforeExpiration;
        this.org$spin$node$cache$MemoryResidentCache$$enclosingNodeId = enclosingNodeId;
        this.org$spin$node$cache$MemoryResidentCache$$xmlSignatureUtil = xmlSignatureUtil;
        this.org$spin$node$cache$MemoryResidentCache$$signaller = signaller;
        Product$class.$init$(this);
        this.resultStore = new SimpleInMemoryResultStore();
    }

    public MemoryResidentCache(CertID nodeId, NodeConfig nodeConfig, QueryCompletionSignaller signaller) {
        this(Predef$.MODULE$.Long2long(nodeConfig.getCacheTTL()), nodeId, XMLSignatureUtil.getDefaultInstance(), signaller);
    }

    public static abstract class DeletionFlag {
        private final boolean shouldDelete;

        public boolean shouldDelete() {
            return this.shouldDelete;
        }

        public DeletionFlag(boolean shouldDelete) {
            this.shouldDelete = shouldDelete;
        }
    }
}

