/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.connector;

import java.net.MalformedURLException;
import java.net.URL;

public abstract class URLHandle {
    public abstract URL value() throws MalformedURLException;

    public static final URLHandle fromString(String urlAsString) {
        return new LiteralURLHandle(urlAsString);
    }

    public static final URLHandle fromURL(final URL url) {
        return new URLHandle(){

            @Override
            public final URL value() throws MalformedURLException {
                return url;
            }

            public final String toString() {
                return String.valueOf(url);
            }
        };
    }

    private static final class LiteralURLHandle
    extends URLHandle {
        private final String urlAsString;
        private URL url = null;

        LiteralURLHandle(String urlAsString) {
            this.urlAsString = urlAsString;
        }

        @Override
        public final synchronized URL value() throws MalformedURLException {
            if (this.url == null) {
                this.url = new URL(this.urlAsString);
            }
            return this.url;
        }

        public final String toString() {
            if (this.url == null) {
                return String.valueOf(this.urlAsString);
            }
            return this.url.toString();
        }
    }
}

