/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools;

import java.lang.reflect.Constructor;
import org.apache.log4j.Logger;
import org.spin.tools.DynamicLoadingException;

public final class ClassTools {
    private static final Logger log = Logger.getLogger(ClassTools.class);
    private static final boolean DEBUG = log.isDebugEnabled();

    private ClassTools() {
    }

    public static final <T> T createInstance(Class<T> clazz2) {
        try {
            return clazz2.newInstance();
        }
        catch (Exception e2) {
            throw new DynamicLoadingException("Error instantiating class '" + clazz2.getName() + "':", e2);
        }
    }

    public static final <T> T createInstance(String className, Class<T> classToCastInto) {
        if (DEBUG) {
            log.debug("Loading '" + className + "', casting into '" + classToCastInto.getSimpleName() + "'");
        }
        try {
            return classToCastInto.cast(Class.forName(className).newInstance());
        }
        catch (Exception e2) {
            throw new DynamicLoadingException("Error instantiating class '" + className + "':", e2);
        }
    }

    public static final <T> T createInstance(String className, Class<T> classToCastInto, ClassLoader classLoader) {
        if (DEBUG) {
            log.debug("Loading '" + className + "' via user-supplied ClassLoader, casting into '" + classToCastInto.getSimpleName() + "'");
        }
        try {
            return classToCastInto.cast(classLoader.loadClass(className).newInstance());
        }
        catch (Exception e2) {
            throw new DynamicLoadingException("Error instantiating class '" + className + "':", e2);
        }
    }

    public static final <T> T createInstance(Class<T> clazz2, Class<?>[] constructorParamTypes, Object[] constructorParams) {
        return ClassTools.createInstance(clazz2.getName(), clazz2, constructorParamTypes, constructorParams);
    }

    public static final <T> T createInstance(String className, Class<T> classToCastInto, Class<?>[] constructorParamTypes, Object[] constructorParams) {
        if (DEBUG) {
            log.debug("Loading '" + className + "', casting into '" + classToCastInto.getSimpleName() + "'");
        }
        try {
            Constructor<?> constructor = Class.forName(className).getConstructor(constructorParamTypes);
            return classToCastInto.cast(constructor.newInstance(constructorParams));
        }
        catch (Exception e2) {
            throw new DynamicLoadingException("Error instantiating class '" + className + "':", e2);
        }
    }

    public static final boolean allSamePackage(Class<?> ... classes2) {
        if (classes2 == null || classes2.length < 1) {
            return false;
        }
        if (classes2.length == 1) {
            return true;
        }
        String packageName = classes2[0].getPackage().getName();
        for (int i = 1; i < classes2.length; ++i) {
            if (classes2[i].getPackage().getName().equals(packageName)) continue;
            return false;
        }
        return true;
    }
}

