/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.spin.tools.Util;

public final class FileUtils {
    private static final Logger log = Logger.getLogger(FileUtils.class);
    private static final boolean DEBUG = log.isDebugEnabled();

    private FileUtils() {
    }

    public static boolean exists(String path2) {
        return new File(path2).exists();
    }

    public static String makePathString(String ... pathElements) {
        Util.guardNotNull(pathElements);
        if (pathElements.length == 0) {
            return "";
        }
        if (pathElements.length == 1) {
            return pathElements[0];
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < pathElements.length; ++i) {
            builder.append(pathElements[i]);
            if (i >= pathElements.length - 1) continue;
            builder.append(File.separatorChar);
        }
        return builder.toString();
    }

    public static String read(InputStream stream2) throws IOException {
        return FileUtils.read(new InputStreamReader(stream2));
    }

    public static String read(File filename) throws IOException {
        if (DEBUG) {
            log.debug("Reading contents from " + filename.getAbsolutePath());
        }
        return FileUtils.read(new FileReader(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(Reader reader2) throws IOException {
        try {
            int len2;
            StringBuilder contents = new StringBuilder();
            char[] buf = new char[1024];
            while ((len2 = reader2.read(buf)) > 0) {
                contents.append(buf, 0, len2);
            }
            String string2 = contents.toString();
            return string2;
        }
        finally {
            FileUtils.closeIgnoringException(reader2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readAsList(File filename) throws IOException {
        if (DEBUG) {
            log.debug("Reading contents from " + filename.getAbsolutePath());
        }
        BufferedReader reader2 = new BufferedReader(new FileReader(filename));
        try {
            ArrayList<String> contents = new ArrayList<String>(100);
            while (reader2.ready()) {
                contents.add(reader2.readLine());
            }
            ArrayList<String> arrayList = contents;
            return arrayList;
        }
        finally {
            FileUtils.closeIgnoringException(reader2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File dest) throws IOException {
        FileInputStream in2 = null;
        FileOutputStream out = null;
        try {
            in2 = new FileInputStream(src);
            if (((InputStream)in2).available() > 0) {
                int len2;
                if (!dest.exists() && !dest.createNewFile()) {
                    throw new IOException("Couldn't create '" + dest + "'");
                }
                out = new FileOutputStream(dest);
                byte[] buf = new byte[1024];
                while ((len2 = ((InputStream)in2).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len2);
                }
            }
        }
        catch (Throwable throwable2) {
            FileUtils.closeIgnoringException(in2);
            FileUtils.closeIgnoringException(out);
            throw throwable2;
        }
        FileUtils.closeIgnoringException(in2);
        FileUtils.closeIgnoringException(out);
    }

    private static final void closeIgnoringException(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e2) {
                log.warn("Error closing resource: ", e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File filename, String contents) throws IOException {
        if (DEBUG) {
            log.debug("Writing contents to " + filename.getAbsolutePath());
        }
        PrintWriter output = null;
        try {
            output = new PrintWriter(new FileOutputStream(filename), false);
            output.write(contents);
        }
        catch (Throwable throwable2) {
            FileUtils.closeIgnoringException(output);
            throw throwable2;
        }
        FileUtils.closeIgnoringException(output);
    }
}

