/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.spin.tools.ClassTools;
import org.spin.tools.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class JAXBUtils {
    private static final Logger log = Logger.getLogger(JAXBUtils.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final Map<String, JAXBContext> packageNameContextCache = Util.makeHashMap();
    private static final Map<String, Marshaller> packageNameMarshallerCache = Util.makeHashMap();
    private static final Map<String, Unmarshaller> packageNameUnmarshallerCache = Util.makeHashMap();
    private static final Map<String, CacheEntry> contextCache = Util.makeHashMap();
    private static final Map<JAXBContext, Marshaller> marshallerCache = Util.makeHashMap();
    private static final Map<JAXBContext, Unmarshaller> unmarshallerCache = Util.makeHashMap();

    private JAXBUtils() {
    }

    public static final <T> T unmarshal(Node node4, Class<T> clazz2) throws JAXBException {
        return JAXBUtils.unmarshal(node4, clazz2, false);
    }

    public static final <T> T unmarshalAndValidate(Node node4, Class<T> clazz2) throws JAXBException {
        return JAXBUtils.unmarshal(node4, clazz2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T unmarshal(Node node4, Class<T> clazz2, boolean validate2) throws JAXBException {
        Unmarshaller unmarshaller;
        if (DEBUG) {
            if (node4.getClass().isAssignableFrom(Element.class)) {
                log.debug("Unmarshalling '" + JAXBUtils.marshalToString((Element)node4) + "' into '" + clazz2.getSimpleName() + "'");
            }
            log.debug("Unmarshalling '" + node4 + "' into '" + clazz2.getSimpleName() + "'");
        }
        Unmarshaller unmarshaller2 = unmarshaller = validate2 ? JAXBUtils.getUncachedUnmarshaller(clazz2) : JAXBUtils.getUnmarshaller(clazz2);
        if (validate2) {
            if (DEBUG) {
                log.debug("Getting schema for class for validation.");
            }
            unmarshaller.setSchema(JAXBUtils.getSchemaFromClass(clazz2));
        }
        Unmarshaller unmarshaller3 = unmarshaller;
        synchronized (unmarshaller3) {
            return (T)unmarshaller.unmarshal(node4, clazz2).getValue();
        }
    }

    public static final Object unmarshalAndValidate(Node node4, String packageNames2) throws JAXBException {
        return JAXBUtils.unmarshal(node4, packageNames2, true);
    }

    public static final Object unmarshal(Node node4, String packageNames2) throws JAXBException {
        return JAXBUtils.unmarshal(node4, packageNames2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object unmarshal(Node node4, String packageNames2, boolean validate2) throws JAXBException {
        Unmarshaller unmarshaller;
        Unmarshaller unmarshaller2 = unmarshaller = validate2 ? JAXBUtils.getUncachedUnmarshaller(packageNames2) : JAXBUtils.getUnmarshaller(packageNames2);
        if (validate2) {
            if (DEBUG) {
                log.debug("Getting schema for class for validation.");
            }
            unmarshaller.setSchema(JAXBUtils.getSchemaFromPackage(packageNames2));
        }
        Unmarshaller unmarshaller3 = unmarshaller;
        synchronized (unmarshaller3) {
            return unmarshaller.unmarshal(node4);
        }
    }

    private static final Schema getSchemaFromClass(Class<?> clazz2) throws JAXBException {
        return JAXBUtils.getSchemaFromContext(JAXBUtils.getContext(clazz2));
    }

    private static final Schema getSchemaFromPackage(String packageNames2) throws JAXBException {
        return JAXBUtils.getSchemaFromContext(JAXBUtils.getContext(packageNames2));
    }

    private static final Schema getSchemaFromContext(JAXBContext context) throws JAXBException {
        ByteArraySchemaOutputResolver schemaOutputResolver = new ByteArraySchemaOutputResolver();
        try {
            context.generateSchema((SchemaOutputResolver)schemaOutputResolver);
        }
        catch (IOException e2) {
            throw new JAXBException("Error generating schema from context: " + context, (Throwable)e2);
        }
        List<ByteArrayOutputStream> outs = schemaOutputResolver.getOutputs();
        Source[] sources = new StreamSource[outs.size()];
        for (int i : Util.range(outs.size())) {
            ByteArrayOutputStream out = outs.get(i);
            sources[i] = new StreamSource(new ByteArrayInputStream(out.toByteArray()), "");
        }
        try {
            return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(sources);
        }
        catch (SAXException e3) {
            throw new JAXBException("SAX parsing error occurred while generating schema from class.", (Throwable)e3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T unmarshal(Reader reader2, Class<T> clazz2, boolean validate2) throws JAXBException {
        Unmarshaller unmarshaller;
        if (DEBUG) {
            log.debug("Unmarshalling from Reader into '" + clazz2.getSimpleName() + "'");
        }
        Unmarshaller unmarshaller2 = unmarshaller = validate2 ? JAXBUtils.getUncachedUnmarshaller(clazz2) : JAXBUtils.getUnmarshaller(clazz2);
        if (validate2) {
            if (DEBUG) {
                log.debug("Getting schema for class for validation.");
            }
            unmarshaller.setSchema(JAXBUtils.getSchemaFromClass(clazz2));
        }
        Unmarshaller unmarshaller3 = unmarshaller;
        synchronized (unmarshaller3) {
            return (T)unmarshaller.unmarshal((Source)new StreamSource(reader2), clazz2).getValue();
        }
    }

    public static final <T> T unmarshalAndValidate(Reader reader2, Class<T> clazz2) throws JAXBException {
        return JAXBUtils.unmarshal(reader2, clazz2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object unmarshal(Reader reader2, String packageNames2, boolean validate2) throws JAXBException {
        Unmarshaller unmarshaller;
        Unmarshaller unmarshaller2 = unmarshaller = validate2 ? JAXBUtils.getUncachedUnmarshaller(packageNames2) : JAXBUtils.getUnmarshaller(packageNames2);
        if (validate2) {
            unmarshaller.setSchema(JAXBUtils.getSchemaFromPackage(packageNames2));
        }
        Unmarshaller unmarshaller3 = unmarshaller;
        synchronized (unmarshaller3) {
            return unmarshaller.unmarshal(reader2);
        }
    }

    public static final Object unmarshalAndValidate(Reader reader2, String packageNames2) throws JAXBException {
        return JAXBUtils.unmarshal(reader2, packageNames2, true);
    }

    public static final <T> T unmarshal(Reader reader2, Class<T> clazz2) throws JAXBException {
        return JAXBUtils.unmarshal(reader2, clazz2, false);
    }

    public static final Object unmarshal(Reader reader2, String packageNames2) throws JAXBException {
        return JAXBUtils.unmarshal(reader2, packageNames2, false);
    }

    public static final <T> T unmarshalAndValidate(File file, Class<T> clazz2) throws JAXBException {
        try {
            return JAXBUtils.unmarshal((Reader)new FileReader(file), clazz2, true);
        }
        catch (FileNotFoundException e2) {
            throw new JAXBException("File not found, '" + file.getAbsolutePath() + "'.", (Throwable)e2);
        }
    }

    public static final Object unmarshalAndValidate(File file, String packageNames2) throws JAXBException {
        try {
            return JAXBUtils.unmarshal((Reader)new FileReader(file), packageNames2, true);
        }
        catch (FileNotFoundException e2) {
            throw new JAXBException("File not found, '" + file.getAbsolutePath() + "'.", (Throwable)e2);
        }
    }

    public static final <T> T unmarshal(File file, Class<T> clazz2) throws JAXBException {
        try {
            return JAXBUtils.unmarshal((Reader)new FileReader(file), clazz2, false);
        }
        catch (FileNotFoundException e2) {
            throw new JAXBException("File not found, '" + file.getAbsolutePath() + "'.", (Throwable)e2);
        }
    }

    public static final Object unmarshal(File file, String packageNames2) throws JAXBException {
        try {
            return JAXBUtils.unmarshal((Reader)new FileReader(file), packageNames2, false);
        }
        catch (FileNotFoundException e2) {
            throw new JAXBException("File not found, '" + file.getAbsolutePath() + "'.", (Throwable)e2);
        }
    }

    public static final <T> T unmarshalAndValidate(String xml2, Class<T> clazz2) throws JAXBException {
        if (DEBUG) {
            log.debug("Unmarshalling from XML into '" + clazz2.getSimpleName() + "'");
        }
        return JAXBUtils.unmarshal((Reader)new StringReader(xml2), clazz2, true);
    }

    public static final <T> T unmarshal(String xml2, Class<T> clazz2) throws JAXBException {
        if (DEBUG) {
            log.debug("Unmarshalling from XML into '" + clazz2.getSimpleName() + "'");
        }
        return JAXBUtils.unmarshal((Reader)new StringReader(xml2), clazz2, false);
    }

    public static final Object unmarshal(String xml2, String packageNames2) throws JAXBException {
        return JAXBUtils.unmarshal((Reader)new StringReader(xml2), packageNames2, false);
    }

    public static final Object unmarshalAndValidate(String xml2, String packageNames2) throws JAXBException {
        return JAXBUtils.unmarshal((Reader)new StringReader(xml2), packageNames2, true);
    }

    public static final String marshalToString(Object object) throws JAXBException {
        StringWriter writer = new StringWriter();
        JAXBUtils.marshalToWriter(object, writer);
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void marshalToWriter(Object object, Writer writer) throws JAXBException {
        Marshaller marshaller = JAXBUtils.getMarshaller(object.getClass());
        try {
            Marshaller marshaller2 = marshaller;
            synchronized (marshaller2) {
                marshaller.marshal(object, writer);
            }
        }
        finally {
            try {
                writer.flush();
            }
            catch (IOException e2) {
                throw new JAXBException("Error flushing Writer: ", (Throwable)e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String marshalToString(Element element2) throws JAXBException {
        if (element2 == null) {
            return null;
        }
        try {
            Transformer nullTransformer;
            TransformerFactory transformerFactory = TransformerFactoryHolder.transformerFactory;
            synchronized (transformerFactory) {
                nullTransformer = TransformerFactoryHolder.transformerFactory.newTransformer();
            }
            StringWriter writer = new StringWriter();
            nullTransformer.transform(new DOMSource(element2), new StreamResult(writer));
            return writer.toString();
        }
        catch (Exception e2) {
            log.error("Error marshalling DOM tree to String", e2);
            return null;
        }
    }

    public static final void marshalToFile(Object object, File file) throws JAXBException {
        FileWriter writer = null;
        try {
            if (INFO) {
                log.info("Marshalling to '" + file.getAbsolutePath() + "'");
            }
            writer = new FileWriter(file);
            JAXBUtils.marshalToWriter(object, writer);
        }
        catch (IOException e2) {
            throw new JAXBException((Throwable)e2);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e3) {
                    log.warn("Error closing file '" + file + "'");
                }
            }
        }
    }

    public static final Element marshalToElement(Object object) throws JAXBException {
        return JAXBUtils.marshalToElement(object, null, null);
    }

    public static final Element marshalToElement(Object object, String packageName) throws JAXBException {
        return JAXBUtils.marshalToElement(object, null, packageName);
    }

    public static final Element marshalToElement(Object object, Marshaller marshaller) throws JAXBException {
        return JAXBUtils.marshalToElement(object, marshaller, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element marshalToElement(Object object, Marshaller marshaller, String packageName) throws JAXBException {
        Document doc;
        try {
            doc = LazyDocumentBuilder.createDocument();
        }
        catch (ParserConfigurationException e2) {
            throw new JAXBException((Throwable)e2);
        }
        Marshaller marshallerToUse = marshaller != null ? marshaller : (packageName == null ? JAXBUtils.getMarshaller(object.getClass()) : JAXBUtils.getMarshaller(packageName));
        Marshaller marshaller2 = marshallerToUse;
        synchronized (marshaller2) {
            marshallerToUse.marshal(object, (Node)doc);
        }
        return doc.getDocumentElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Unmarshaller getUnmarshaller(String packageName) throws JAXBException {
        Map<String, Unmarshaller> map3 = packageNameUnmarshallerCache;
        synchronized (map3) {
            if (!packageNameUnmarshallerCache.containsKey(packageName)) {
                packageNameUnmarshallerCache.put(packageName, JAXBContext.newInstance((String)packageName).createUnmarshaller());
            }
        }
        return packageNameUnmarshallerCache.get(packageName);
    }

    public static final Unmarshaller getUncachedUnmarshaller(String packageName) throws JAXBException {
        return JAXBUtils.getContext(packageName).createUnmarshaller();
    }

    private static final Marshaller setMarshallerProperties(Marshaller marshaller) throws JAXBException {
        if (marshaller != null) {
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        }
        return marshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Marshaller getMarshaller(String packageName) throws JAXBException {
        Map<String, Marshaller> map3 = packageNameMarshallerCache;
        synchronized (map3) {
            if (!packageNameMarshallerCache.containsKey(packageName)) {
                packageNameMarshallerCache.put(packageName, JAXBUtils.setMarshallerProperties(JAXBUtils.getContext(packageName).createMarshaller()));
            }
        }
        return packageNameMarshallerCache.get(packageName);
    }

    public static final Marshaller getUncachedMarshaller(String packageName) throws JAXBException {
        return JAXBUtils.setMarshallerProperties(JAXBUtils.getContext(packageName).createMarshaller());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final JAXBContext getContext(String packageName) throws JAXBException {
        Map<String, JAXBContext> map3 = packageNameContextCache;
        synchronized (map3) {
            if (!packageNameContextCache.containsKey(packageName)) {
                packageNameContextCache.put(packageName, JAXBContext.newInstance((String)packageName));
            }
        }
        return packageNameContextCache.get(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Unmarshaller getUnmarshaller(Class<?> ... classes2) throws JAXBException {
        JAXBContext context = JAXBUtils.getContext(classes2);
        Map<JAXBContext, Unmarshaller> map3 = unmarshallerCache;
        synchronized (map3) {
            if (!unmarshallerCache.containsKey(context)) {
                unmarshallerCache.put(context, context.createUnmarshaller());
            }
            return unmarshallerCache.get(context);
        }
    }

    public static final Unmarshaller getUncachedUnmarshaller(Class<?> ... classes2) throws JAXBException {
        return JAXBUtils.getContext(classes2).createUnmarshaller();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Marshaller getMarshaller(Class<?> ... classes2) throws JAXBException {
        JAXBContext context = JAXBUtils.getContext(classes2);
        Map<JAXBContext, Marshaller> map3 = marshallerCache;
        synchronized (map3) {
            if (!marshallerCache.containsKey(context)) {
                marshallerCache.put(context, JAXBUtils.setMarshallerProperties(context.createMarshaller()));
            }
        }
        return marshallerCache.get(context);
    }

    public static final Marshaller getUncachedMarshaller(Class<?> ... classes2) throws JAXBException {
        return JAXBUtils.setMarshallerProperties(JAXBUtils.getContext(classes2).createMarshaller());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final JAXBContext getContext(Class<?> ... classes2) throws JAXBException {
        if (classes2 == null || classes2.length < 1) {
            throw new JAXBException("Null or empty list of classes passed in.");
        }
        if (!ClassTools.allSamePackage(classes2)) {
            throw new JAXBException("Passed-in classes have different packages.");
        }
        String packageName = classes2[0].getPackage().getName();
        Set<Class<?>> classSet = Util.asSet(classes2);
        Map<String, CacheEntry> map3 = contextCache;
        synchronized (map3) {
            if (!contextCache.containsKey(packageName)) {
                CacheEntry cacheEntry = new CacheEntry();
                cacheEntry.classSet = classSet;
                cacheEntry.context = JAXBContext.newInstance((Class[])classes2);
                contextCache.put(packageName, cacheEntry);
            } else if (!contextCache.get(packageName).classSet.containsAll(classSet)) {
                CacheEntry cacheEntry = contextCache.get(packageName);
                JAXBUtils.invalidateMarshallerAndUnmarshallerCaches(cacheEntry.context);
                cacheEntry.classSet.addAll(classSet);
                cacheEntry.context = JAXBUtils.makeJAXBContext(cacheEntry.classSet);
            }
            return contextCache.get(packageName).context;
        }
    }

    private static final JAXBContext makeJAXBContext(Set<Class<?>> classSet) throws JAXBException {
        return JAXBContext.newInstance((Class[])classSet.toArray(new Class[classSet.size()]));
    }

    private static final synchronized void invalidateMarshallerAndUnmarshallerCaches(JAXBContext context) {
        marshallerCache.remove(context);
        unmarshallerCache.remove(context);
    }

    public static final Marshaller synchronizedMarshaller(Marshaller marshaller) {
        return new SynchronizedMarshaller(marshaller);
    }

    public static final Unmarshaller synchronizedUnmarshaller(Unmarshaller unmarshaller) {
        return new SynchronizedUnmarshaller(unmarshaller);
    }

    private static final class ByteArraySchemaOutputResolver
    extends SchemaOutputResolver {
        private final List<ByteArrayOutputStream> outs = Util.makeArrayList();

        public Result createOutput(String namespaceUri, String suggestedFileName) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.outs.add(out);
            StreamResult streamResult = new StreamResult(out);
            streamResult.setSystemId("");
            return streamResult;
        }

        public final void printSchemaToConsole() {
            for (ByteArrayOutputStream out : this.outs) {
                System.out.append(new String(out.toByteArray()));
            }
        }

        public final List<ByteArrayOutputStream> getOutputs() {
            return Util.makeArrayList(this.outs);
        }
    }

    private static final class SynchronizedUnmarshaller
    implements Unmarshaller {
        private final Unmarshaller delegate;

        private SynchronizedUnmarshaller(Unmarshaller delegate) {
            this.delegate = delegate;
        }

        public synchronized <A extends XmlAdapter> A getAdapter(Class<A> arg0) {
            return (A)this.delegate.getAdapter(arg0);
        }

        public synchronized AttachmentUnmarshaller getAttachmentUnmarshaller() {
            return this.delegate.getAttachmentUnmarshaller();
        }

        public synchronized ValidationEventHandler getEventHandler() throws JAXBException {
            return this.delegate.getEventHandler();
        }

        public synchronized Unmarshaller.Listener getListener() {
            return this.delegate.getListener();
        }

        public synchronized Object getProperty(String arg0) throws PropertyException {
            return this.delegate.getProperty(arg0);
        }

        public synchronized Schema getSchema() {
            return this.delegate.getSchema();
        }

        public synchronized UnmarshallerHandler getUnmarshallerHandler() {
            return this.delegate.getUnmarshallerHandler();
        }

        @Deprecated
        public synchronized boolean isValidating() throws JAXBException {
            return this.delegate.isValidating();
        }

        public synchronized <A extends XmlAdapter> void setAdapter(Class<A> arg0, A arg1) {
            this.delegate.setAdapter(arg0, arg1);
        }

        public synchronized void setAdapter(XmlAdapter arg0) {
            this.delegate.setAdapter(arg0);
        }

        public synchronized void setAttachmentUnmarshaller(AttachmentUnmarshaller arg0) {
            this.delegate.setAttachmentUnmarshaller(arg0);
        }

        public synchronized void setEventHandler(ValidationEventHandler arg0) throws JAXBException {
            this.delegate.setEventHandler(arg0);
        }

        public synchronized void setListener(Unmarshaller.Listener arg0) {
            this.delegate.setListener(arg0);
        }

        public synchronized void setProperty(String arg0, Object arg1) throws PropertyException {
            this.delegate.setProperty(arg0, arg1);
        }

        public synchronized void setSchema(Schema arg0) {
            this.delegate.setSchema(arg0);
        }

        @Deprecated
        public synchronized void setValidating(boolean arg0) throws JAXBException {
            this.delegate.setValidating(arg0);
        }

        public synchronized Object unmarshal(File arg0) throws JAXBException {
            return this.delegate.unmarshal(arg0);
        }

        public synchronized Object unmarshal(InputSource arg0) throws JAXBException {
            return this.delegate.unmarshal(arg0);
        }

        public synchronized Object unmarshal(InputStream arg0) throws JAXBException {
            return this.delegate.unmarshal(arg0);
        }

        public synchronized <T> JAXBElement<T> unmarshal(Node arg0, Class<T> arg1) throws JAXBException {
            return this.delegate.unmarshal(arg0, arg1);
        }

        public synchronized Object unmarshal(Node arg0) throws JAXBException {
            return this.delegate.unmarshal(arg0);
        }

        public synchronized Object unmarshal(Reader arg0) throws JAXBException {
            return this.delegate.unmarshal(arg0);
        }

        public synchronized <T> JAXBElement<T> unmarshal(Source arg0, Class<T> arg1) throws JAXBException {
            return this.delegate.unmarshal(arg0, arg1);
        }

        public synchronized Object unmarshal(Source arg0) throws JAXBException {
            return this.delegate.unmarshal(arg0);
        }

        public synchronized Object unmarshal(URL arg0) throws JAXBException {
            return this.delegate.unmarshal(arg0);
        }

        public synchronized <T> JAXBElement<T> unmarshal(XMLEventReader arg0, Class<T> arg1) throws JAXBException {
            return this.delegate.unmarshal(arg0, arg1);
        }

        public synchronized Object unmarshal(XMLEventReader arg0) throws JAXBException {
            return this.delegate.unmarshal(arg0);
        }

        public synchronized <T> JAXBElement<T> unmarshal(XMLStreamReader arg0, Class<T> arg1) throws JAXBException {
            return this.delegate.unmarshal(arg0, arg1);
        }

        public synchronized Object unmarshal(XMLStreamReader arg0) throws JAXBException {
            return this.delegate.unmarshal(arg0);
        }
    }

    private static final class SynchronizedMarshaller
    implements Marshaller {
        private final Marshaller delegate;

        private SynchronizedMarshaller(Marshaller delegate) {
            this.delegate = delegate;
        }

        public synchronized <A extends XmlAdapter> A getAdapter(Class<A> arg0) {
            return (A)this.delegate.getAdapter(arg0);
        }

        public synchronized AttachmentMarshaller getAttachmentMarshaller() {
            return this.delegate.getAttachmentMarshaller();
        }

        public synchronized ValidationEventHandler getEventHandler() throws JAXBException {
            return this.delegate.getEventHandler();
        }

        public synchronized Marshaller.Listener getListener() {
            return this.delegate.getListener();
        }

        public synchronized Node getNode(Object arg0) throws JAXBException {
            return this.delegate.getNode(arg0);
        }

        public synchronized Object getProperty(String arg0) throws PropertyException {
            return this.delegate.getProperty(arg0);
        }

        public synchronized Schema getSchema() {
            return this.delegate.getSchema();
        }

        public synchronized void marshal(Object arg0, ContentHandler arg1) throws JAXBException {
            this.delegate.marshal(arg0, arg1);
        }

        public synchronized void marshal(Object arg0, File arg1) throws JAXBException {
            this.delegate.marshal(arg0, arg1);
        }

        public synchronized void marshal(Object arg0, Node arg1) throws JAXBException {
            this.delegate.marshal(arg0, arg1);
        }

        public synchronized void marshal(Object arg0, OutputStream arg1) throws JAXBException {
            this.delegate.marshal(arg0, arg1);
        }

        public synchronized void marshal(Object arg0, Result arg1) throws JAXBException {
            this.delegate.marshal(arg0, arg1);
        }

        public synchronized void marshal(Object arg0, Writer arg1) throws JAXBException {
            this.delegate.marshal(arg0, arg1);
        }

        public synchronized void marshal(Object arg0, XMLEventWriter arg1) throws JAXBException {
            this.delegate.marshal(arg0, arg1);
        }

        public synchronized void marshal(Object arg0, XMLStreamWriter arg1) throws JAXBException {
            this.delegate.marshal(arg0, arg1);
        }

        public synchronized <A extends XmlAdapter> void setAdapter(Class<A> arg0, A arg1) {
            this.delegate.setAdapter(arg0, arg1);
        }

        public synchronized void setAdapter(XmlAdapter arg0) {
            this.delegate.setAdapter(arg0);
        }

        public synchronized void setAttachmentMarshaller(AttachmentMarshaller arg0) {
            this.delegate.setAttachmentMarshaller(arg0);
        }

        public synchronized void setEventHandler(ValidationEventHandler arg0) throws JAXBException {
            this.delegate.setEventHandler(arg0);
        }

        public synchronized void setListener(Marshaller.Listener arg0) {
            this.delegate.setListener(arg0);
        }

        public synchronized void setProperty(String arg0, Object arg1) throws PropertyException {
            this.delegate.setProperty(arg0, arg1);
        }

        public synchronized void setSchema(Schema arg0) {
            this.delegate.setSchema(arg0);
        }
    }

    private static final class CacheEntry {
        private Set<Class<?>> classSet;
        private JAXBContext context;

        CacheEntry() {
        }
    }

    private static final class LazyDocumentBuilder {
        private static DocumentBuilder value;

        private LazyDocumentBuilder() {
        }

        private static final synchronized void initDocumentBuilder() throws ParserConfigurationException {
            if (value == null) {
                value = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Document createDocument() throws ParserConfigurationException {
            LazyDocumentBuilder.initDocumentBuilder();
            DocumentBuilder documentBuilder = value;
            synchronized (documentBuilder) {
                return value.newDocument();
            }
        }
    }

    private static final class TransformerFactoryHolder {
        private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();

        private TransformerFactoryHolder() {
        }
    }
}

