/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.Environment;
import org.spin.tools.filter.FileFilterTool;
import org.spin.tools.filter.FileFilters;

public final class Plugins {
    private static final Logger log = Logger.getLogger(Plugins.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static URLClassLoader pluginClassLoader = null;
    private static final Object lock = new Object();

    private Plugins() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final URLClassLoader getPluginClassLoader() throws ConfigException {
        Object object = lock;
        synchronized (object) {
            if (pluginClassLoader == null) {
                URL[] urls2 = Plugins.getPluginResourceURLs().toArray(new URL[0]);
                pluginClassLoader = new URLClassLoader(urls2, Plugins.class.getClassLoader());
            }
            return pluginClassLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void invalidatePluginClassLoader() {
        Object object = lock;
        synchronized (object) {
            pluginClassLoader = null;
        }
    }

    private static final List<URL> getPluginResourceURLs() throws ConfigException {
        File pluginDir = Environment.getPluginDir();
        File[] jars = FileFilterTool.recursiveFilter(pluginDir, FileFilters.withExtension("jar"));
        if (INFO) {
            log.info("Using these jars for plugins: " + Arrays.asList(jars));
        }
        ArrayList<URL> result2 = Util.makeArrayList(jars.length);
        for (File jar : jars) {
            try {
                result2.add(jar.toURI().toURL());
            }
            catch (MalformedURLException e2) {
                log.warn("Error locating plugin jar '" + jar + "': ", e2);
            }
        }
        return result2;
    }
}

