/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.spin.tools.FileUtils;
import org.spin.tools.JAXBUtils;
import org.spin.tools.RandomTool;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.Environment;
import org.spin.tools.config.KeyStoreConfig;
import org.spin.tools.config.Module;
import org.spin.tools.config.NodeConfig;
import org.spin.tools.config.RoutingTableConfig;
import org.spin.tools.config.ValidationException;

public final class ConfigTool {
    private static final Logger log = Logger.getLogger(ConfigTool.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final Object lock = new Object();
    private static volatile boolean onlyUseClassloader = false;
    private static final SecureRandom secureRandom = ConfigTool.makeSecureRandom();

    private ConfigTool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean onlyUseClassloader() {
        Object object = lock;
        synchronized (object) {
            return onlyUseClassloader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onlyUseClassloader(boolean shouldOnlyUseClassloader) {
        Object object = lock;
        synchronized (object) {
            onlyUseClassloader = shouldOnlyUseClassloader;
        }
    }

    public static final void initLog4J() {
        String log4JConfigFileName = "log4j.properties";
        try {
            PropertyConfigurator.configure(ConfigTool.getProperties(ConfigTool.getConfigFileStream("log4j.properties")));
        }
        catch (Exception e2) {
            System.out.println("'log4j.properties' not found: could not initialize Log4J for Spin tools: " + e2.getMessage());
        }
    }

    private static final boolean shouldUseClassloader(File desiredConfigFile) {
        return ConfigTool.onlyUseClassloader() || !desiredConfigFile.exists();
    }

    public static final InputStream getClasspathResource(String resourceName) {
        return ConfigTool.getClassLoader().getResourceAsStream(resourceName);
    }

    @Deprecated
    public static final URL getClasspathResourceAsURL(String resourceName) {
        return ConfigTool.getClassLoader().getResource(resourceName);
    }

    public static final URI getClasspathResourceAsURI(String resourceName) {
        URL resourceURL = ConfigTool.getClassLoader().getResource(resourceName);
        if (resourceURL == null) {
            return null;
        }
        try {
            return resourceURL.toURI();
        }
        catch (URISyntaxException e2) {
            throw new ConfigException("Couldn't get a classpath URI for resource '" + resourceName + "'", e2);
        }
    }

    private static final ClassLoader getClassLoader() {
        return ConfigTool.class.getClassLoader();
    }

    public static final URI getConfigFileAsURI(String desiredFileName) {
        File desiredFile = ConfigTool.getConfigFile(desiredFileName);
        if (ConfigTool.shouldUseClassloader(desiredFile)) {
            URI result2 = ConfigTool.getClasspathResourceAsURI(desiredFileName);
            if (result2 == null) {
                throw new ConfigException(desiredFileName + " was not found on the classpath or file system.");
            }
            return result2;
        }
        try {
            return desiredFile.toURI();
        }
        catch (Exception e2) {
            throw new ConfigException(e2);
        }
    }

    @Deprecated
    public static final URL getConfigFileAsURL(String desiredFileName) {
        File desiredFile = ConfigTool.getConfigFile(desiredFileName);
        if (ConfigTool.shouldUseClassloader(desiredFile)) {
            URL result2 = ConfigTool.getClasspathResourceAsURL(desiredFileName);
            if (result2 == null) {
                throw new ConfigException(desiredFileName + " was not found on the classpath or file system.");
            }
            return result2;
        }
        try {
            return desiredFile.toURL();
        }
        catch (MalformedURLException e2) {
            throw new ConfigException(e2);
        }
    }

    public static final String makeXMLFileName(Module module2) {
        assert (module2 != null);
        return ConfigTool.makeXMLFileName(module2.name());
    }

    private static final String makeXMLFileName(String module2) {
        return module2 + ".xml";
    }

    public static File getConfigFile(Module moduleName) {
        return ConfigTool.getConfigFile(ConfigTool.makeXMLFileName(moduleName.name()));
    }

    public static File getConfigFile(String filename) {
        File rawFile = new File(filename);
        if (rawFile.isAbsolute()) {
            return rawFile;
        }
        return new File(Environment.getConfDir() + File.separator + filename);
    }

    public static File getConfigFileWithFailover(String filename) {
        File file = ConfigTool.getConfigFile(filename);
        if (file.exists()) {
            if (DEBUG) {
                log.debug("Found " + filename + " absolute path= " + file.getAbsolutePath());
            }
            return file;
        }
        URI classLoaderURI = ConfigTool.getConfigFileAsURI(filename);
        if (classLoaderURI != null) {
            if (DEBUG) {
                log.debug("Found " + filename + " classloaded path= " + classLoaderURI.getPath());
            }
            try {
                return new File(classLoaderURI.toURL().getFile());
            }
            catch (MalformedURLException e2) {
                throw new ConfigException(e2);
            }
        }
        throw new ConfigException("Could not find " + filename + " on the filesystem or classpath ");
    }

    public static File getConfigFileFromClassloadedDir(String filename) {
        String path2;
        try {
            path2 = ConfigTool.getConfigFileAsURI(filename).toURL().getFile();
        }
        catch (MalformedURLException e2) {
            throw new ConfigException("Couldn't access file '" + filename + "'", e2);
        }
        File result2 = new File(path2);
        if (!result2.exists()) {
            throw new ConfigException("File at '" + path2 + "' is not accessible via normal means.  Perhaps it's inside an archive?");
        }
        return result2;
    }

    public static Reader getConfigFileReader(Module module2) {
        return ConfigTool.getConfigFileReader(module2.name());
    }

    public static Reader getConfigFileReader(String moduleName) {
        return new InputStreamReader(ConfigTool.getXMLConfigFileStream(moduleName));
    }

    public static InputStream getXMLConfigFileStream(String moduleName) {
        if (INFO) {
            log.info("Loading from " + ConfigTool.getConfigFileAsURI(ConfigTool.makeXMLFileName(moduleName)));
        }
        return ConfigTool.getConfigFileStream(ConfigTool.makeXMLFileName(moduleName));
    }

    public static InputStream getConfigFileStream(File desiredFile) {
        if (desiredFile.isAbsolute() && !ConfigTool.shouldUseClassloader(desiredFile)) {
            try {
                return new FileInputStream(desiredFile);
            }
            catch (FileNotFoundException e2) {
                throw new ConfigException(e2);
            }
        }
        return ConfigTool.getConfigFileStream(desiredFile.getName());
    }

    public static InputStream getConfigFileStream(String desiredFileName) {
        File result2 = ConfigTool.getAbsoluteFileName(desiredFileName);
        if (ConfigTool.shouldUseClassloader(result2)) {
            InputStream configStream;
            if (DEBUG) {
                log.debug("Using class loader");
            }
            if ((configStream = ConfigTool.getClasspathResource(desiredFileName)) == null) {
                throw new ConfigException("Couldn't find '" + desiredFileName + "' on the file system [ " + result2.getAbsolutePath() + " ] or classpath.");
            }
            return configStream;
        }
        try {
            return new FileInputStream(result2);
        }
        catch (FileNotFoundException e2) {
            throw new ConfigException(e2);
        }
    }

    private static File getAbsoluteFileName(String desiredFileName) {
        File result2 = new File(desiredFileName);
        if (!result2.isAbsolute()) {
            return new File(FileUtils.makePathString(Environment.getConfDir().toString(), desiredFileName));
        }
        return result2;
    }

    public static String getConfigText(String filename) throws IOException {
        return FileUtils.read(ConfigTool.getConfigFileStream(filename));
    }

    public static Properties getConfigProperties(String filename) throws FileNotFoundException, IOException {
        return ConfigTool.getProperties(ConfigTool.getConfigFile(filename));
    }

    public static Properties getProperties(File propertiesFile) throws FileNotFoundException, IOException {
        return ConfigTool.getProperties(new FileInputStream(propertiesFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(InputStream propertiesStream) throws IOException {
        Util.guardNotNull(propertiesStream);
        Properties props = new Properties();
        try {
            props.load(propertiesStream);
            Properties properties2 = props;
            return properties2;
        }
        finally {
            propertiesStream.close();
        }
    }

    public static final NodeConfig loadNodeConfig() {
        return ConfigTool.load(Module.node, NodeConfig.class);
    }

    public static final void writeNodeConfig(NodeConfig config) {
        ConfigTool.write(Module.node, (Object)config);
    }

    public static final KeyStoreConfig loadKeyStoreConfig() {
        try {
            return ConfigTool.load(Module.keystore, KeyStoreConfig.class);
        }
        catch (ValidationException ve) {
            throw ve;
        }
        catch (ConfigException e2) {
            String fileName = FileUtils.makePathString(Environment.getConfDir().toString(), ConfigTool.makeXMLFileName(Module.keystore));
            log.warn("Trying to generate keystore, unable to load from: '" + fileName + "'. File exists? " + FileUtils.exists(fileName));
            ConfigTool.generateKeystoreAndConfigFile();
            try {
                return ConfigTool.load(Module.keystore, KeyStoreConfig.class);
            }
            catch (ConfigException ee) {
                throw new ConfigException("Unable to find keystore config file and unable to generate default key store file.", ee);
            }
        }
    }

    private static final void generateKeystoreAndConfigFile() {
        String hostname = ConfigTool.getHostName();
        String password = "spinkeystore";
        String directoryName = Environment.getConfDir().toString();
        ConfigTool.makeKeyStoreDirIfNecessary(directoryName);
        String keystoreConfigFileName = ConfigTool.makeXMLFileName(Module.keystore);
        File keystoreXmlFile = ConfigTool.getQualifiedFileName(directoryName, keystoreConfigFileName);
        File keystoreFile = ConfigTool.generateCertificateAndKeyStoreFiles(directoryName, hostname, "spinkeystore");
        try {
            KeyStoreConfig keystoreConfig = KeyStoreConfig.Default.withFile(keystoreFile).withPassword("spinkeystore").withKeyAlias(hostname);
            if (!keystoreXmlFile.exists()) {
                keystoreXmlFile.createNewFile();
            }
            JAXBUtils.marshalToFile(keystoreConfig, keystoreXmlFile);
        }
        catch (IOException e2) {
            throw new ConfigException(e2);
        }
        catch (JAXBException e3) {
            throw new ConfigException("Error marshalling auto-generated keystore to xml file.", e3);
        }
    }

    private static final File getQualifiedFileName(String directoryName, String fileName) {
        File file = new File(fileName);
        if (!file.isAbsolute()) {
            return new File(FileUtils.makePathString(directoryName, fileName));
        }
        return file;
    }

    private static void makeKeyStoreDirIfNecessary(String directoryName) {
        if (!new File(directoryName).exists() && !new File(directoryName).mkdir()) {
            throw new ConfigException("Unable to create directories to store keystore file.");
        }
    }

    private static final File generateCertificateAndKeyStoreFiles(String directoryName, String hostname, String password) {
        String keystoreFileName = Defaults.keystoreFilename;
        File keystoreFile = ConfigTool.getQualifiedFileName(directoryName, keystoreFileName);
        String certFileName = keystoreFileName + ".cer";
        File certFile = ConfigTool.getQualifiedFileName(directoryName, certFileName);
        try {
            KeyPair keypair = ConfigTool.generateKeyPair();
            X509Certificate certificate = ConfigTool.createCertificate(keypair, hostname);
            Certificate[] certChain = Util.asArray(certificate);
            ConfigTool.writeCertToDisk(certFile, certificate);
            KeyStore keystore = ConfigTool.makeKeyStore(hostname, password, keypair, certChain);
            ConfigTool.writeKeystoreToDisk(keystoreFile, keystore, password);
            return keystoreFile;
        }
        catch (Exception e2) {
            throw new ConfigException("Error generating and/or writing keystore/keypair/certificate: ", e2);
        }
    }

    private static KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keypairGenerator = KeyPairGenerator.getInstance("RSA");
        return keypairGenerator.generateKeyPair();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCertToDisk(File certFile, X509Certificate certificate) throws CertificateEncodingException, IOException {
        FileOutputStream certStream = new FileOutputStream(certFile);
        try {
            certStream.write(certificate.getEncoded());
            if (INFO) {
                log.info("Certificate written to <" + certFile.getAbsolutePath() + ">.");
            }
        }
        finally {
            try {
                certStream.close();
            }
            catch (IOException ioe) {
                log.warn("Couldn't close certificate file '" + certFile + "'", ioe);
            }
        }
    }

    private static KeyStore makeKeyStore(String hostname, String password, KeyPair keypair, Certificate[] certChain) throws FileNotFoundException, CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException {
        KeyStore keystore = KeyStore.getInstance(KeyStoreConfig.defaultKeystoreType.name());
        keystore.load(null);
        keystore.setKeyEntry(hostname, keypair.getPrivate(), password.toCharArray(), certChain);
        return keystore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeKeystoreToDisk(File keystoreFile, KeyStore keystore, String password) throws FileNotFoundException, CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException {
        FileOutputStream keystoreFos = new FileOutputStream(keystoreFile);
        try {
            keystore.store(keystoreFos, password.toCharArray());
            if (INFO) {
                log.info("Keystore written to <" + keystoreFile.getAbsolutePath() + ">.");
            }
        }
        finally {
            try {
                keystoreFos.close();
            }
            catch (IOException ioe) {
                log.warn("Couldn't close keystore file: '" + keystoreFile + "'", ioe);
            }
        }
    }

    private static final X509Certificate createCertificate(KeyPair keypair, String hostname) {
        String quote2 = "\"";
        X509Principal dName = new X509Principal("CN=\"" + hostname + "\"");
        long oneMonth = 2592000000L;
        long oneYear = 31104000000L;
        Date startDate = new Date(System.currentTimeMillis() - 2592000000L);
        Date endDate = new Date(System.currentTimeMillis() + 1555200000000L);
        BigInteger serialNum = ConfigTool.generateSerialNumber();
        X509V3CertificateGenerator certGenerator = ConfigTool.makeCertGenerator(keypair, dName, startDate, endDate, serialNum);
        try {
            return certGenerator.generate(keypair.getPrivate());
        }
        catch (Exception e2) {
            throw new ConfigException("Error generating certificate: ", e2);
        }
    }

    private static X509V3CertificateGenerator makeCertGenerator(KeyPair keypair, X509Principal dName, Date startDate, Date endDate, BigInteger serialNum) {
        X509V3CertificateGenerator certGenerator = new X509V3CertificateGenerator();
        certGenerator.setPublicKey(keypair.getPublic());
        certGenerator.setSignatureAlgorithm("SHA1withRSA");
        certGenerator.setIssuerDN(dName);
        certGenerator.setSubjectDN(dName);
        certGenerator.setSerialNumber(serialNum);
        certGenerator.setNotBefore(startDate);
        certGenerator.setNotAfter(endDate);
        return certGenerator;
    }

    private static BigInteger generateSerialNumber() {
        return BigInteger.valueOf(1 + secureRandom.nextInt(Integer.MAX_VALUE));
    }

    private static SecureRandom makeSecureRandom() {
        SecureRandom randSerial = new SecureRandom();
        randSerial.setSeed(RandomTool.randomBigInteger().longValue());
        return randSerial;
    }

    public static final void writeKeyStoreConfig(KeyStoreConfig config) {
        ConfigTool.write(Module.keystore, (Object)config);
    }

    public static final RoutingTableConfig loadRoutingTableConfig() {
        return ConfigTool.load(Module.routingtable, RoutingTableConfig.class);
    }

    public static final void writeRoutingTableConfig(RoutingTableConfig config) {
        ConfigTool.write(Module.routingtable, (Object)config);
    }

    public static final <T> T load(Module moduleName, Class<T> configurationClass) {
        return ConfigTool.load(ConfigTool.getConfigFileReader(moduleName), configurationClass);
    }

    public static final void write(Module moduleName, Object configurationClass) {
        ConfigTool.write(ConfigTool.getConfigFile(moduleName), configurationClass);
    }

    protected static final <T> T load(File configFile, Class<T> configurationClass) {
        if (INFO) {
            log.info("Loading " + configFile.getAbsolutePath());
        }
        try {
            return ConfigTool.load(new FileReader(configFile), configurationClass);
        }
        catch (ConfigException e2) {
            log.fatal("Failed to load! " + configFile.getAbsolutePath(), e2);
            throw e2;
        }
        catch (Exception e3) {
            log.fatal("Failed to load! " + configFile.getAbsolutePath(), e3);
            throw new ConfigException(e3);
        }
    }

    public static final <T> T load(Reader configFile, Class<T> configurationClass) {
        try {
            return JAXBUtils.unmarshalAndValidate(configFile, configurationClass);
        }
        catch (JAXBException je) {
            throw new ValidationException("Validation failed! Expected a serialized " + configurationClass, je);
        }
        catch (Exception e2) {
            throw new ConfigException("Could not load config file: '" + configFile + "'", e2);
        }
    }

    public static final void write(File configFile, Object configurationClass) {
        try {
            if (INFO) {
                log.info("Writing file " + configFile.getAbsolutePath());
            }
            configFile.getParentFile().mkdirs();
            if (configFile.exists()) {
                File backup = new File(configFile + ".bak");
                if (backup.exists()) {
                    backup.delete();
                }
                configFile.renameTo(backup);
            }
            ConfigTool.writeConfigObjectAsXML(configFile, configurationClass);
        }
        catch (Exception e2) {
            throw new ConfigException("Could not write file: " + configFile.getAbsoluteFile(), e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeConfigObjectAsXML(File configFile, Object configurationClass) throws IOException, JAXBException {
        FileWriter writer = new FileWriter(configFile);
        try {
            JAXBUtils.marshalToWriter(configurationClass, writer);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e2) {
                log.warn("Couldn't close file '" + configFile + "'");
            }
        }
    }

    public static String getHostName() {
        String hostname = null;
        try {
            hostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e2) {
            hostname = System.getProperty("HOSTNAME");
        }
        return hostname == null ? "localhost" : hostname;
    }

    static {
        ConfigTool.initLog4J();
    }

    private static final class Defaults {
        public static final String keystoreFilename = ConfigTool.getHostName() + ".keystore";
        public static final String keystorePassword = "spinkeystore";

        private Defaults() {
        }
    }
}

