/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;

public final class Environment {
    private static final Logger log = Logger.getLogger(Environment.class);
    private static final Object lock = new Object();
    public static final String SPIN_HOME_UNIX_DEFAULT = ".spin";
    public static final String SPIN_HOME_WIN_DEFAULT = "spin";
    public static final String runtimeProperites = "spinRuntime.properties";
    public static final String keystorePrefix = "spin";
    private static File homeDir;
    private static File confDir;
    private static File pluginDir;

    private Environment() {
    }

    private static String determineSpinHomeDirectory() {
        String spinHome = System.getProperty("SPIN_HOME");
        if (spinHome != null) {
            return spinHome;
        }
        spinHome = System.getenv("SPIN_HOME");
        if (spinHome != null) {
            return spinHome;
        }
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            throw new ConfigException("Couldn't determine home directory!");
        }
        return userHome + File.separator + (Environment.isWindows() ? "spin" : SPIN_HOME_UNIX_DEFAULT);
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toUpperCase().contains("WINDOWS");
    }

    public static File getHomeDir() {
        return homeDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setHomeDir(File userDefinedHomeDir) {
        if (userDefinedHomeDir == null) {
            throw new IllegalArgumentException("Null home directory base passed in");
        }
        File normalized = Environment.normalize(userDefinedHomeDir);
        Object object = lock;
        synchronized (object) {
            homeDir = normalized;
            Environment.invalidateDerivedDirs();
        }
        log.info("Now using home dir '" + homeDir + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invalidateDerivedDirs() {
        Object object = lock;
        synchronized (object) {
            confDir = null;
            pluginDir = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getConfDir() {
        Object object = lock;
        synchronized (object) {
            if (confDir == null) {
                String spinConfigPath = Environment.getHomeDir() + File.separator + (Object)((Object)SubDirName.conf);
                confDir = new File(spinConfigPath);
                log.info("Using '" + confDir + "' as Spin config directory");
            }
            return confDir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getPluginDir() {
        Object object = lock;
        synchronized (object) {
            if (pluginDir == null) {
                String spinPluginPath = Environment.getHomeDir() + File.separator + (Object)((Object)SubDirName.plugins);
                pluginDir = new File(spinPluginPath);
                log.info("Using '" + pluginDir + "' as Spin plugin directory");
            }
            return pluginDir;
        }
    }

    private static void makeDirIfNecessary(File dir) {
        Util.guardNotNull(dir);
        if (!dir.exists()) {
            log.info("'" + dir + "' doesn't exist.");
            if (!dir.mkdirs()) {
                throw new ConfigException("Couldn't create '" + dir + "'.  Please make it yourself.");
            }
            log.info("Successfully created '" + dir + "'.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConfDir(File pathToConfigDir) {
        Util.guardNotNull(pathToConfigDir);
        File normalized = Environment.normalize(pathToConfigDir);
        Object object = lock;
        synchronized (object) {
            confDir = normalized;
            log.info("Config dir is now " + confDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPluginDir(File pathToPluginDir) {
        Util.guardNotNull(pathToPluginDir);
        File normalized = Environment.normalize(pathToPluginDir);
        Object object = lock;
        synchronized (object) {
            pluginDir = normalized;
            log.info("Plugin dir is now " + pluginDir);
        }
    }

    private static File normalize(File file) {
        Util.guardNotNull(file);
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e2) {
            throw new ConfigException("Couldn't get canonical path to user provided dir '" + file + "'", e2);
        }
    }

    static {
        confDir = null;
        pluginDir = null;
        try {
            Environment.setHomeDir(new File(Environment.determineSpinHomeDirectory()));
        }
        catch (ConfigException e2) {
            throw new ConfigException("Error locating Spin home directory; this is bad.  Specify it as a JVM system property or environment variable with the name 'SPIN_HOME'. Error: ", e2);
        }
        if (Environment.class.getClassLoader().getResourceAsStream("runtime.properties") != null) {
            log.info("WARNING: Found runtime.properties on the classpath; the new name to use is 'spinRuntime.properties'");
        }
        Properties properties2 = new Properties();
        try {
            properties2.load(Environment.class.getClassLoader().getResourceAsStream(runtimeProperites));
            log.info("WARNING: Initializaton via spinRuntime.properties is deprecated and WILL BE REMOVED");
        }
        catch (Exception e3) {
            log.info("Error locating runtime.properties: " + e3.getMessage());
        }
        try {
            if (properties2.containsKey("absolute")) {
                log.info("Setting user-defined absolute path for Spin home dir: '" + Environment.normalize(new File(properties2.getProperty("absolute"))) + "'");
                Environment.setHomeDir(new File(properties2.getProperty("absolute")));
            } else if (confDir != null) {
                log.info("STATIC CONEXT REINITIALIZED? absolute path is already " + Environment.getHomeDir());
            }
        }
        catch (ConfigException e4) {
            System.err.println("Error determining absolute path of Spin config directory: " + e4.getMessage());
        }
    }

    public static enum SubDirName {
        conf,
        plugins,
        db;

    }

    public static final class PropertyKeys {
        public static final String spinHome = "SPIN_HOME";
        public static final String userHome = "user.home";
        public static final String derbyHome = "derby.system.home";
        public static final String absolute = "absolute";

        private PropertyKeys() {
        }
    }
}

