/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config;

import java.io.File;
import java.util.List;
import org.spin.tools.config.KeyStoreConfig;
import org.spin.tools.config.KeyStoreType;

public final class KeyStoreConfigBuilder {
    private final File file;
    private final String password;
    private String keyAlias;
    private List<String> caPublicKeyAlias;
    private boolean attachCertificateToSignature;
    private KeyStoreType keystoreType;
    KeyStoreConfig config;

    public KeyStoreConfigBuilder(File file, String password) {
        this.config = new KeyStoreConfig(file, password, null, null, false, null);
        this.file = this.config.getFile();
        this.password = this.config.getPassword();
        this.keyAlias = this.config.getKeyAlias();
        this.caPublicKeyAlias = this.config.getCaPublicKeyAliases();
        this.attachCertificateToSignature = this.config.getAttachCertificateToSignature();
        this.keystoreType = this.config.getKeystoreType();
    }

    public KeyStoreConfig build() {
        return new KeyStoreConfig(this.file, this.password, this.keyAlias, this.caPublicKeyAlias, this.attachCertificateToSignature, this.keystoreType);
    }

    public KeyStoreConfigBuilder setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
        return this;
    }

    public KeyStoreConfigBuilder setCaPublicKeyAlias(List<String> caPublicKeyAlias) {
        this.caPublicKeyAlias = caPublicKeyAlias;
        return this;
    }

    public KeyStoreConfigBuilder setAttachCertificateToSignature(boolean attachCertificateToSignature) {
        this.attachCertificateToSignature = attachCertificateToSignature;
        return this;
    }

    public KeyStoreConfigBuilder setKeystoreType(KeyStoreType keystoreType) {
        this.keystoreType = keystoreType;
        return this;
    }
}

