/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.tools.Interval;
import org.spin.tools.Util;
import org.spin.tools.config.QueryTypeConfig;
import org.spin.tools.config.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="NodeConfig")
@XmlRootElement(name="NodeConfig")
public final class NodeConfig {
    public static final Interval defaultBroadcastTimeoutPeriod = Interval.FiveSeconds;
    public static final Long defaultCertificationTime = 3600000L;
    public static final Long defaultCacheExpirationTime = 0x6DDD00L;
    public static final Boolean defaultIsAuthenticator = Boolean.FALSE;
    public static final Boolean defaultIsBroadcaster = Boolean.TRUE;
    public static final Boolean defaultIsAggregator = Boolean.TRUE;
    public static final Boolean defaultIsQueryable = Boolean.TRUE;
    @XmlElement(name="version", required=true)
    private final String version = Version.getVersion(NodeConfig.class);
    @XmlElement(name="nodeName", required=true)
    private final String nodeName;
    @XmlElement(name="isAuthenticator", required=false)
    private final Boolean isAuthenticator;
    @XmlElement(name="isBroadcaster", required=false)
    private final Boolean isBroadcaster;
    @XmlElement(name="isAggregator", required=false)
    private final Boolean isAggregator;
    @XmlElement(name="isQueryable", required=false)
    private final Boolean isQueryable;
    @XmlElement(name="identityServiceClass", required=false)
    private final String identityServiceClass;
    @XmlElement(name="queries", required=false)
    private final List<QueryTypeConfig> queries;
    @XmlElement(name="certificationTTL", required=false)
    private final Long certificationTTL;
    @XmlElement(name="cacheTTL", required=false)
    private final Long cacheTTL;
    @XmlElement(name="broadcastTimeoutPeriod", required=false)
    private final Interval broadcastTimeoutPeriod;
    @XmlElement(name="queryActionMapClassName", required=false)
    private final String queryActionMapClassName;
    public static final List<QueryTypeConfig> EmptyQueryTypeConfigList = Arrays.asList(new Object[0]);
    public static final NodeConfig Default = new NodeConfig();

    private NodeConfig() {
        this(null, defaultIsAuthenticator, defaultIsBroadcaster, defaultIsAggregator, defaultIsQueryable, null, defaultCertificationTime, defaultCacheExpirationTime, defaultBroadcastTimeoutPeriod, null, EmptyQueryTypeConfigList);
    }

    public NodeConfig(String nodeName, Boolean isAuthenticator, Boolean isBroadcaster, Boolean isAggregator, Boolean isQueryable, String identityServiceClass, Long certificationTTL, Long cacheTTL, Interval broadcastTimeoutPeriod, String queryActionMapClassName, Collection<QueryTypeConfig> queries) {
        this.nodeName = nodeName;
        this.isAuthenticator = isAuthenticator;
        this.isBroadcaster = isBroadcaster;
        this.isAggregator = isAggregator;
        this.isQueryable = isQueryable;
        this.identityServiceClass = identityServiceClass;
        this.certificationTTL = certificationTTL;
        this.cacheTTL = cacheTTL;
        this.broadcastTimeoutPeriod = broadcastTimeoutPeriod;
        this.queryActionMapClassName = queryActionMapClassName;
        this.queries = queries != null ? Util.makeArrayList(queries) : Collections.emptyList();
    }

    public static final NodeConfig copyOf(NodeConfig other) {
        if (other == null) {
            return null;
        }
        return new NodeConfig(other.nodeName, other.isAuthenticator, other.isBroadcaster, other.isAggregator, other.isQueryable, other.identityServiceClass, other.certificationTTL, other.cacheTTL, other.broadcastTimeoutPeriod, other.queryActionMapClassName, other.queries);
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getVersion() {
        return this.version;
    }

    public NodeConfig withNodeName(String newNodeName) {
        return new NodeConfig(newNodeName, this.isAuthenticator, this.isBroadcaster, this.isAggregator, this.isQueryable, this.identityServiceClass, this.certificationTTL, this.cacheTTL, this.broadcastTimeoutPeriod, this.queryActionMapClassName, this.queries);
    }

    public List<QueryTypeConfig> getQueries() {
        return Util.makeArrayList(this.queries);
    }

    public boolean hasQueryType(String queryType) {
        for (QueryTypeConfig qt : this.getQueries()) {
            if (!qt.getQueryType().equalsIgnoreCase(queryType)) continue;
            return true;
        }
        return false;
    }

    public NodeConfig withQuery(QueryTypeConfig queryTypeConfig) {
        NodeConfig copy2 = NodeConfig.copyOf(this);
        copy2.queries.add(queryTypeConfig);
        return copy2;
    }

    public NodeConfig withQueries(Collection<QueryTypeConfig> queryList) {
        NodeConfig copy2 = NodeConfig.copyOf(this);
        copy2.queries.clear();
        copy2.queries.addAll(queryList);
        return copy2;
    }

    public Boolean isAuthenticator() {
        return this.isAuthenticator;
    }

    public NodeConfig withIsAuthenticator(Boolean newIsAuthenticator) {
        return new NodeConfig(this.nodeName, newIsAuthenticator, this.isBroadcaster, this.isAggregator, this.isQueryable, this.identityServiceClass, this.certificationTTL, this.cacheTTL, this.broadcastTimeoutPeriod, this.queryActionMapClassName, this.queries);
    }

    public String getIdentityServiceClass() {
        return this.identityServiceClass;
    }

    public NodeConfig withIdentityServiceClass(String newIdentityServiceClass) {
        return new NodeConfig(this.nodeName, this.isAuthenticator, this.isBroadcaster, this.isAggregator, this.isQueryable, newIdentityServiceClass, this.certificationTTL, this.cacheTTL, this.broadcastTimeoutPeriod, this.queryActionMapClassName, this.queries);
    }

    public Boolean isBroadcaster() {
        return this.isBroadcaster;
    }

    public NodeConfig withIsBroadcaster(Boolean newIsBroadcaster) {
        return new NodeConfig(this.nodeName, this.isAuthenticator, newIsBroadcaster, this.isAggregator, this.isQueryable, this.identityServiceClass, this.certificationTTL, this.cacheTTL, this.broadcastTimeoutPeriod, this.queryActionMapClassName, this.queries);
    }

    public Boolean isAggregator() {
        return this.isAggregator;
    }

    public NodeConfig withIsAggregator(Boolean newIsAggregator) {
        return new NodeConfig(this.nodeName, this.isAuthenticator, this.isBroadcaster, newIsAggregator, this.isQueryable, this.identityServiceClass, this.certificationTTL, this.cacheTTL, this.broadcastTimeoutPeriod, this.queryActionMapClassName, this.queries);
    }

    public Boolean isQueryable() {
        return this.isQueryable;
    }

    public NodeConfig withIsQueryable(Boolean newIsQueryable) {
        return new NodeConfig(this.nodeName, this.isAuthenticator, this.isBroadcaster, this.isAggregator, newIsQueryable, this.identityServiceClass, this.certificationTTL, this.cacheTTL, this.broadcastTimeoutPeriod, this.queryActionMapClassName, this.queries);
    }

    public Long getCertificationTTL() {
        return this.certificationTTL;
    }

    public NodeConfig withCertificationTTL(Long newCertificationTTL) {
        return new NodeConfig(this.nodeName, this.isAuthenticator, this.isBroadcaster, this.isAggregator, this.isQueryable, this.identityServiceClass, newCertificationTTL, this.cacheTTL, this.broadcastTimeoutPeriod, this.queryActionMapClassName, this.queries);
    }

    public Long getCacheTTL() {
        return this.cacheTTL;
    }

    public NodeConfig withCacheTTL(Long newCacheTTL) {
        return new NodeConfig(this.nodeName, this.isAuthenticator, this.isBroadcaster, this.isAggregator, this.isQueryable, this.identityServiceClass, this.certificationTTL, newCacheTTL, this.broadcastTimeoutPeriod, this.queryActionMapClassName, this.queries);
    }

    public Interval getBroadcastTimeoutPeriod() {
        return this.broadcastTimeoutPeriod;
    }

    public NodeConfig withBroadcastTimeoutPeriod(Interval newBroadcastTimeoutPeriod) {
        return new NodeConfig(this.nodeName, this.isAuthenticator, this.isBroadcaster, this.isAggregator, this.isQueryable, this.identityServiceClass, this.certificationTTL, this.cacheTTL, newBroadcastTimeoutPeriod, this.queryActionMapClassName, this.queries);
    }

    public String getQueryActionMapClassName() {
        return this.queryActionMapClassName;
    }

    public NodeConfig withQueryActionMapClassName(String newQueryActionMapClassName) {
        return new NodeConfig(this.nodeName, this.isAuthenticator, this.isBroadcaster, this.isAggregator, this.isQueryable, this.identityServiceClass, this.certificationTTL, this.cacheTTL, this.broadcastTimeoutPeriod, newQueryActionMapClassName, this.queries);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.broadcastTimeoutPeriod == null ? 0 : this.broadcastTimeoutPeriod.hashCode());
        result2 = 31 * result2 + (this.cacheTTL == null ? 0 : this.cacheTTL.hashCode());
        result2 = 31 * result2 + (this.certificationTTL == null ? 0 : this.certificationTTL.hashCode());
        result2 = 31 * result2 + (this.identityServiceClass == null ? 0 : this.identityServiceClass.hashCode());
        result2 = 31 * result2 + (this.isAggregator == null ? 0 : this.isAggregator.hashCode());
        result2 = 31 * result2 + (this.isAuthenticator == null ? 0 : this.isAuthenticator.hashCode());
        result2 = 31 * result2 + (this.isBroadcaster == null ? 0 : this.isBroadcaster.hashCode());
        result2 = 31 * result2 + (this.isQueryable == null ? 0 : this.isQueryable.hashCode());
        result2 = 31 * result2 + (this.nodeName == null ? 0 : this.nodeName.hashCode());
        result2 = 31 * result2 + (this.queries == null ? 0 : this.queries.hashCode());
        result2 = 31 * result2 + (this.version == null ? 0 : this.version.hashCode());
        result2 = 31 * result2 + (this.queryActionMapClassName == null ? 0 : this.queryActionMapClassName.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeConfig other = (NodeConfig)obj;
        if (this.broadcastTimeoutPeriod == null ? other.broadcastTimeoutPeriod != null : !this.broadcastTimeoutPeriod.equals(other.broadcastTimeoutPeriod)) {
            return false;
        }
        if (this.cacheTTL == null ? other.cacheTTL != null : !this.cacheTTL.equals(other.cacheTTL)) {
            return false;
        }
        if (this.certificationTTL == null ? other.certificationTTL != null : !this.certificationTTL.equals(other.certificationTTL)) {
            return false;
        }
        if (this.identityServiceClass == null ? other.identityServiceClass != null : !this.identityServiceClass.equals(other.identityServiceClass)) {
            return false;
        }
        if (this.isAggregator == null ? other.isAggregator != null : !this.isAggregator.equals(other.isAggregator)) {
            return false;
        }
        if (this.isAuthenticator == null ? other.isAuthenticator != null : !this.isAuthenticator.equals(other.isAuthenticator)) {
            return false;
        }
        if (this.isBroadcaster == null ? other.isBroadcaster != null : !this.isBroadcaster.equals(other.isBroadcaster)) {
            return false;
        }
        if (this.isQueryable == null ? other.isQueryable != null : !this.isQueryable.equals(other.isQueryable)) {
            return false;
        }
        if (this.nodeName == null ? other.nodeName != null : !this.nodeName.equals(other.nodeName)) {
            return false;
        }
        if (this.queries == null ? other.queries != null : !this.queries.equals(other.queries)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        return !(this.queryActionMapClassName == null ? other.queryActionMapClassName != null : !this.queryActionMapClassName.equals(other.queryActionMapClassName));
    }

    public String toString() {
        return "NodeConfig [version=" + this.version + ", nodeName=" + this.nodeName + ", isAuthenticator=" + this.isAuthenticator + ", isBroadcaster=" + this.isBroadcaster + ", isAggregator=" + this.isAggregator + ", isQueryable=" + this.isQueryable + ", identityServiceClass=" + this.identityServiceClass + ", queries=" + this.queries + ", certificationTTL=" + this.certificationTTL + ", cacheTTL=" + this.cacheTTL + ", broadcastTimeoutPeriod=" + this.broadcastTimeoutPeriod + ", queryActionMapClassName=" + this.queryActionMapClassName + "]";
    }
}

