/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spin.tools.Util;
import org.spin.tools.config.EndpointConfig;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PeerGroupConfig", namespace="http://spin.org/xml/res")
@XmlRootElement(name="PeerGroupConfig", namespace="http://spin.org/xml/res")
public final class PeerGroupConfig {
    @XmlElement(name="groupName", required=true)
    private final String groupName;
    @XmlElement(name="parent", required=false)
    private final EndpointConfig parent;
    @XmlElement(name="child", required=false)
    private final List<EndpointConfig> children = Util.makeArrayList();

    public PeerGroupConfig() {
        this(null, null, null);
    }

    public PeerGroupConfig(String name) {
        this(name, null, null);
    }

    protected PeerGroupConfig(String name, EndpointConfig parent2) {
        this(name, parent2, null);
    }

    public PeerGroupConfig(String name, EndpointConfig parent2, Collection<EndpointConfig> children2) {
        this.groupName = name;
        this.parent = parent2;
        if (children2 != null) {
            this.children.addAll(children2);
        }
    }

    public static final PeerGroupConfig copyOf(PeerGroupConfig other) {
        if (other == null) {
            return null;
        }
        return new PeerGroupConfig(other.groupName, other.parent, other.children);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public List<EndpointConfig> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public PeerGroupConfig withChildren(Collection<EndpointConfig> newChildren) {
        return new PeerGroupConfig(this.groupName, this.parent, newChildren);
    }

    public PeerGroupConfig withGroupName(String newGroupName) {
        return new PeerGroupConfig(newGroupName, this.parent, this.children);
    }

    public PeerGroupConfig withChild(EndpointConfig child) {
        PeerGroupConfig result2 = PeerGroupConfig.copyOf(this);
        result2.children.add(child);
        return result2;
    }

    public PeerGroupConfig withoutChildAt(int index2) {
        PeerGroupConfig result2 = PeerGroupConfig.copyOf(this);
        result2.children.remove(index2);
        return result2;
    }

    public PeerGroupConfig withoutChild(EndpointConfig child) {
        PeerGroupConfig result2 = PeerGroupConfig.copyOf(this);
        result2.children.remove(child);
        return result2;
    }

    public EndpointConfig getParent() {
        return this.parent;
    }

    public PeerGroupConfig withParent(EndpointConfig newParent) {
        return new PeerGroupConfig(this.groupName, newParent, this.children);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.children == null ? 0 : this.children.hashCode());
        result2 = 31 * result2 + (this.groupName == null ? 0 : this.groupName.hashCode());
        result2 = 31 * result2 + (this.parent == null ? 0 : this.parent.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PeerGroupConfig other = (PeerGroupConfig)obj;
        if (this.children == null ? other.children != null : !this.children.equals(other.children)) {
            return false;
        }
        if (this.groupName == null ? other.groupName != null : !this.groupName.equals(other.groupName)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }

    public String toString() {
        return "PeerGroupConfig [groupName=" + this.groupName + ", parent=" + this.parent + ", children=" + this.children + "]";
    }
}

