/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.spin.tools.Util;
import org.spin.tools.config.DefaultPeerGroups;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.config.PeerGroupConfig;
import org.spin.tools.config.RoutingTableConfig;

public final class RoutingTable {
    final Map<String, PeerGroupConfig> peerGroups = Util.makeHashMap();
    public static final RoutingTable Empty = new RoutingTable(new PeerGroupConfig[0]);

    public RoutingTable(RoutingTableConfig config) {
        this(config.getPeerGroups());
    }

    public RoutingTable(PeerGroupConfig ... peerGroupConfigs) {
        this(Arrays.asList(peerGroupConfigs));
    }

    public RoutingTable(Collection<PeerGroupConfig> peerGroupConfigs) {
        this.addPeerGroups(peerGroupConfigs);
        this.ensureLocalPeerGroupIsPresent();
    }

    private void addPeerGroups(Collection<PeerGroupConfig> peerGroupConfigs) {
        Util.guardNotNull(peerGroupConfigs);
        for (PeerGroupConfig peerGroupConfig : peerGroupConfigs) {
            this.peerGroups.put(peerGroupConfig.getGroupName(), peerGroupConfig);
        }
    }

    public static RoutingTable copyOf(RoutingTable other) {
        if (other == null) {
            return null;
        }
        return new RoutingTable(other.toRoutingTableConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureLocalPeerGroupIsPresent() {
        Map<String, PeerGroupConfig> map3 = this.peerGroups;
        synchronized (map3) {
            if (!this.peerGroups.containsKey(DefaultPeerGroups.LOCAL.name())) {
                this.peerGroups.put(DefaultPeerGroups.LOCAL.name(), new PeerGroupConfig(DefaultPeerGroups.LOCAL.name()));
            }
        }
    }

    public boolean contains(String peerGroupName) {
        return this.peerGroups.containsKey(peerGroupName);
    }

    public Set<String> getPeerGroupNames() {
        return Collections.unmodifiableSet(Util.asSet(this.peerGroups.keySet()));
    }

    public PeerGroupConfig get(String peerGroupName) {
        return this.peerGroups.get(peerGroupName);
    }

    public RoutingTable with(PeerGroupConfig peerGroup) {
        RoutingTable result2 = RoutingTable.copyOf(this);
        result2.peerGroups.put(peerGroup.getGroupName(), peerGroup);
        return result2;
    }

    public RoutingTable without(String peerGroupName) {
        RoutingTable result2 = RoutingTable.copyOf(this);
        result2.peerGroups.remove(peerGroupName);
        return result2;
    }

    public RoutingTable empty() {
        return Empty;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String crlf = System.getProperty("line.separator");
        for (String name : this.peerGroups.keySet()) {
            sb.append("PeerGroup Name: ").append(name);
            sb.append(crlf);
            for (EndpointConfig child : this.peerGroups.get(name).getChildren()) {
                sb.append("Child: ").append(child);
                sb.append(crlf);
            }
            sb.append(crlf);
            sb.append(crlf);
        }
        return sb.toString();
    }

    static boolean isLocal(PeerGroupConfig peerGroupConfig) {
        return DefaultPeerGroups.LOCAL.name().equals(peerGroupConfig.getGroupName());
    }

    public RoutingTableConfig toRoutingTableConfig() {
        ArrayList<PeerGroupConfig> copiedPeerGroups = Util.makeArrayList(this.peerGroups.size());
        for (PeerGroupConfig peerGroupConfig : this.peerGroups.values()) {
            if (RoutingTable.isLocal(peerGroupConfig)) continue;
            copiedPeerGroups.add(PeerGroupConfig.copyOf(peerGroupConfig));
        }
        return new RoutingTableConfig(copiedPeerGroups);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.peerGroups == null ? 0 : this.toRoutingTableConfig().hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoutingTable other = (RoutingTable)obj;
        return !(this.peerGroups == null ? other.peerGroups != null : !Util.mapsAreEqual(this.peerGroups, other.peerGroups));
    }
}

