/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config.migration;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.spin.tools.JAXBUtils;
import org.spin.tools.Util;
import org.spin.tools.config.KeyStoreConfig;
import org.spin.tools.config.Module;
import org.spin.tools.config.NodeConfig;
import org.spin.tools.config.RoutingTableConfig;

public final class Validate {
    private static final Map<String, Class<?>> knownConfigFilenameToClass = Validate.initKnownConfiMag();
    private static final StringBuilder sbOKResults = new StringBuilder();
    private static final StringBuilder sbFailResults = new StringBuilder();
    private static boolean success = false;

    private Validate() {
    }

    private static final Map<String, Class<?>> initKnownConfiMag() {
        HashMap<String, Class<?>> results2 = Util.makeHashMap();
        results2.put(Module.keystore.name() + ".xml", KeyStoreConfig.class);
        results2.put(Module.node.name() + ".xml", NodeConfig.class);
        results2.put(Module.routingtable.name() + ".xml", RoutingTableConfig.class);
        return results2;
    }

    private static final void usage() {
        System.out.println("Usage: Validate <directory with config files>");
        System.out.println("Example:");
        System.out.println("  Usage /home/someUser/configFiles");
        System.out.println("Assumes:");
        System.out.println("  The following file names, if they appear in the given directory,\n  are reserved for spin base config files:");
        for (String fileName : knownConfigFilenameToClass.keySet()) {
            System.out.println("  --> " + fileName);
        }
    }

    public static void main(String[] args2) {
        if (args2.length != 1) {
            Validate.usage();
            System.exit(0);
        }
        success = Validate.validateFiles(new File(args2[0]));
        System.out.println("=======");
        System.out.println(sbOKResults.toString());
        System.out.println(sbFailResults.toString());
        System.out.println("Done!");
    }

    protected static final boolean validateFiles(File directory) {
        File[] fileArray;
        if (directory.isDirectory()) {
            fileArray = directory.listFiles();
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = directory;
        }
        File[] listOfFiles = fileArray;
        if (directory.isDirectory()) {
            System.out.println("Searching directory <" + directory.getAbsolutePath() + ">");
        }
        for (File f2 : listOfFiles) {
            if (f2.isDirectory()) {
                Validate.validateFiles(f2);
                continue;
            }
            String fileName = f2.getName();
            if (!knownConfigFilenameToClass.keySet().contains(fileName)) continue;
            try {
                System.out.println("Validating <" + f2.getName() + ">");
                JAXBUtils.unmarshalAndValidate(f2, knownConfigFilenameToClass.get(fileName));
                sbOKResults.append("OK: <" + f2.getAbsolutePath() + ">\n");
            }
            catch (JAXBException e2) {
                sbFailResults.append("FAIL: <" + f2.getAbsolutePath() + ">\n");
                sbFailResults.append("-> " + e2.getLinkedException().getMessage() + "\n");
                return false;
            }
        }
        return true;
    }

    protected static final boolean isSuccess() {
        return success;
    }
}

