/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.crypto;

import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.codec.binary.Base64;
import org.spin.tools.Util;
import org.spin.tools.crypto.signature.CertID;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="EncryptedData")
@XmlRootElement
public final class Envelope {
    @XmlElement(required=true)
    private final byte[] encryptedKey;
    @XmlElement(required=true)
    private final String data;
    @XmlElement(required=false)
    private final CertID encryptedFor;
    @XmlElement(required=false)
    private final byte[] signature;
    @XmlElement(required=false)
    private CertID signedBy;

    static String encode(byte[] bytes2) {
        if (bytes2 == null) {
            return null;
        }
        return Base64.encodeBase64URLSafeString(bytes2);
    }

    static byte[] decode(String base64Data) {
        if (base64Data == null) {
            return null;
        }
        return Base64.decodeBase64(base64Data);
    }

    public static final Envelope unencrypted(String data2) {
        return Envelope.unencrypted(data2, null, null);
    }

    public static final Envelope unencrypted(String data2, byte[] signature2, CertID signedBy) {
        Util.guardNotNull(data2);
        return new Envelope(null, data2, null, signature2, signedBy);
    }

    public static final Envelope encrypted(byte[] encryptedKey, byte[] data2, CertID encryptedFor) {
        return Envelope.encrypted(encryptedKey, data2, encryptedFor, null, null);
    }

    public static final Envelope encrypted(byte[] encryptedKey, byte[] data2, CertID encryptedFor, byte[] signature2, CertID signedBy) {
        Util.guardNotNull(encryptedKey);
        Util.guardNotNull(data2);
        Util.guardNotNull(encryptedFor);
        return new Envelope(encryptedKey, Envelope.encode(data2), encryptedFor, signature2, signedBy);
    }

    public static final Envelope signed(Envelope unsigned, byte[] signature2, CertID signedBy) {
        Util.guardNotNull(unsigned);
        Util.guardNotNull(signature2);
        return new Envelope(unsigned.getEncryptedKey(), unsigned.getData(), unsigned.getEncryptedFor(), signature2, signedBy);
    }

    private Envelope() {
        this(null, null, null, null, null);
    }

    private Envelope(byte[] encryptedKey, String data2, CertID encryptedFor, byte[] signature2, CertID signedBy) {
        this.encryptedKey = encryptedKey != null ? Arrays.copyOf(encryptedKey, encryptedKey.length) : null;
        this.data = data2;
        this.encryptedFor = encryptedFor;
        this.signature = signature2 != null ? Arrays.copyOf(signature2, signature2.length) : null;
        this.signedBy = signedBy;
    }

    public final byte[] getEncryptedKey() {
        return this.encryptedKey;
    }

    public final String getData() {
        return this.data;
    }

    public final byte[] getDataBytes() {
        if (this.isEncrypted()) {
            return Envelope.decode(this.data);
        }
        return this.data.getBytes();
    }

    public final boolean isEncrypted() {
        return this.encryptedFor != null && this.encryptedKey != null;
    }

    public final boolean isSigned() {
        return this.signature != null && this.signedBy != null;
    }

    public final CertID getEncryptedFor() {
        return this.encryptedFor;
    }

    public final byte[] getSignature() {
        return this.signature;
    }

    public CertID getSignedBy() {
        return this.signedBy;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.data == null ? 0 : this.data.hashCode());
        result2 = 31 * result2 + (this.encryptedFor == null ? 0 : this.encryptedFor.hashCode());
        result2 = 31 * result2 + Arrays.hashCode(this.encryptedKey);
        result2 = 31 * result2 + Arrays.hashCode(this.signature);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Envelope other = (Envelope)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        if (this.encryptedFor == null ? other.encryptedFor != null : !this.encryptedFor.equals(other.encryptedFor)) {
            return false;
        }
        if (!Arrays.equals(this.encryptedKey, other.encryptedKey)) {
            return false;
        }
        return Arrays.equals(this.signature, other.signature);
    }
}

