/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.crypto;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.spin.tools.Base64Codec;
import org.spin.tools.crypto.CryptoException;

public final class Hashes {
    public static final Algorithm defaultAlgorithm = Algorithm.SHA1;

    private Hashes() {
    }

    public static String sha1(File file) {
        return Hashes.hash(file, Algorithm.SHA1);
    }

    public static String sha256(File file) {
        return Hashes.hash(file, Algorithm.SHA256);
    }

    public static String hash(File file) {
        return Hashes.hash(file, defaultAlgorithm);
    }

    public static String hash(File file, Algorithm algorithm) {
        try {
            return Base64Codec.toString(algorithm.hash(new FileReader(file)));
        }
        catch (IOException e2) {
            throw new CryptoException("Error reading file to be ahshed: ", e2);
        }
    }

    public static String sha1(String text2) {
        return Hashes.hash(text2, Algorithm.SHA1);
    }

    public static String sha256(String text2) {
        return Hashes.hash(text2, Algorithm.SHA256);
    }

    public static String hash(String text2) {
        return Hashes.hash(text2, defaultAlgorithm);
    }

    public static String hash(String text2, Algorithm algorithm) {
        if (text2 == null) {
            return null;
        }
        return Base64Codec.toString(algorithm.hash(text2.getBytes()));
    }

    public static byte[] sha1(byte[] bytes2) {
        return Algorithm.SHA1.hash(bytes2);
    }

    public static byte[] sha256(byte[] bytes2) {
        return Algorithm.SHA256.hash(bytes2);
    }

    public static byte[] hash(byte[] bytes2) {
        return defaultAlgorithm.hash(bytes2);
    }

    public static byte[] sha1(Reader reader2) {
        return Algorithm.SHA1.hash(reader2);
    }

    public static byte[] sha256(Reader reader2) {
        return Algorithm.SHA256.hash(reader2);
    }

    public static byte[] hash(Reader reader2) {
        return defaultAlgorithm.hash(reader2);
    }

    public static byte[] hash(Reader reader2, Algorithm algorithm) {
        return algorithm.hash(reader2);
    }

    public static enum Algorithm {
        SHA1("SHA1"),
        SHA256("SHA-256");

        private final String algorithmName;

        private Algorithm(String algorithmName) {
            this.algorithmName = algorithmName;
        }

        public String getAlgorithmName() {
            return this.algorithmName;
        }

        private MessageDigest getMessageDigest() {
            try {
                return MessageDigest.getInstance(this.getAlgorithmName());
            }
            catch (NoSuchAlgorithmException e2) {
                throw new CryptoException(e2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] hash(byte[] bytes2) {
            MessageDigest hashFunction = this.getMessageDigest();
            try {
                byte[] byArray = hashFunction.digest(bytes2);
                return byArray;
            }
            finally {
                hashFunction.reset();
            }
        }

        public byte[] hash(Reader reader2) {
            MessageDigest hashFunction = this.getMessageDigest();
            BufferedReader bufferedReader = new BufferedReader(reader2);
            try {
                Object line = bufferedReader.readLine();
                while (line != null) {
                    hashFunction.update(((String)line).getBytes());
                    line = bufferedReader.readLine();
                }
                line = hashFunction.digest();
                return line;
            }
            catch (IOException e2) {
                throw new CryptoException(e2);
            }
            finally {
                hashFunction.reset();
                try {
                    bufferedReader.close();
                }
                catch (IOException eatenOnPurpose) {}
            }
        }
    }

    public static final class AlgorithmNames {
        public static final String SHA1 = "SHA1";
        public static final String SHA256 = "SHA-256";

        private AlgorithmNames() {
        }
    }
}

