/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.crypto;

import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.spin.tools.crypto.CryptoException;

public final class SymmetricCryptoTool {
    public static final Algorithm defaultAlgorithm = Algorithm.AES128;

    private SymmetricCryptoTool() {
    }

    public static byte[] encrypt(byte[] plainText, SecretKey key) {
        return defaultAlgorithm.encrypt(plainText, key);
    }

    public static byte[] aes128Encrypt(byte[] plainText, SecretKey key) {
        return Algorithm.AES128.encrypt(plainText, key);
    }

    public static byte[] decrypt(byte[] plainText, SecretKey key) {
        return defaultAlgorithm.decrypt(plainText, key);
    }

    public static byte[] aes128Decrypt(byte[] cipherText, SecretKey key) {
        return Algorithm.AES128.decrypt(cipherText, key);
    }

    public static SecretKey generateSecretKey() {
        return defaultAlgorithm.generateSecretKey();
    }

    public static SecretKey generateAES128SecretKey() {
        return Algorithm.AES128.generateSecretKey();
    }

    public static SecretKey getSecretKey(byte[] keyData) {
        return Algorithm.AES128.getSecretKey(keyData);
    }

    public static enum Algorithm {
        AES128("AES", 128);

        private final String algorithmName;
        private final int numberOfBits;

        private Algorithm(String algorithmName, int numberOfBits) {
            this.algorithmName = algorithmName;
            this.numberOfBits = numberOfBits;
        }

        public String getAlgorithmName() {
            return this.algorithmName;
        }

        public int getNumberOfBits() {
            return this.numberOfBits;
        }

        private Cipher getSymmetricCipher() {
            try {
                return Cipher.getInstance(this.getAlgorithmName());
            }
            catch (Exception e2) {
                throw new CryptoException(e2);
            }
        }

        private KeyGenerator getKeyGenerator() {
            try {
                return KeyGenerator.getInstance(this.getAlgorithmName());
            }
            catch (NoSuchAlgorithmException e2) {
                throw new CryptoException(e2);
            }
        }

        public SecretKey generateSecretKey() {
            try {
                KeyGenerator keyGenerator = this.getKeyGenerator();
                keyGenerator.init(this.getNumberOfBits());
                return keyGenerator.generateKey();
            }
            catch (Exception e2) {
                throw new CryptoException(e2);
            }
        }

        public SecretKey getSecretKey(byte[] keyData) {
            return new SecretKeySpec(keyData, this.getAlgorithmName());
        }

        public byte[] encrypt(byte[] plainText, SecretKey key) {
            Cipher cipher = this.getSymmetricCipher();
            try {
                cipher.init(1, key);
                return cipher.doFinal(plainText);
            }
            catch (Exception e2) {
                throw new CryptoException(e2);
            }
        }

        public byte[] decrypt(byte[] cipherText, SecretKey key) {
            Cipher cipher = this.getSymmetricCipher();
            try {
                cipher.init(2, key);
                return cipher.doFinal(cipherText);
            }
            catch (Exception e2) {
                throw new CryptoException(e2);
            }
        }
    }
}

