/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.crypto.signature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.datatype.XMLGregorianCalendar;
import org.spin.tools.NetworkTime;
import org.spin.tools.Util;
import org.spin.tools.crypto.signature.CertData;
import org.spin.tools.crypto.signature.CertID;
import org.spin.tools.crypto.signature.KeyInfo;
import org.spin.tools.crypto.signature.Signable;
import org.spin.tools.crypto.signature.Signature;

@XmlRootElement(name="Identity")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Identity")
public final class Identity
implements Signable {
    @XmlElement(name="Domain", required=true)
    private final String domain;
    @XmlElement(name="Username", required=true)
    private final String username;
    @XmlElement(name="Assertion", required=true)
    private final List<String> assertions;
    @XmlElement(name="Timestamp")
    private final XMLGregorianCalendar timestamp;
    @XmlElement(name="Signature")
    private Signature signature;
    @XmlAttribute(name="Id")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name="ID")
    private String id;

    public Identity() {
        this(null, null);
    }

    public Identity(String domain, String username) {
        this(domain, username, Collections.emptyList());
    }

    public Identity(String domain, String username, String assertion) {
        this(domain, username, Arrays.asList(assertion));
    }

    public Identity(String domain, String username, List<String> assertions) {
        this(domain, username, assertions, Identity.now(), null);
    }

    private static XMLGregorianCalendar now() {
        return new NetworkTime().getXMLGregorianCalendar();
    }

    public Identity(String domain, String username, List<String> assertions, XMLGregorianCalendar timestamp2, Signature signature2) {
        this(domain, username, assertions, timestamp2, signature2, null);
    }

    private Identity(String domain, String username, List<String> assertions, XMLGregorianCalendar timestamp2, Signature signature2, String id2) {
        this.domain = domain;
        this.username = username;
        this.assertions = Util.makeArrayList(assertions);
        this.timestamp = timestamp2 == null ? Identity.now() : timestamp2;
        this.signature = signature2;
        this.id = id2;
    }

    public static final Identity copyOf(Identity other) {
        if (other == null) {
            return null;
        }
        return new Identity(other.domain, other.username, new ArrayList<String>(other.assertions), NetworkTime.copyOf(other.timestamp), other.signature);
    }

    public CertID getCertID() {
        if (this.signature == null) {
            return null;
        }
        KeyInfo keyInfo = this.signature.getKeyInfo();
        if (keyInfo == null) {
            return null;
        }
        CertData certData = keyInfo.getCertData();
        if (certData == null) {
            return null;
        }
        return certData.getCertID();
    }

    public String getDomain() {
        return this.domain;
    }

    public String getUsername() {
        return this.username;
    }

    public List<String> getAssertion() {
        return this.assertions;
    }

    public void addAssertion(String assertion) {
        this.getAssertion().add(assertion);
    }

    public void setAssertion(String assertion) {
        this.getAssertion().clear();
        this.addAssertion(assertion);
    }

    public XMLGregorianCalendar getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    public Identity withSignature(Signature newSignature) {
        return new Identity(this.domain, this.username, this.assertions, this.timestamp, newSignature, this.id);
    }

    public Identity withTimestamp(XMLGregorianCalendar newTimestamp) {
        return new Identity(this.domain, this.username, this.assertions, newTimestamp, this.signature, this.id);
    }

    public Identity withNormalizedTimestamp() {
        return this.withTimestamp(this.timestamp.normalize());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value2) {
        this.id = value2;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.assertions == null ? 0 : this.assertions.hashCode());
        result2 = 31 * result2 + (this.domain == null ? 0 : this.domain.hashCode());
        result2 = 31 * result2 + (this.id == null ? 0 : this.id.hashCode());
        result2 = 31 * result2 + (this.signature == null ? 0 : this.signature.hashCode());
        result2 = 31 * result2 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result2 = 31 * result2 + (this.username == null ? 0 : this.username.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Identity other = (Identity)obj;
        if (this.assertions == null ? other.assertions != null : !this.assertions.equals(other.assertions)) {
            return false;
        }
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.signature == null ? other.signature != null : !this.signature.equals(other.signature)) {
            return false;
        }
        if (this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }
}

