/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.filter;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.spin.tools.Util;

public final class FileFilters {
    private FileFilters() {
    }

    public static final FileFilter withExtension(String extension2) {
        Util.guardNotNull(extension2);
        return FileFilters.withExtensions(Arrays.asList(extension2));
    }

    public static final FileFilter withExtensions(String ... extensions) {
        return FileFilters.withExtensions(Arrays.asList(extensions));
    }

    public static final FileFilter withExtensions(Collection<String> extensions) {
        Util.guardNotNull(extensions);
        final ArrayList dottedExtensions = Util.makeArrayList(extensions.size());
        for (String extension2 : extensions) {
            if (extension2 == null) continue;
            dottedExtensions.add(extension2.startsWith(".") ? extension2 : '.' + extension2);
        }
        return new FileFilter(){

            @Override
            public final boolean accept(File pathname) {
                Util.guardNotNull(pathname);
                return FileFilters.endsWithOneOf(pathname.toString(), dottedExtensions);
            }
        };
    }

    static final boolean endsWithOneOf(String string2, Collection<String> suffixes) {
        Util.guardNotNull(string2);
        Util.guardNotNull(suffixes);
        for (String suffix : suffixes) {
            if (!string2.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }
}

