/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.AfterAdvice;
import org.springframework.aop.aspectj.AbstractAspectJAdvice;
import org.springframework.aop.aspectj.AspectInstanceFactory;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;

public class AspectJAfterThrowingAdvice
extends AbstractAspectJAdvice
implements MethodInterceptor,
AfterAdvice {
    public AspectJAfterThrowingAdvice(Method aspectJBeforeAdviceMethod, AspectJExpressionPointcut pointcut, AspectInstanceFactory aif) {
        super(aspectJBeforeAdviceMethod, pointcut, aif);
    }

    public boolean isBeforeAdvice() {
        return false;
    }

    public boolean isAfterAdvice() {
        return true;
    }

    public void setThrowingName(String name) {
        this.setThrowingNameNoCheck(name);
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        try {
            return mi.proceed();
        }
        catch (Throwable t2) {
            if (this.shouldInvokeOnThrowing(t2)) {
                this.invokeAdviceMethod(this.getJoinPointMatch(), null, t2);
            }
            throw t2;
        }
    }

    private boolean shouldInvokeOnThrowing(Throwable t2) {
        Class throwingType = this.getDiscoveredThrowingType();
        return throwingType.isAssignableFrom(t2.getClass());
    }
}

