/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.DynamicIntroductionAdvice;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.IntroductionInfo;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisorChainFactory;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.DefaultAdvisorChainFactory;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.support.DefaultIntroductionAdvisor;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.target.EmptyTargetSource;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvisedSupport
extends ProxyConfig
implements Advised {
    private static final long serialVersionUID = 2651364800145442165L;
    public static final TargetSource EMPTY_TARGET_SOURCE = EmptyTargetSource.INSTANCE;
    TargetSource targetSource = EMPTY_TARGET_SOURCE;
    private boolean preFiltered = false;
    AdvisorChainFactory advisorChainFactory = new DefaultAdvisorChainFactory();
    private transient Map<MethodCacheKey, List<Object>> methodCache;
    private List<Class> interfaces = new ArrayList<Class>();
    private List<Advisor> advisors = new LinkedList<Advisor>();
    private Advisor[] advisorArray = new Advisor[0];

    public AdvisedSupport() {
        this.initMethodCache();
    }

    public AdvisedSupport(Class[] interfaces2) {
        this();
        this.setInterfaces(interfaces2);
    }

    private void initMethodCache() {
        this.methodCache = new ConcurrentHashMap<MethodCacheKey, List<Object>>(32);
    }

    public void setTarget(Object target2) {
        this.setTargetSource(new SingletonTargetSource(target2));
    }

    @Override
    public void setTargetSource(TargetSource targetSource) {
        this.targetSource = targetSource != null ? targetSource : EMPTY_TARGET_SOURCE;
    }

    @Override
    public TargetSource getTargetSource() {
        return this.targetSource;
    }

    public void setTargetClass(Class targetClass) {
        this.targetSource = EmptyTargetSource.forClass(targetClass);
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetSource.getTargetClass();
    }

    @Override
    public void setPreFiltered(boolean preFiltered) {
        this.preFiltered = preFiltered;
    }

    @Override
    public boolean isPreFiltered() {
        return this.preFiltered;
    }

    public void setAdvisorChainFactory(AdvisorChainFactory advisorChainFactory) {
        Assert.notNull(advisorChainFactory, "AdvisorChainFactory must not be null");
        this.advisorChainFactory = advisorChainFactory;
    }

    public AdvisorChainFactory getAdvisorChainFactory() {
        return this.advisorChainFactory;
    }

    public void setInterfaces(Class[] interfaces2) {
        Assert.notNull(interfaces2, "Interfaces must not be null");
        this.interfaces.clear();
        Class[] classArray = interfaces2;
        int n = interfaces2.length;
        int n2 = 0;
        while (n2 < n) {
            Class ifc = classArray[n2];
            this.addInterface(ifc);
            ++n2;
        }
    }

    public void addInterface(Class intf) {
        Assert.notNull(intf, "Interface must not be null");
        if (!intf.isInterface()) {
            throw new IllegalArgumentException("[" + intf.getName() + "] is not an interface");
        }
        if (!this.interfaces.contains(intf)) {
            this.interfaces.add(intf);
            this.adviceChanged();
        }
    }

    public boolean removeInterface(Class intf) {
        return this.interfaces.remove(intf);
    }

    @Override
    public Class[] getProxiedInterfaces() {
        return this.interfaces.toArray(new Class[this.interfaces.size()]);
    }

    @Override
    public boolean isInterfaceProxied(Class intf) {
        for (Class proxyIntf : this.interfaces) {
            if (!intf.isAssignableFrom(proxyIntf)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Advisor[] getAdvisors() {
        return this.advisorArray;
    }

    @Override
    public void addAdvisor(Advisor advisor) {
        int pos = this.advisors.size();
        this.addAdvisor(pos, advisor);
    }

    @Override
    public void addAdvisor(int pos, Advisor advisor) throws AopConfigException {
        if (advisor instanceof IntroductionAdvisor) {
            this.validateIntroductionAdvisor((IntroductionAdvisor)advisor);
        }
        this.addAdvisorInternal(pos, advisor);
    }

    @Override
    public boolean removeAdvisor(Advisor advisor) {
        int index2 = this.indexOf(advisor);
        if (index2 == -1) {
            return false;
        }
        this.removeAdvisor(index2);
        return true;
    }

    @Override
    public void removeAdvisor(int index2) throws AopConfigException {
        if (this.isFrozen()) {
            throw new AopConfigException("Cannot remove Advisor: Configuration is frozen.");
        }
        if (index2 < 0 || index2 > this.advisors.size() - 1) {
            throw new AopConfigException("Advisor index " + index2 + " is out of bounds: " + "This configuration only has " + this.advisors.size() + " advisors.");
        }
        Advisor advisor = this.advisors.get(index2);
        if (advisor instanceof IntroductionAdvisor) {
            IntroductionAdvisor ia = (IntroductionAdvisor)advisor;
            int j = 0;
            while (j < ia.getInterfaces().length) {
                this.removeInterface(ia.getInterfaces()[j]);
                ++j;
            }
        }
        this.advisors.remove(index2);
        this.updateAdvisorArray();
        this.adviceChanged();
    }

    @Override
    public int indexOf(Advisor advisor) {
        Assert.notNull(advisor, "Advisor must not be null");
        return this.advisors.indexOf(advisor);
    }

    @Override
    public boolean replaceAdvisor(Advisor a2, Advisor b) throws AopConfigException {
        Assert.notNull(a2, "Advisor a must not be null");
        Assert.notNull(b, "Advisor b must not be null");
        int index2 = this.indexOf(a2);
        if (index2 == -1) {
            return false;
        }
        this.removeAdvisor(index2);
        this.addAdvisor(index2, b);
        return true;
    }

    @Deprecated
    public void addAllAdvisors(Advisor[] advisors) {
        this.addAdvisors((Collection<Advisor>)Arrays.asList(advisors));
    }

    public void addAdvisors(Advisor ... advisors) {
        this.addAdvisors((Collection<Advisor>)Arrays.asList(advisors));
    }

    public void addAdvisors(Collection<Advisor> advisors) {
        if (this.isFrozen()) {
            throw new AopConfigException("Cannot add advisor: Configuration is frozen.");
        }
        if (!CollectionUtils.isEmpty(advisors)) {
            for (Advisor advisor : advisors) {
                if (advisor instanceof IntroductionAdvisor) {
                    this.validateIntroductionAdvisor((IntroductionAdvisor)advisor);
                }
                Assert.notNull(advisor, "Advisor must not be null");
                this.advisors.add(advisor);
            }
            this.updateAdvisorArray();
            this.adviceChanged();
        }
    }

    private void validateIntroductionAdvisor(IntroductionAdvisor advisor) {
        Class[] ifcs;
        advisor.validateInterfaces();
        Class[] classArray = ifcs = advisor.getInterfaces();
        int n = ifcs.length;
        int n2 = 0;
        while (n2 < n) {
            Class ifc = classArray[n2];
            this.addInterface(ifc);
            ++n2;
        }
    }

    private void addAdvisorInternal(int pos, Advisor advisor) throws AopConfigException {
        Assert.notNull(advisor, "Advisor must not be null");
        if (this.isFrozen()) {
            throw new AopConfigException("Cannot add advisor: Configuration is frozen.");
        }
        if (pos > this.advisors.size()) {
            throw new IllegalArgumentException("Illegal position " + pos + " in advisor list with size " + this.advisors.size());
        }
        this.advisors.add(pos, advisor);
        this.updateAdvisorArray();
        this.adviceChanged();
    }

    protected final void updateAdvisorArray() {
        this.advisorArray = this.advisors.toArray(new Advisor[this.advisors.size()]);
    }

    protected final List<Advisor> getAdvisorsInternal() {
        return this.advisors;
    }

    @Override
    public void addAdvice(Advice advice) throws AopConfigException {
        int pos = this.advisors.size();
        this.addAdvice(pos, advice);
    }

    @Override
    public void addAdvice(int pos, Advice advice) throws AopConfigException {
        Assert.notNull(advice, "Advice must not be null");
        if (advice instanceof IntroductionInfo) {
            this.addAdvisor(pos, new DefaultIntroductionAdvisor(advice, (IntroductionInfo)((Object)advice)));
        } else {
            if (advice instanceof DynamicIntroductionAdvice) {
                throw new AopConfigException("DynamicIntroductionAdvice may only be added as part of IntroductionAdvisor");
            }
            this.addAdvisor(pos, new DefaultPointcutAdvisor(advice));
        }
    }

    @Override
    public boolean removeAdvice(Advice advice) throws AopConfigException {
        int index2 = this.indexOf(advice);
        if (index2 == -1) {
            return false;
        }
        this.removeAdvisor(index2);
        return true;
    }

    @Override
    public int indexOf(Advice advice) {
        Assert.notNull(advice, "Advice must not be null");
        int i = 0;
        while (i < this.advisors.size()) {
            Advisor advisor = this.advisors.get(i);
            if (advisor.getAdvice() == advice) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean adviceIncluded(Advice advice) {
        if (advice != null) {
            for (Advisor advisor : this.advisors) {
                if (advisor.getAdvice() != advice) continue;
                return true;
            }
        }
        return false;
    }

    public int countAdvicesOfType(Class adviceClass) {
        int count2 = 0;
        if (adviceClass != null) {
            for (Advisor advisor : this.advisors) {
                if (!adviceClass.isInstance(advisor.getAdvice())) continue;
                ++count2;
            }
        }
        return count2;
    }

    public List<Object> getInterceptorsAndDynamicInterceptionAdvice(Method method, Class targetClass) {
        MethodCacheKey cacheKey = new MethodCacheKey(method);
        List<Object> cached = this.methodCache.get(cacheKey);
        if (cached == null) {
            cached = this.advisorChainFactory.getInterceptorsAndDynamicInterceptionAdvice(this, method, targetClass);
            this.methodCache.put(cacheKey, cached);
        }
        return cached;
    }

    protected void adviceChanged() {
        this.methodCache.clear();
    }

    protected void copyConfigurationFrom(AdvisedSupport other) {
        this.copyConfigurationFrom(other, other.targetSource, new ArrayList<Advisor>(other.advisors));
    }

    protected void copyConfigurationFrom(AdvisedSupport other, TargetSource targetSource, List<Advisor> advisors) {
        this.copyFrom(other);
        this.targetSource = targetSource;
        this.advisorChainFactory = other.advisorChainFactory;
        this.interfaces = new ArrayList<Class>(other.interfaces);
        for (Advisor advisor : advisors) {
            if (advisor instanceof IntroductionAdvisor) {
                this.validateIntroductionAdvisor((IntroductionAdvisor)advisor);
            }
            Assert.notNull(advisor, "Advisor must not be null");
            this.advisors.add(advisor);
        }
        this.updateAdvisorArray();
        this.adviceChanged();
    }

    AdvisedSupport getConfigurationOnlyCopy() {
        AdvisedSupport copy2 = new AdvisedSupport();
        copy2.copyFrom(this);
        copy2.targetSource = EmptyTargetSource.forClass(this.getTargetClass(), this.getTargetSource().isStatic());
        copy2.advisorChainFactory = this.advisorChainFactory;
        copy2.interfaces = this.interfaces;
        copy2.advisors = this.advisors;
        copy2.updateAdvisorArray();
        return copy2;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.initMethodCache();
    }

    @Override
    public String toProxyConfigString() {
        return this.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append(": ").append(this.interfaces.size()).append(" interfaces ");
        sb.append(ClassUtils.classNamesToString(this.interfaces)).append("; ");
        sb.append(this.advisors.size()).append(" advisors ");
        sb.append(this.advisors).append("; ");
        sb.append("targetSource [").append(this.targetSource).append("]; ");
        sb.append(super.toString());
        return sb.toString();
    }

    private static class MethodCacheKey {
        private final Method method;
        private final int hashCode;

        public MethodCacheKey(Method method) {
            this.method = method;
            this.hashCode = method.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            MethodCacheKey otherKey = (MethodCacheKey)other;
            return this.method == otherKey.method;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

