/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Dispatcher;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import net.sf.cglib.transform.impl.UndeclaredThrowableStrategy;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.aop.RawTargetAccess;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.AopContext;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.SmartClassLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

final class Cglib2AopProxy
implements AopProxy,
Serializable {
    private static final int AOP_PROXY = 0;
    private static final int INVOKE_TARGET = 1;
    private static final int NO_OVERRIDE = 2;
    private static final int DISPATCH_TARGET = 3;
    private static final int DISPATCH_ADVISED = 4;
    private static final int INVOKE_EQUALS = 5;
    private static final int INVOKE_HASHCODE = 6;
    protected static final Log logger = LogFactory.getLog(Cglib2AopProxy.class);
    private static final Map<Class, Boolean> validatedClasses = new WeakHashMap<Class, Boolean>();
    protected final AdvisedSupport advised;
    private Object[] constructorArgs;
    private Class[] constructorArgTypes;
    private final transient AdvisedDispatcher advisedDispatcher;
    private transient Map<String, Integer> fixedInterceptorMap;
    private transient int fixedInterceptorOffset;

    public Cglib2AopProxy(AdvisedSupport config) throws AopConfigException {
        Assert.notNull(config, "AdvisedSupport must not be null");
        if (config.getAdvisors().length == 0 && config.getTargetSource() == AdvisedSupport.EMPTY_TARGET_SOURCE) {
            throw new AopConfigException("No advisors and no TargetSource specified");
        }
        this.advised = config;
        this.advisedDispatcher = new AdvisedDispatcher(this.advised);
    }

    public void setConstructorArguments(Object[] constructorArgs, Class[] constructorArgTypes) {
        if (constructorArgs == null || constructorArgTypes == null) {
            throw new IllegalArgumentException("Both 'constructorArgs' and 'constructorArgTypes' need to be specified");
        }
        if (constructorArgs.length != constructorArgTypes.length) {
            throw new IllegalArgumentException("Number of 'constructorArgs' (" + constructorArgs.length + ") must match number of 'constructorArgTypes' (" + constructorArgTypes.length + ")");
        }
        this.constructorArgs = constructorArgs;
        this.constructorArgTypes = constructorArgTypes;
    }

    public Object getProxy() {
        return this.getProxy(null);
    }

    public Object getProxy(ClassLoader classLoader) {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating CGLIB2 proxy: target source is " + this.advised.getTargetSource());
        }
        try {
            Class<?> rootClass = this.advised.getTargetClass();
            Assert.state(rootClass != null, "Target class must be available for creating a CGLIB proxy");
            Class<?> proxySuperClass = rootClass;
            if (ClassUtils.isCglibProxyClass(rootClass)) {
                Class<?>[] additionalInterfaces;
                proxySuperClass = rootClass.getSuperclass();
                Class<?>[] classArray = additionalInterfaces = rootClass.getInterfaces();
                int n = additionalInterfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> additionalInterface = classArray[n2];
                    this.advised.addInterface(additionalInterface);
                    ++n2;
                }
            }
            this.validateClassIfNecessary(proxySuperClass);
            Enhancer enhancer = this.createEnhancer();
            if (classLoader != null) {
                enhancer.setClassLoader(classLoader);
                if (classLoader instanceof SmartClassLoader && ((SmartClassLoader)((Object)classLoader)).isClassReloadable(proxySuperClass)) {
                    enhancer.setUseCache(false);
                }
            }
            enhancer.setSuperclass(proxySuperClass);
            enhancer.setStrategy(new UndeclaredThrowableStrategy(UndeclaredThrowableException.class));
            enhancer.setInterfaces(AopProxyUtils.completeProxiedInterfaces(this.advised));
            enhancer.setInterceptDuringConstruction(false);
            Callback[] callbacks = this.getCallbacks(rootClass);
            enhancer.setCallbacks(callbacks);
            enhancer.setCallbackFilter(new ProxyCallbackFilter(this.advised.getConfigurationOnlyCopy(), this.fixedInterceptorMap, this.fixedInterceptorOffset));
            Class[] types2 = new Class[callbacks.length];
            int x = 0;
            while (x < types2.length) {
                types2[x] = callbacks[x].getClass();
                ++x;
            }
            enhancer.setCallbackTypes(types2);
            Object proxy = this.constructorArgs != null ? enhancer.create(this.constructorArgTypes, this.constructorArgs) : enhancer.create();
            return proxy;
        }
        catch (CodeGenerationException ex2) {
            throw new AopConfigException("Could not generate CGLIB subclass of class [" + this.advised.getTargetClass() + "]: " + "Common causes of this problem include using a final class or a non-visible class", ex2);
        }
        catch (IllegalArgumentException ex3) {
            throw new AopConfigException("Could not generate CGLIB subclass of class [" + this.advised.getTargetClass() + "]: " + "Common causes of this problem include using a final class or a non-visible class", ex3);
        }
        catch (Exception ex4) {
            throw new AopConfigException("Unexpected AOP exception", ex4);
        }
    }

    protected Enhancer createEnhancer() {
        return new Enhancer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateClassIfNecessary(Class proxySuperClass) {
        if (logger.isWarnEnabled()) {
            Map<Class, Boolean> map3 = validatedClasses;
            synchronized (map3) {
                if (!validatedClasses.containsKey(proxySuperClass)) {
                    this.doValidateClass(proxySuperClass);
                    validatedClasses.put(proxySuperClass, Boolean.TRUE);
                }
            }
        }
    }

    private void doValidateClass(Class proxySuperClass) {
        Method[] methods2;
        Method[] methodArray = methods2 = proxySuperClass.getMethods();
        int n = methods2.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (!Object.class.equals(method.getDeclaringClass()) && Modifier.isFinal(method.getModifiers())) {
                logger.warn("Unable to proxy method [" + method + "] because it is final: " + "All calls to this method via a proxy will be routed directly to the proxy.");
            }
            ++n2;
        }
    }

    private Callback[] getCallbacks(Class rootClass) throws Exception {
        Callback[] callbacks;
        boolean exposeProxy = this.advised.isExposeProxy();
        boolean isFrozen = this.advised.isFrozen();
        boolean isStatic = this.advised.getTargetSource().isStatic();
        DynamicAdvisedInterceptor aopInterceptor = new DynamicAdvisedInterceptor(this.advised);
        MethodInterceptor targetInterceptor = exposeProxy ? (isStatic ? new StaticUnadvisedExposedInterceptor(this.advised.getTargetSource().getTarget()) : new DynamicUnadvisedExposedInterceptor(this.advised.getTargetSource())) : (isStatic ? new StaticUnadvisedInterceptor(this.advised.getTargetSource().getTarget()) : new DynamicUnadvisedInterceptor(this.advised.getTargetSource()));
        Callback targetDispatcher = isStatic ? new StaticDispatcher(this.advised.getTargetSource().getTarget()) : new SerializableNoOp();
        Callback[] mainCallbacks = new Callback[]{aopInterceptor, targetInterceptor, new SerializableNoOp(), targetDispatcher, this.advisedDispatcher, new EqualsInterceptor(this.advised), new HashCodeInterceptor(this.advised)};
        if (isStatic && isFrozen) {
            Method[] methods2 = rootClass.getMethods();
            Callback[] fixedCallbacks = new Callback[methods2.length];
            this.fixedInterceptorMap = new HashMap<String, Integer>(methods2.length);
            int x = 0;
            while (x < methods2.length) {
                List<Object> chain2 = this.advised.getInterceptorsAndDynamicInterceptionAdvice(methods2[x], rootClass);
                fixedCallbacks[x] = new FixedChainStaticTargetInterceptor(chain2, this.advised.getTargetSource().getTarget(), this.advised.getTargetClass());
                this.fixedInterceptorMap.put(methods2[x].toString(), x);
                ++x;
            }
            callbacks = new Callback[mainCallbacks.length + fixedCallbacks.length];
            System.arraycopy(mainCallbacks, 0, callbacks, 0, mainCallbacks.length);
            System.arraycopy(fixedCallbacks, 0, callbacks, mainCallbacks.length, fixedCallbacks.length);
            this.fixedInterceptorOffset = mainCallbacks.length;
        } else {
            callbacks = mainCallbacks;
        }
        return callbacks;
    }

    private static Object massageReturnTypeIfNecessary(Object proxy, Object target2, Method method, Object retVal) {
        if (retVal != null && retVal == target2 && !RawTargetAccess.class.isAssignableFrom(method.getDeclaringClass())) {
            retVal = proxy;
        }
        return retVal;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Cglib2AopProxy && AopProxyUtils.equalsInProxy(this.advised, ((Cglib2AopProxy)other).advised);
    }

    public int hashCode() {
        return Cglib2AopProxy.class.hashCode() * 13 + this.advised.getTargetSource().hashCode();
    }

    private static class AdvisedDispatcher
    implements Dispatcher,
    Serializable {
        private final AdvisedSupport advised;

        public AdvisedDispatcher(AdvisedSupport advised) {
            this.advised = advised;
        }

        public Object loadObject() throws Exception {
            return this.advised;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CglibMethodInvocation
    extends ReflectiveMethodInvocation {
        private final MethodProxy methodProxy;
        private boolean protectedMethod;

        public CglibMethodInvocation(Object proxy, Object target2, Method method, Object[] arguments2, Class targetClass, List<Object> interceptorsAndDynamicMethodMatchers, MethodProxy methodProxy) {
            super(proxy, target2, method, arguments2, targetClass, interceptorsAndDynamicMethodMatchers);
            this.methodProxy = methodProxy;
            this.protectedMethod = Modifier.isProtected(method.getModifiers());
        }

        @Override
        protected Object invokeJoinpoint() throws Throwable {
            if (this.protectedMethod) {
                return super.invokeJoinpoint();
            }
            return this.methodProxy.invoke(this.target, this.arguments);
        }
    }

    private static class DynamicAdvisedInterceptor
    implements MethodInterceptor,
    Serializable {
        private AdvisedSupport advised;

        public DynamicAdvisedInterceptor(AdvisedSupport advised) {
            this.advised = advised;
        }

        public Object intercept(Object proxy, Method method, Object[] args2, MethodProxy methodProxy) throws Throwable {
            Object oldProxy = null;
            boolean setProxyContext = false;
            Class<?> targetClass = null;
            Object target2 = null;
            try {
                List<Object> chain2;
                if (this.advised.exposeProxy) {
                    oldProxy = AopContext.setCurrentProxy(proxy);
                    setProxyContext = true;
                }
                if ((target2 = this.getTarget()) != null) {
                    targetClass = target2.getClass();
                }
                Object retVal = (chain2 = this.advised.getInterceptorsAndDynamicInterceptionAdvice(method, targetClass)).isEmpty() && Modifier.isPublic(method.getModifiers()) ? methodProxy.invoke(target2, args2) : new CglibMethodInvocation(proxy, target2, method, args2, targetClass, chain2, methodProxy).proceed();
                Object object = retVal = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, target2, method, retVal);
                return object;
            }
            finally {
                if (target2 != null) {
                    this.releaseTarget(target2);
                }
                if (setProxyContext) {
                    AopContext.setCurrentProxy(oldProxy);
                }
            }
        }

        public boolean equals(Object other) {
            return this == other || other instanceof DynamicAdvisedInterceptor && this.advised.equals(((DynamicAdvisedInterceptor)other).advised);
        }

        public int hashCode() {
            return this.advised.hashCode();
        }

        protected Object getTarget() throws Exception {
            return this.advised.getTargetSource().getTarget();
        }

        protected void releaseTarget(Object target2) throws Exception {
            this.advised.getTargetSource().releaseTarget(target2);
        }
    }

    private static class DynamicUnadvisedExposedInterceptor
    implements MethodInterceptor,
    Serializable {
        private final TargetSource targetSource;

        public DynamicUnadvisedExposedInterceptor(TargetSource targetSource) {
            this.targetSource = targetSource;
        }

        public Object intercept(Object proxy, Method method, Object[] args2, MethodProxy methodProxy) throws Throwable {
            Object oldProxy = null;
            Object target2 = this.targetSource.getTarget();
            try {
                oldProxy = AopContext.setCurrentProxy(proxy);
                Object retVal = methodProxy.invoke(target2, args2);
                Object object = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, target2, method, retVal);
                return object;
            }
            finally {
                AopContext.setCurrentProxy(oldProxy);
                this.targetSource.releaseTarget(target2);
            }
        }
    }

    private static class DynamicUnadvisedInterceptor
    implements MethodInterceptor,
    Serializable {
        private final TargetSource targetSource;

        public DynamicUnadvisedInterceptor(TargetSource targetSource) {
            this.targetSource = targetSource;
        }

        public Object intercept(Object proxy, Method method, Object[] args2, MethodProxy methodProxy) throws Throwable {
            Object target2 = this.targetSource.getTarget();
            try {
                Object retVal = methodProxy.invoke(target2, args2);
                Object object = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, target2, method, retVal);
                return object;
            }
            finally {
                this.targetSource.releaseTarget(target2);
            }
        }
    }

    private static class EqualsInterceptor
    implements MethodInterceptor,
    Serializable {
        private final AdvisedSupport advised;

        public EqualsInterceptor(AdvisedSupport advised) {
            this.advised = advised;
        }

        public Object intercept(Object proxy, Method method, Object[] args2, MethodProxy methodProxy) {
            Object other = args2[0];
            if (proxy == other) {
                return true;
            }
            if (other instanceof Factory) {
                Callback callback = ((Factory)other).getCallback(5);
                if (!(callback instanceof EqualsInterceptor)) {
                    return false;
                }
                AdvisedSupport otherAdvised = ((EqualsInterceptor)callback).advised;
                return AopProxyUtils.equalsInProxy(this.advised, otherAdvised);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedChainStaticTargetInterceptor
    implements MethodInterceptor,
    Serializable {
        private final List<Object> adviceChain;
        private final Object target;
        private final Class targetClass;

        public FixedChainStaticTargetInterceptor(List<Object> adviceChain, Object target2, Class targetClass) {
            this.adviceChain = adviceChain;
            this.target = target2;
            this.targetClass = targetClass;
        }

        @Override
        public Object intercept(Object proxy, Method method, Object[] args2, MethodProxy methodProxy) throws Throwable {
            CglibMethodInvocation invocation = new CglibMethodInvocation(proxy, this.target, method, args2, this.targetClass, this.adviceChain, methodProxy);
            Object retVal = invocation.proceed();
            retVal = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, this.target, method, retVal);
            return retVal;
        }
    }

    private static class HashCodeInterceptor
    implements MethodInterceptor,
    Serializable {
        private final AdvisedSupport advised;

        public HashCodeInterceptor(AdvisedSupport advised) {
            this.advised = advised;
        }

        public Object intercept(Object proxy, Method method, Object[] args2, MethodProxy methodProxy) {
            return Cglib2AopProxy.class.hashCode() * 13 + this.advised.getTargetSource().hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProxyCallbackFilter
    implements CallbackFilter {
        private final AdvisedSupport advised;
        private final Map<String, Integer> fixedInterceptorMap;
        private final int fixedInterceptorOffset;

        public ProxyCallbackFilter(AdvisedSupport advised, Map<String, Integer> fixedInterceptorMap, int fixedInterceptorOffset) {
            this.advised = advised;
            this.fixedInterceptorMap = fixedInterceptorMap;
            this.fixedInterceptorOffset = fixedInterceptorOffset;
        }

        @Override
        public int accept(Method method) {
            if (AopUtils.isFinalizeMethod(method)) {
                logger.debug("Found finalize() method - using NO_OVERRIDE");
                return 2;
            }
            if (!this.advised.isOpaque() && method.getDeclaringClass().isInterface() && method.getDeclaringClass().isAssignableFrom(Advised.class)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Method is declared on Advised interface: " + method);
                }
                return 4;
            }
            if (AopUtils.isEqualsMethod(method)) {
                logger.debug("Found 'equals' method: " + method);
                return 5;
            }
            if (AopUtils.isHashCodeMethod(method)) {
                logger.debug("Found 'hashCode' method: " + method);
                return 6;
            }
            Class<?> targetClass = this.advised.getTargetClass();
            List<Object> chain2 = this.advised.getInterceptorsAndDynamicInterceptionAdvice(method, targetClass);
            boolean haveAdvice = !chain2.isEmpty();
            boolean exposeProxy = this.advised.isExposeProxy();
            boolean isStatic = this.advised.getTargetSource().isStatic();
            boolean isFrozen = this.advised.isFrozen();
            if (haveAdvice || !isFrozen) {
                if (exposeProxy) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Must expose proxy on advised method: " + method);
                    }
                    return 0;
                }
                String key = method.toString();
                if (isStatic && isFrozen && this.fixedInterceptorMap.containsKey(key)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Method has advice and optimisations are enabled: " + method);
                    }
                    int index2 = this.fixedInterceptorMap.get(key);
                    return index2 + this.fixedInterceptorOffset;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Unable to apply any optimisations to advised method: " + method);
                }
                return 0;
            }
            if (exposeProxy || !isStatic) {
                return 1;
            }
            Class<?> returnType = method.getReturnType();
            if (targetClass == returnType) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Method " + method + "has return type same as target type (may return this) - using INVOKE_TARGET");
                }
                return 1;
            }
            if (returnType.isPrimitive() || !returnType.isAssignableFrom(targetClass)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Method " + method + " has return type that ensures this cannot be returned- using DISPATCH_TARGET");
                }
                return 3;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Method " + method + "has return type that is assignable from the target type (may return this) - " + "using INVOKE_TARGET");
            }
            return 1;
        }

        @Override
        public boolean equals(Object other) {
            Advisor[] thatAdvisors;
            if (other == this) {
                return true;
            }
            if (!(other instanceof ProxyCallbackFilter)) {
                return false;
            }
            ProxyCallbackFilter otherCallbackFilter = (ProxyCallbackFilter)other;
            AdvisedSupport otherAdvised = otherCallbackFilter.advised;
            if (this.advised == null || otherAdvised == null) {
                return false;
            }
            if (this.advised.isFrozen() != otherAdvised.isFrozen()) {
                return false;
            }
            if (this.advised.isExposeProxy() != otherAdvised.isExposeProxy()) {
                return false;
            }
            if (this.advised.getTargetSource().isStatic() != otherAdvised.getTargetSource().isStatic()) {
                return false;
            }
            if (!AopProxyUtils.equalsProxiedInterfaces(this.advised, otherAdvised)) {
                return false;
            }
            Advisor[] thisAdvisors = this.advised.getAdvisors();
            if (thisAdvisors.length != (thatAdvisors = otherAdvised.getAdvisors()).length) {
                return false;
            }
            int i = 0;
            while (i < thisAdvisors.length) {
                Advisor thisAdvisor = thisAdvisors[i];
                Advisor thatAdvisor = thatAdvisors[i];
                if (!this.equalsAdviceClasses(thisAdvisor, thatAdvisor)) {
                    return false;
                }
                if (!this.equalsPointcuts(thisAdvisor, thatAdvisor)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private boolean equalsAdviceClasses(Advisor a2, Advisor b) {
            Advice aa = a2.getAdvice();
            Advice ba = b.getAdvice();
            if (aa == null || ba == null) {
                return aa == ba;
            }
            return aa.getClass().equals(ba.getClass());
        }

        private boolean equalsPointcuts(Advisor a2, Advisor b) {
            return !(a2 instanceof PointcutAdvisor) || b instanceof PointcutAdvisor && ObjectUtils.nullSafeEquals(((PointcutAdvisor)a2).getPointcut(), ((PointcutAdvisor)b).getPointcut());
        }

        public int hashCode() {
            Advisor[] advisors;
            int hashCode2 = 0;
            Advisor[] advisorArray = advisors = this.advised.getAdvisors();
            int n = advisors.length;
            int n2 = 0;
            while (n2 < n) {
                Advisor advisor = advisorArray[n2];
                Advice advice = advisor.getAdvice();
                if (advice != null) {
                    hashCode2 = 13 * hashCode2 + advice.getClass().hashCode();
                }
                ++n2;
            }
            hashCode2 = 13 * hashCode2 + (this.advised.isFrozen() ? 1 : 0);
            hashCode2 = 13 * hashCode2 + (this.advised.isExposeProxy() ? 1 : 0);
            hashCode2 = 13 * hashCode2 + (this.advised.isOptimize() ? 1 : 0);
            hashCode2 = 13 * hashCode2 + (this.advised.isOpaque() ? 1 : 0);
            return hashCode2;
        }
    }

    public static class SerializableNoOp
    implements NoOp,
    Serializable {
    }

    private static class StaticDispatcher
    implements Dispatcher,
    Serializable {
        private Object target;

        public StaticDispatcher(Object target2) {
            this.target = target2;
        }

        public Object loadObject() {
            return this.target;
        }
    }

    private static class StaticUnadvisedExposedInterceptor
    implements MethodInterceptor,
    Serializable {
        private final Object target;

        public StaticUnadvisedExposedInterceptor(Object target2) {
            this.target = target2;
        }

        public Object intercept(Object proxy, Method method, Object[] args2, MethodProxy methodProxy) throws Throwable {
            Object oldProxy = null;
            try {
                oldProxy = AopContext.setCurrentProxy(proxy);
                Object retVal = methodProxy.invoke(this.target, args2);
                Object object = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, this.target, method, retVal);
                return object;
            }
            finally {
                AopContext.setCurrentProxy(oldProxy);
            }
        }
    }

    private static class StaticUnadvisedInterceptor
    implements MethodInterceptor,
    Serializable {
        private final Object target;

        public StaticUnadvisedInterceptor(Object target2) {
            this.target = target2;
        }

        public Object intercept(Object proxy, Method method, Object[] args2, MethodProxy methodProxy) throws Throwable {
            Object retVal = methodProxy.invoke(this.target, args2);
            return Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, this.target, method, retVal);
        }
    }
}

