/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.io.Serializable;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.AopProxyFactory;
import org.springframework.aop.framework.Cglib2AopProxy;
import org.springframework.aop.framework.JdkDynamicAopProxy;
import org.springframework.util.ClassUtils;

public class DefaultAopProxyFactory
implements AopProxyFactory,
Serializable {
    private static final boolean cglibAvailable = ClassUtils.isPresent("net.sf.cglib.proxy.Enhancer", DefaultAopProxyFactory.class.getClassLoader());

    public AopProxy createAopProxy(AdvisedSupport config) throws AopConfigException {
        if (config.isOptimize() || config.isProxyTargetClass() || this.hasNoUserSuppliedProxyInterfaces(config)) {
            Class<?> targetClass = config.getTargetClass();
            if (targetClass == null) {
                throw new AopConfigException("TargetSource cannot determine target class: Either an interface or a target is required for proxy creation.");
            }
            if (targetClass.isInterface()) {
                return new JdkDynamicAopProxy(config);
            }
            if (!cglibAvailable) {
                throw new AopConfigException("Cannot proxy target class because CGLIB2 is not available. Add CGLIB to the class path or specify proxy interfaces.");
            }
            return CglibProxyFactory.createCglibProxy(config);
        }
        return new JdkDynamicAopProxy(config);
    }

    private boolean hasNoUserSuppliedProxyInterfaces(AdvisedSupport config) {
        Class[] interfaces2 = config.getProxiedInterfaces();
        return interfaces2.length == 0 || interfaces2.length == 1 && SpringProxy.class.equals((Object)interfaces2[0]);
    }

    private static class CglibProxyFactory {
        private CglibProxyFactory() {
        }

        public static AopProxy createCglibProxy(AdvisedSupport advisedSupport) {
            return new Cglib2AopProxy(advisedSupport);
        }
    }
}

