/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.interceptor;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.Ordered;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.support.TaskExecutorAdapter;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class AsyncExecutionInterceptor
implements MethodInterceptor,
Ordered {
    private final AsyncTaskExecutor asyncExecutor;

    public AsyncExecutionInterceptor(AsyncTaskExecutor asyncExecutor) {
        Assert.notNull(asyncExecutor, "TaskExecutor must not be null");
        this.asyncExecutor = asyncExecutor;
    }

    public AsyncExecutionInterceptor(Executor asyncExecutor) {
        this.asyncExecutor = new TaskExecutorAdapter(asyncExecutor);
    }

    public Object invoke(final MethodInvocation invocation) throws Throwable {
        Future<Object> result2 = this.asyncExecutor.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    Object result2 = invocation.proceed();
                    if (result2 instanceof Future) {
                        return ((Future)result2).get();
                    }
                }
                catch (Throwable ex2) {
                    ReflectionUtils.rethrowException(ex2);
                }
                return null;
            }
        });
        if (Future.class.isAssignableFrom(invocation.getMethod().getReturnType())) {
            return result2;
        }
        return null;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

