/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.Serializable;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractGenericPointcutAdvisor;
import org.springframework.aop.support.AbstractRegexpMethodPointcut;
import org.springframework.aop.support.JdkRegexpMethodPointcut;
import org.springframework.util.ObjectUtils;

public class RegexpMethodPointcutAdvisor
extends AbstractGenericPointcutAdvisor {
    private String[] patterns;
    private AbstractRegexpMethodPointcut pointcut;
    private final Object pointcutMonitor = new SerializableMonitor();

    public RegexpMethodPointcutAdvisor() {
    }

    public RegexpMethodPointcutAdvisor(Advice advice) {
        this.setAdvice(advice);
    }

    public RegexpMethodPointcutAdvisor(String pattern, Advice advice) {
        this.setPattern(pattern);
        this.setAdvice(advice);
    }

    public RegexpMethodPointcutAdvisor(String[] patterns2, Advice advice) {
        this.setPatterns(patterns2);
        this.setAdvice(advice);
    }

    public void setPattern(String pattern) {
        this.setPatterns(new String[]{pattern});
    }

    public void setPatterns(String[] patterns2) {
        this.patterns = patterns2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pointcut getPointcut() {
        Object object = this.pointcutMonitor;
        synchronized (object) {
            if (this.pointcut == null) {
                this.pointcut = this.createPointcut();
                this.pointcut.setPatterns(this.patterns);
            }
            return this.pointcut;
        }
    }

    protected AbstractRegexpMethodPointcut createPointcut() {
        return new JdkRegexpMethodPointcut();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": advice [" + this.getAdvice() + "], pointcut patterns " + ObjectUtils.nullSafeToString(this.patterns);
    }

    private static class SerializableMonitor
    implements Serializable {
        private SerializableMonitor() {
        }
    }
}

