/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.TargetSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLazyCreationTargetSource
implements TargetSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Object lazyTarget;

    public synchronized boolean isInitialized() {
        return this.lazyTarget != null;
    }

    @Override
    public synchronized Class<?> getTargetClass() {
        return this.lazyTarget != null ? this.lazyTarget.getClass() : null;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public synchronized Object getTarget() throws Exception {
        if (this.lazyTarget == null) {
            this.logger.debug("Initializing lazy target object");
            this.lazyTarget = this.createObject();
        }
        return this.lazyTarget;
    }

    @Override
    public void releaseTarget(Object target2) throws Exception {
    }

    protected abstract Object createObject() throws Exception;
}

