/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target;

import org.springframework.aop.support.DefaultIntroductionAdvisor;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.aop.target.AbstractPrototypeBasedTargetSource;
import org.springframework.aop.target.PoolingConfig;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.DisposableBean;

public abstract class AbstractPoolingTargetSource
extends AbstractPrototypeBasedTargetSource
implements PoolingConfig,
DisposableBean {
    private int maxSize = -1;

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public final void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        super.setBeanFactory(beanFactory);
        try {
            this.createPool();
        }
        catch (Throwable ex2) {
            throw new BeanInitializationException("Could not create instance pool for TargetSource", ex2);
        }
    }

    protected abstract void createPool() throws Exception;

    public abstract Object getTarget() throws Exception;

    public abstract void releaseTarget(Object var1) throws Exception;

    public DefaultIntroductionAdvisor getPoolingConfigMixin() {
        DelegatingIntroductionInterceptor dii = new DelegatingIntroductionInterceptor(this);
        return new DefaultIntroductionAdvisor(dii, PoolingConfig.class);
    }
}

