/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.support.DefaultIntroductionAdvisor;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.aop.target.AbstractPrototypeBasedTargetSource;
import org.springframework.aop.target.ThreadLocalTargetSourceStats;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.NamedThreadLocal;

public class ThreadLocalTargetSource
extends AbstractPrototypeBasedTargetSource
implements ThreadLocalTargetSourceStats,
DisposableBean {
    private final ThreadLocal<Object> targetInThread = new NamedThreadLocal<Object>("Thread-local instance of bean '" + this.getTargetBeanName() + "'");
    private final Set<Object> targetSet = Collections.synchronizedSet(new HashSet());
    private int invocationCount;
    private int hitCount;

    public Object getTarget() throws BeansException {
        ++this.invocationCount;
        Object target2 = this.targetInThread.get();
        if (target2 == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No target for prototype '" + this.getTargetBeanName() + "' bound to thread: " + "creating one and binding it to thread '" + Thread.currentThread().getName() + "'");
            }
            target2 = this.newPrototypeInstance();
            this.targetInThread.set(target2);
            this.targetSet.add(target2);
        } else {
            ++this.hitCount;
        }
        return target2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.logger.debug("Destroying ThreadLocalTargetSource bindings");
        Set<Object> set2 = this.targetSet;
        synchronized (set2) {
            for (Object target2 : this.targetSet) {
                this.destroyPrototypeInstance(target2);
            }
            this.targetSet.clear();
        }
        this.targetInThread.remove();
    }

    public int getInvocationCount() {
        return this.invocationCount;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public int getObjectCount() {
        return this.targetSet.size();
    }

    public IntroductionAdvisor getStatsMixin() {
        DelegatingIntroductionInterceptor dii = new DelegatingIntroductionInterceptor(this);
        return new DefaultIntroductionAdvisor(dii, ThreadLocalTargetSourceStats.class);
    }
}

