/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.GenericTypeAwarePropertyDescriptor;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanUtils {
    private static final Log logger = LogFactory.getLog(BeanUtils.class);
    private static final Map<Class<?>, Boolean> unknownEditorTypes = Collections.synchronizedMap(new WeakHashMap());

    public static <T> T instantiate(Class<T> clazz2) throws BeanInstantiationException {
        Assert.notNull(clazz2, "Class must not be null");
        if (clazz2.isInterface()) {
            throw new BeanInstantiationException(clazz2, "Specified class is an interface");
        }
        try {
            return clazz2.newInstance();
        }
        catch (InstantiationException ex2) {
            throw new BeanInstantiationException(clazz2, "Is it an abstract class?", ex2);
        }
        catch (IllegalAccessException ex3) {
            throw new BeanInstantiationException(clazz2, "Is the constructor accessible?", ex3);
        }
    }

    public static <T> T instantiateClass(Class<T> clazz2) throws BeanInstantiationException {
        Assert.notNull(clazz2, "Class must not be null");
        if (clazz2.isInterface()) {
            throw new BeanInstantiationException(clazz2, "Specified class is an interface");
        }
        try {
            return BeanUtils.instantiateClass(clazz2.getDeclaredConstructor(new Class[0]), new Object[0]);
        }
        catch (NoSuchMethodException ex2) {
            throw new BeanInstantiationException(clazz2, "No default constructor found", ex2);
        }
    }

    public static <T> T instantiateClass(Class<?> clazz2, Class<T> assignableTo) throws BeanInstantiationException {
        Assert.isAssignable(assignableTo, clazz2);
        return (T)BeanUtils.instantiateClass(clazz2);
    }

    public static <T> T instantiateClass(Constructor<T> ctor, Object ... args2) throws BeanInstantiationException {
        Assert.notNull(ctor, "Constructor must not be null");
        try {
            ReflectionUtils.makeAccessible(ctor);
            return ctor.newInstance(args2);
        }
        catch (InstantiationException ex2) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Is it an abstract class?", ex2);
        }
        catch (IllegalAccessException ex3) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Is the constructor accessible?", ex3);
        }
        catch (IllegalArgumentException ex4) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Illegal arguments for constructor", ex4);
        }
        catch (InvocationTargetException ex5) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Constructor threw exception", ex5.getTargetException());
        }
    }

    public static Method findMethod(Class<?> clazz2, String methodName, Class<?> ... paramTypes2) {
        try {
            return clazz2.getMethod(methodName, paramTypes2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return BeanUtils.findDeclaredMethod(clazz2, methodName, paramTypes2);
        }
    }

    public static Method findDeclaredMethod(Class<?> clazz2, String methodName, Class<?>[] paramTypes2) {
        try {
            return clazz2.getDeclaredMethod(methodName, paramTypes2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (clazz2.getSuperclass() != null) {
                return BeanUtils.findDeclaredMethod(clazz2.getSuperclass(), methodName, paramTypes2);
            }
            return null;
        }
    }

    public static Method findMethodWithMinimalParameters(Class<?> clazz2, String methodName) throws IllegalArgumentException {
        Method targetMethod = BeanUtils.findMethodWithMinimalParameters(clazz2.getMethods(), methodName);
        if (targetMethod == null) {
            targetMethod = BeanUtils.findDeclaredMethodWithMinimalParameters(clazz2, methodName);
        }
        return targetMethod;
    }

    public static Method findDeclaredMethodWithMinimalParameters(Class<?> clazz2, String methodName) throws IllegalArgumentException {
        Method targetMethod = BeanUtils.findMethodWithMinimalParameters(clazz2.getDeclaredMethods(), methodName);
        if (targetMethod == null && clazz2.getSuperclass() != null) {
            targetMethod = BeanUtils.findDeclaredMethodWithMinimalParameters(clazz2.getSuperclass(), methodName);
        }
        return targetMethod;
    }

    public static Method findMethodWithMinimalParameters(Method[] methods2, String methodName) throws IllegalArgumentException {
        Method targetMethod = null;
        int numMethodsFoundWithCurrentMinimumArgs = 0;
        Method[] methodArray = methods2;
        int n = methods2.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(methodName)) {
                int numParams = method.getParameterTypes().length;
                if (targetMethod == null || numParams < targetMethod.getParameterTypes().length) {
                    targetMethod = method;
                    numMethodsFoundWithCurrentMinimumArgs = 1;
                } else if (targetMethod.getParameterTypes().length == numParams) {
                    ++numMethodsFoundWithCurrentMinimumArgs;
                }
            }
            ++n2;
        }
        if (numMethodsFoundWithCurrentMinimumArgs > 1) {
            throw new IllegalArgumentException("Cannot resolve method '" + methodName + "' to a unique method. Attempted to resolve to overloaded method with " + "the least number of parameters, but there were " + numMethodsFoundWithCurrentMinimumArgs + " candidates.");
        }
        return targetMethod;
    }

    public static Method resolveSignature(String signature2, Class<?> clazz2) {
        Assert.hasText(signature2, "'signature' must not be empty");
        Assert.notNull(clazz2, "Class must not be null");
        int firstParen = signature2.indexOf("(");
        int lastParen = signature2.indexOf(")");
        if (firstParen > -1 && lastParen == -1) {
            throw new IllegalArgumentException("Invalid method signature '" + signature2 + "': expected closing ')' for args list");
        }
        if (lastParen > -1 && firstParen == -1) {
            throw new IllegalArgumentException("Invalid method signature '" + signature2 + "': expected opening '(' for args list");
        }
        if (firstParen == -1 && lastParen == -1) {
            return BeanUtils.findMethodWithMinimalParameters(clazz2, signature2);
        }
        String methodName = signature2.substring(0, firstParen);
        String[] parameterTypeNames = StringUtils.commaDelimitedListToStringArray(signature2.substring(firstParen + 1, lastParen));
        Class[] parameterTypes = new Class[parameterTypeNames.length];
        int i = 0;
        while (i < parameterTypeNames.length) {
            String parameterTypeName = parameterTypeNames[i].trim();
            try {
                parameterTypes[i] = ClassUtils.forName(parameterTypeName, clazz2.getClassLoader());
            }
            catch (Throwable ex2) {
                throw new IllegalArgumentException("Invalid method signature: unable to resolve type [" + parameterTypeName + "] for argument " + i + ". Root cause: " + ex2);
            }
            ++i;
        }
        return BeanUtils.findMethod(clazz2, methodName, parameterTypes);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz2) throws BeansException {
        CachedIntrospectionResults cr = CachedIntrospectionResults.forClass(clazz2);
        return cr.getPropertyDescriptors();
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz2, String propertyName) throws BeansException {
        CachedIntrospectionResults cr = CachedIntrospectionResults.forClass(clazz2);
        return cr.getPropertyDescriptor(propertyName);
    }

    public static PropertyDescriptor findPropertyForMethod(Method method) throws BeansException {
        PropertyDescriptor[] pds;
        Assert.notNull(method, "Method must not be null");
        PropertyDescriptor[] propertyDescriptorArray = pds = BeanUtils.getPropertyDescriptors(method.getDeclaringClass());
        int n = pds.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            if (method.equals(pd.getReadMethod()) || method.equals(pd.getWriteMethod())) {
                return pd;
            }
            ++n2;
        }
        return null;
    }

    public static PropertyEditor findEditorByConvention(Class<?> targetType) {
        Class<?> editorClass;
        block11: {
            if (targetType == null || targetType.isArray() || unknownEditorTypes.containsKey(targetType)) {
                return null;
            }
            ClassLoader cl = targetType.getClassLoader();
            if (cl == null) {
                try {
                    cl = ClassLoader.getSystemClassLoader();
                    if (cl == null) {
                        return null;
                    }
                }
                catch (Throwable ex2) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Could not access system ClassLoader: " + ex2);
                    }
                    return null;
                }
            }
            String editorName = String.valueOf(targetType.getName()) + "Editor";
            try {
                editorClass = cl.loadClass(editorName);
                if (PropertyEditor.class.isAssignableFrom(editorClass)) break block11;
                if (logger.isWarnEnabled()) {
                    logger.warn("Editor class [" + editorName + "] does not implement [java.beans.PropertyEditor] interface");
                }
                unknownEditorTypes.put(targetType, Boolean.TRUE);
                return null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No property editor [" + editorName + "] found for type " + targetType.getName() + " according to 'Editor' suffix convention");
                }
                unknownEditorTypes.put(targetType, Boolean.TRUE);
                return null;
            }
        }
        return (PropertyEditor)BeanUtils.instantiateClass(editorClass);
    }

    public static Class<?> findPropertyType(String propertyName, Class<?>[] beanClasses) {
        if (beanClasses != null) {
            Class<?>[] classArray = beanClasses;
            int n = beanClasses.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> beanClass = classArray[n2];
                PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(beanClass, propertyName);
                if (pd != null) {
                    return pd.getPropertyType();
                }
                ++n2;
            }
        }
        return Object.class;
    }

    public static MethodParameter getWriteMethodParameter(PropertyDescriptor pd) {
        if (pd instanceof GenericTypeAwarePropertyDescriptor) {
            return new MethodParameter(((GenericTypeAwarePropertyDescriptor)pd).getWriteMethodParameter());
        }
        return new MethodParameter(pd.getWriteMethod(), 0);
    }

    public static boolean isSimpleProperty(Class<?> clazz2) {
        Assert.notNull(clazz2, "Class must not be null");
        return BeanUtils.isSimpleValueType(clazz2) || clazz2.isArray() && BeanUtils.isSimpleValueType(clazz2.getComponentType());
    }

    public static boolean isSimpleValueType(Class<?> clazz2) {
        return ClassUtils.isPrimitiveOrWrapper(clazz2) || clazz2.isEnum() || CharSequence.class.isAssignableFrom(clazz2) || Number.class.isAssignableFrom(clazz2) || Date.class.isAssignableFrom(clazz2) || clazz2.equals(URI.class) || clazz2.equals(URL.class) || clazz2.equals(Locale.class) || clazz2.equals(Class.class);
    }

    public static void copyProperties(Object source, Object target2) throws BeansException {
        BeanUtils.copyProperties(source, target2, null, null);
    }

    public static void copyProperties(Object source, Object target2, Class<?> editable) throws BeansException {
        BeanUtils.copyProperties(source, target2, editable, null);
    }

    public static void copyProperties(Object source, Object target2, String[] ignoreProperties) throws BeansException {
        BeanUtils.copyProperties(source, target2, null, ignoreProperties);
    }

    private static void copyProperties(Object source, Object target2, Class<?> editable, String[] ignoreProperties) throws BeansException {
        Assert.notNull(source, "Source must not be null");
        Assert.notNull(target2, "Target must not be null");
        Class<?> actualEditable = target2.getClass();
        if (editable != null) {
            if (!editable.isInstance(target2)) {
                throw new IllegalArgumentException("Target class [" + target2.getClass().getName() + "] not assignable to Editable class [" + editable.getName() + "]");
            }
            actualEditable = editable;
        }
        PropertyDescriptor[] targetPds = BeanUtils.getPropertyDescriptors(actualEditable);
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        PropertyDescriptor[] propertyDescriptorArray = targetPds;
        int n = targetPds.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor sourcePd;
            PropertyDescriptor targetPd = propertyDescriptorArray[n2];
            if (!(targetPd.getWriteMethod() == null || ignoreProperties != null && ignoreList.contains(targetPd.getName()) || (sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), targetPd.getName())) == null || sourcePd.getReadMethod() == null)) {
                try {
                    Method readMethod = sourcePd.getReadMethod();
                    if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                        readMethod.setAccessible(true);
                    }
                    Object value2 = readMethod.invoke(source, new Object[0]);
                    Method writeMethod = targetPd.getWriteMethod();
                    if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                        writeMethod.setAccessible(true);
                    }
                    writeMethod.invoke(target2, value2);
                }
                catch (Throwable ex2) {
                    throw new FatalBeanException("Could not copy properties from source to target", ex2);
                }
            }
            ++n2;
        }
    }
}

