/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.AbstractPropertyAccessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.TypeConverterDelegate;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectFieldAccessor
extends AbstractPropertyAccessor {
    private final Object target;
    private final Map<String, Field> fieldMap = new HashMap<String, Field>();
    private final TypeConverterDelegate typeConverterDelegate;

    public DirectFieldAccessor(Object target2) {
        Assert.notNull(target2, "Target object must not be null");
        this.target = target2;
        ReflectionUtils.doWithFields(this.target.getClass(), new ReflectionUtils.FieldCallback(){

            public void doWith(Field field2) {
                if (!DirectFieldAccessor.this.fieldMap.containsKey(field2.getName())) {
                    DirectFieldAccessor.this.fieldMap.put(field2.getName(), field2);
                }
            }
        });
        this.typeConverterDelegate = new TypeConverterDelegate(this, target2);
        this.registerDefaultEditors();
        this.setExtractOldValueForEditor(true);
    }

    @Override
    public boolean isReadableProperty(String propertyName) throws BeansException {
        return this.fieldMap.containsKey(propertyName);
    }

    @Override
    public boolean isWritableProperty(String propertyName) throws BeansException {
        return this.fieldMap.containsKey(propertyName);
    }

    @Override
    public Class<?> getPropertyType(String propertyName) throws BeansException {
        Field field2 = this.fieldMap.get(propertyName);
        if (field2 != null) {
            return field2.getType();
        }
        return null;
    }

    @Override
    public TypeDescriptor getPropertyTypeDescriptor(String propertyName) throws BeansException {
        Field field2 = this.fieldMap.get(propertyName);
        if (field2 != null) {
            return new TypeDescriptor(field2);
        }
        return null;
    }

    @Override
    public Object getPropertyValue(String propertyName) throws BeansException {
        Field field2 = this.fieldMap.get(propertyName);
        if (field2 == null) {
            throw new NotReadablePropertyException(this.target.getClass(), propertyName, "Field '" + propertyName + "' does not exist");
        }
        try {
            ReflectionUtils.makeAccessible(field2);
            return field2.get(this.target);
        }
        catch (IllegalAccessException ex2) {
            throw new InvalidPropertyException(this.target.getClass(), propertyName, "Field is not accessible", ex2);
        }
    }

    @Override
    public void setPropertyValue(String propertyName, Object newValue) throws BeansException {
        Field field2 = this.fieldMap.get(propertyName);
        if (field2 == null) {
            throw new NotWritablePropertyException(this.target.getClass(), propertyName, "Field '" + propertyName + "' does not exist");
        }
        Object oldValue = null;
        try {
            ReflectionUtils.makeAccessible(field2);
            oldValue = field2.get(this.target);
            Object convertedValue = this.typeConverterDelegate.convertIfNecessary(field2.getName(), oldValue, newValue, field2.getType(), new TypeDescriptor(field2));
            field2.set(this.target, convertedValue);
        }
        catch (ConverterNotFoundException ex2) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.target, propertyName, oldValue, newValue);
            throw new ConversionNotSupportedException(pce, field2.getType(), (Throwable)ex2);
        }
        catch (ConversionException ex3) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.target, propertyName, oldValue, newValue);
            throw new TypeMismatchException(pce, field2.getType(), (Throwable)ex3);
        }
        catch (IllegalStateException ex4) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.target, propertyName, oldValue, newValue);
            throw new ConversionNotSupportedException(pce, field2.getType(), (Throwable)ex4);
        }
        catch (IllegalArgumentException ex5) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.target, propertyName, oldValue, newValue);
            throw new TypeMismatchException(pce, field2.getType(), (Throwable)ex5);
        }
        catch (IllegalAccessException ex6) {
            throw new InvalidPropertyException(this.target.getClass(), propertyName, "Field is not accessible", ex6);
        }
    }

    @Override
    public <T> T convertIfNecessary(Object value2, Class<T> requiredType, MethodParameter methodParam) throws TypeMismatchException {
        try {
            return this.typeConverterDelegate.convertIfNecessary(value2, requiredType, methodParam);
        }
        catch (IllegalArgumentException ex2) {
            throw new TypeMismatchException(value2, requiredType, (Throwable)ex2);
        }
        catch (IllegalStateException ex3) {
            throw new ConversionNotSupportedException(value2, requiredType, (Throwable)ex3);
        }
    }
}

