/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

public abstract class PropertyAccessorUtils {
    public static String getPropertyName(String propertyPath) {
        int separatorIndex = propertyPath.endsWith("]") ? propertyPath.indexOf(91) : -1;
        return separatorIndex != -1 ? propertyPath.substring(0, separatorIndex) : propertyPath;
    }

    public static boolean isNestedOrIndexedProperty(String propertyPath) {
        if (propertyPath == null) {
            return false;
        }
        int i = 0;
        while (i < propertyPath.length()) {
            char ch = propertyPath.charAt(i);
            if (ch == '.' || ch == '[') {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int getFirstNestedPropertySeparatorIndex(String propertyPath) {
        return PropertyAccessorUtils.getNestedPropertySeparatorIndex(propertyPath, false);
    }

    public static int getLastNestedPropertySeparatorIndex(String propertyPath) {
        return PropertyAccessorUtils.getNestedPropertySeparatorIndex(propertyPath, true);
    }

    private static int getNestedPropertySeparatorIndex(String propertyPath, boolean last2) {
        boolean inKey = false;
        int length2 = propertyPath.length();
        int i = last2 ? length2 - 1 : 0;
        while (!(last2 ? i < 0 : i >= length2)) {
            switch (propertyPath.charAt(i)) {
                case '[': 
                case ']': {
                    inKey = !inKey;
                    break;
                }
                case '.': {
                    if (inKey) break;
                    return i;
                }
            }
            if (last2) {
                --i;
                continue;
            }
            ++i;
        }
        return -1;
    }

    public static boolean matchesProperty(String registeredPath, String propertyPath) {
        if (!registeredPath.startsWith(propertyPath)) {
            return false;
        }
        if (registeredPath.length() == propertyPath.length()) {
            return true;
        }
        if (registeredPath.charAt(propertyPath.length()) != '[') {
            return false;
        }
        return registeredPath.indexOf(93, propertyPath.length() + 1) == registeredPath.length() - 1;
    }

    public static String canonicalPropertyName(String propertyName) {
        if (propertyName == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(propertyName);
        int searchIndex = 0;
        while (searchIndex != -1) {
            int keyEnd;
            int keyStart = sb.indexOf("[", searchIndex);
            searchIndex = -1;
            if (keyStart == -1 || (keyEnd = sb.indexOf("]", keyStart + "[".length())) == -1) continue;
            String key = sb.substring(keyStart + "[".length(), keyEnd);
            if (key.startsWith("'") && key.endsWith("'") || key.startsWith("\"") && key.endsWith("\"")) {
                sb.delete(keyStart + 1, keyStart + 2);
                sb.delete(keyEnd - 2, keyEnd - 1);
                keyEnd -= 2;
            }
            searchIndex = keyEnd + "]".length();
        }
        return sb.toString();
    }

    public static String[] canonicalPropertyNames(String[] propertyNames) {
        if (propertyNames == null) {
            return null;
        }
        String[] result2 = new String[propertyNames.length];
        int i = 0;
        while (i < propertyNames.length) {
            result2[i] = PropertyAccessorUtils.canonicalPropertyName(propertyNames[i]);
            ++i;
        }
        return result2;
    }
}

