/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeConverterDelegate;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConverterNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTypeConverter
extends PropertyEditorRegistrySupport
implements TypeConverter {
    private final TypeConverterDelegate typeConverterDelegate = new TypeConverterDelegate(this);

    public SimpleTypeConverter() {
        this.registerDefaultEditors();
    }

    @Override
    public <T> T convertIfNecessary(Object value2, Class<T> requiredType) throws TypeMismatchException {
        return this.convertIfNecessary(value2, requiredType, null);
    }

    @Override
    public <T> T convertIfNecessary(Object value2, Class<T> requiredType, MethodParameter methodParam) throws TypeMismatchException {
        try {
            return this.typeConverterDelegate.convertIfNecessary(value2, requiredType, methodParam);
        }
        catch (ConverterNotFoundException ex2) {
            throw new ConversionNotSupportedException(value2, requiredType, (Throwable)ex2);
        }
        catch (ConversionException ex3) {
            throw new TypeMismatchException(value2, requiredType, (Throwable)ex3);
        }
        catch (IllegalStateException ex4) {
            throw new ConversionNotSupportedException(value2, requiredType, (Throwable)ex4);
        }
        catch (IllegalArgumentException ex5) {
            throw new TypeMismatchException(value2, requiredType, (Throwable)ex5);
        }
    }
}

