/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.core.CollectionFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TypeConverterDelegate {
    private static final Log logger = LogFactory.getLog(TypeConverterDelegate.class);
    private final PropertyEditorRegistrySupport propertyEditorRegistry;
    private final Object targetObject;

    public TypeConverterDelegate(PropertyEditorRegistrySupport propertyEditorRegistry) {
        this(propertyEditorRegistry, null);
    }

    public TypeConverterDelegate(PropertyEditorRegistrySupport propertyEditorRegistry, Object targetObject) {
        this.propertyEditorRegistry = propertyEditorRegistry;
        this.targetObject = targetObject;
    }

    public <T> T convertIfNecessary(Object newValue, Class<T> requiredType, MethodParameter methodParam) throws IllegalArgumentException {
        return this.convertIfNecessary(null, null, newValue, requiredType, methodParam != null ? new TypeDescriptor(methodParam) : TypeDescriptor.valueOf(requiredType));
    }

    public <T> T convertIfNecessary(String propertyName, Object oldValue, Object newValue, Class<T> requiredType) throws IllegalArgumentException {
        return this.convertIfNecessary(propertyName, oldValue, newValue, requiredType, TypeDescriptor.valueOf(requiredType));
    }

    public <T> T convertIfNecessary(String propertyName, Object oldValue, Object newValue, Class<T> requiredType, TypeDescriptor typeDescriptor) throws IllegalArgumentException {
        TypeDescriptor targetTypeDesc;
        TypeDescriptor sourceTypeDesc;
        Object convertedValue = newValue;
        PropertyEditor editor = this.propertyEditorRegistry.findCustomEditor(requiredType, propertyName);
        ConversionFailedException firstAttemptEx = null;
        ConversionService conversionService = this.propertyEditorRegistry.getConversionService();
        if (editor == null && conversionService != null && convertedValue != null && typeDescriptor != null && conversionService.canConvert(sourceTypeDesc = TypeDescriptor.forObject(newValue), targetTypeDesc = typeDescriptor)) {
            try {
                return (T)conversionService.convert(convertedValue, sourceTypeDesc, targetTypeDesc);
            }
            catch (ConversionFailedException ex2) {
                firstAttemptEx = ex2;
            }
        }
        if (editor != null || requiredType != null && !ClassUtils.isAssignableValue(requiredType, convertedValue)) {
            TypeDescriptor elementType2;
            if (requiredType != null && Collection.class.isAssignableFrom(requiredType) && convertedValue instanceof String && (elementType2 = typeDescriptor.getElementTypeDescriptor()) != null && Enum.class.isAssignableFrom(elementType2.getType())) {
                convertedValue = StringUtils.commaDelimitedListToStringArray((String)convertedValue);
            }
            if (editor == null) {
                editor = this.findDefaultEditor(requiredType, typeDescriptor);
            }
            convertedValue = this.doConvertValue(oldValue, convertedValue, requiredType, editor);
        }
        if (requiredType != null) {
            if (convertedValue != null) {
                if (requiredType.isArray()) {
                    if (convertedValue instanceof String && Enum.class.isAssignableFrom(requiredType.getComponentType())) {
                        convertedValue = StringUtils.commaDelimitedListToStringArray((String)convertedValue);
                    }
                    return (T)this.convertToTypedArray(convertedValue, propertyName, requiredType.getComponentType());
                }
                if (convertedValue instanceof Collection) {
                    convertedValue = this.convertToTypedCollection((Collection)convertedValue, propertyName, requiredType, typeDescriptor);
                } else if (convertedValue instanceof Map) {
                    convertedValue = this.convertToTypedMap((Map)convertedValue, propertyName, requiredType, typeDescriptor);
                }
                if (convertedValue.getClass().isArray() && Array.getLength(convertedValue) == 1) {
                    convertedValue = Array.get(convertedValue, 0);
                }
                if (String.class.equals(requiredType) && ClassUtils.isPrimitiveOrWrapper(convertedValue.getClass())) {
                    return (T)convertedValue.toString();
                }
                if (convertedValue instanceof String && !requiredType.isInstance(convertedValue)) {
                    block28: {
                        if (!requiredType.isInterface() && !requiredType.isEnum()) {
                            try {
                                Constructor<T> strCtor = requiredType.getConstructor(String.class);
                                return BeanUtils.instantiateClass(strCtor, convertedValue);
                            }
                            catch (NoSuchMethodException ex3) {
                                if (logger.isTraceEnabled()) {
                                    logger.trace("No String constructor found on type [" + requiredType.getName() + "]", ex3);
                                }
                            }
                            catch (Exception ex4) {
                                if (!logger.isDebugEnabled()) break block28;
                                logger.debug("Construction via String failed for type [" + requiredType.getName() + "]", ex4);
                            }
                        }
                    }
                    String trimmedValue = ((String)convertedValue).trim();
                    if (requiredType.isEnum() && "".equals(trimmedValue)) {
                        return null;
                    }
                    convertedValue = this.attemptToConvertStringToEnum(requiredType, trimmedValue, convertedValue);
                }
            }
            if (!ClassUtils.isAssignableValue(requiredType, convertedValue)) {
                if (firstAttemptEx != null) {
                    throw firstAttemptEx;
                }
                StringBuilder msg = new StringBuilder();
                msg.append("Cannot convert value of type [").append(ClassUtils.getDescriptiveType(newValue));
                msg.append("] to required type [").append(ClassUtils.getQualifiedName(requiredType)).append("]");
                if (propertyName != null) {
                    msg.append(" for property '").append(propertyName).append("'");
                }
                if (editor != null) {
                    msg.append(": PropertyEditor [").append(editor.getClass().getName()).append("] returned inappropriate value of type [").append(ClassUtils.getDescriptiveType(convertedValue)).append("]");
                    throw new IllegalArgumentException(msg.toString());
                }
                msg.append(": no matching editors or conversion strategy found");
                throw new IllegalStateException(msg.toString());
            }
        }
        if (firstAttemptEx != null) {
            if (editor == null && convertedValue == newValue) {
                throw firstAttemptEx;
            }
            logger.debug("Original ConversionService attempt failed - ignored since PropertyEditor based conversion eventually succeeded", firstAttemptEx);
        }
        return (T)convertedValue;
    }

    private Object attemptToConvertStringToEnum(Class<?> requiredType, String trimmedValue, Object currentConvertedValue) {
        Object convertedValue;
        block9: {
            block8: {
                int index2;
                convertedValue = currentConvertedValue;
                if (Enum.class.equals(requiredType) && (index2 = trimmedValue.lastIndexOf(".")) > -1) {
                    String enumType = trimmedValue.substring(0, index2);
                    String fieldName = trimmedValue.substring(index2 + 1);
                    ClassLoader loader = this.targetObject.getClass().getClassLoader();
                    try {
                        Class<?> enumValueType = loader.loadClass(enumType);
                        Field enumField = enumValueType.getField(fieldName);
                        convertedValue = enumField.get(null);
                    }
                    catch (ClassNotFoundException ex2) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Enum class [" + enumType + "] cannot be loaded from [" + loader + "]", ex2);
                        }
                    }
                    catch (Throwable ex3) {
                        if (!logger.isTraceEnabled()) break block8;
                        logger.trace("Field [" + fieldName + "] isn't an enum value for type [" + enumType + "]", ex3);
                    }
                }
            }
            if (convertedValue == currentConvertedValue) {
                try {
                    Field enumField = requiredType.getField(trimmedValue);
                    convertedValue = enumField.get(null);
                }
                catch (Throwable ex4) {
                    if (!logger.isTraceEnabled()) break block9;
                    logger.trace("Field [" + convertedValue + "] isn't an enum value", ex4);
                }
            }
        }
        return convertedValue;
    }

    protected PropertyEditor findDefaultEditor(Class requiredType, TypeDescriptor typeDescriptor) {
        PropertyEditor editor = null;
        if (editor == null && requiredType != null && (editor = this.propertyEditorRegistry.getDefaultEditor(requiredType)) == null && !String.class.equals((Object)requiredType)) {
            editor = BeanUtils.findEditorByConvention(requiredType);
        }
        return editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doConvertValue(Object oldValue, Object newValue, Class<?> requiredType, PropertyEditor editor) {
        boolean sharedEditor;
        Object convertedValue;
        block20: {
            convertedValue = newValue;
            sharedEditor = false;
            if (editor != null) {
                sharedEditor = this.propertyEditorRegistry.isSharedEditor(editor);
            }
            if (editor != null && !(convertedValue instanceof String)) {
                try {
                    Object newConvertedValue;
                    if (sharedEditor) {
                        PropertyEditor propertyEditor = editor;
                        synchronized (propertyEditor) {
                            editor.setValue(convertedValue);
                            newConvertedValue = editor.getValue();
                        }
                    } else {
                        editor.setValue(convertedValue);
                        newConvertedValue = editor.getValue();
                    }
                    if (newConvertedValue != convertedValue) {
                        convertedValue = newConvertedValue;
                        editor = null;
                    }
                }
                catch (Exception ex2) {
                    if (!logger.isDebugEnabled()) break block20;
                    logger.debug("PropertyEditor [" + editor.getClass().getName() + "] does not support setValue call", ex2);
                }
            }
        }
        Object returnValue = convertedValue;
        if (requiredType != null && !requiredType.isArray() && convertedValue instanceof String[]) {
            if (logger.isTraceEnabled()) {
                logger.trace("Converting String array to comma-delimited String [" + convertedValue + "]");
            }
            convertedValue = StringUtils.arrayToCommaDelimitedString((String[])convertedValue);
        }
        if (convertedValue instanceof String) {
            if (editor != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Converting String to [" + requiredType + "] using property editor [" + editor + "]");
                }
                String newTextValue = (String)convertedValue;
                if (sharedEditor) {
                    PropertyEditor propertyEditor = editor;
                    synchronized (propertyEditor) {
                        return this.doConvertTextValue(oldValue, newTextValue, editor);
                    }
                }
                return this.doConvertTextValue(oldValue, newTextValue, editor);
            }
            if (String.class.equals(requiredType)) {
                returnValue = convertedValue;
            }
        }
        return returnValue;
    }

    protected Object doConvertTextValue(Object oldValue, String newTextValue, PropertyEditor editor) {
        block2: {
            try {
                editor.setValue(oldValue);
            }
            catch (Exception ex2) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("PropertyEditor [" + editor.getClass().getName() + "] does not support setValue call", ex2);
            }
        }
        editor.setAsText(newTextValue);
        return editor.getValue();
    }

    protected Object convertToTypedArray(Object input2, String propertyName, Class<?> componentType) {
        if (input2 instanceof Collection) {
            Collection coll = (Collection)input2;
            Object result2 = Array.newInstance(componentType, coll.size());
            int i = 0;
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                Object value2 = this.convertIfNecessary(this.buildIndexedPropertyName(propertyName, i), null, it.next(), componentType);
                Array.set(result2, i, value2);
                ++i;
            }
            return result2;
        }
        if (input2.getClass().isArray()) {
            if (componentType.equals(input2.getClass().getComponentType()) && !this.propertyEditorRegistry.hasCustomEditorForElement(componentType, propertyName)) {
                return input2;
            }
            int arrayLength = Array.getLength(input2);
            Object result3 = Array.newInstance(componentType, arrayLength);
            int i = 0;
            while (i < arrayLength) {
                Object value3 = this.convertIfNecessary(this.buildIndexedPropertyName(propertyName, i), null, Array.get(input2, i), componentType);
                Array.set(result3, i, value3);
                ++i;
            }
            return result3;
        }
        Object result4 = Array.newInstance(componentType, 1);
        Object value4 = this.convertIfNecessary(this.buildIndexedPropertyName(propertyName, 0), null, input2, componentType);
        Array.set(result4, 0, value4);
        return result4;
    }

    protected Collection convertToTypedCollection(Collection original, String propertyName, Class requiredType, TypeDescriptor typeDescriptor) {
        Collection convertedCopy;
        Iterator it;
        if (!Collection.class.isAssignableFrom(requiredType)) {
            return original;
        }
        boolean approximable = CollectionFactory.isApproximableCollectionType(requiredType);
        if (!approximable && !this.canCreateCopy(requiredType)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Custom Collection type [" + original.getClass().getName() + "] does not allow for creating a copy - injecting original Collection as-is");
            }
            return original;
        }
        boolean originalAllowed = requiredType.isInstance(original);
        TypeDescriptor elementType2 = (typeDescriptor = typeDescriptor.narrow(original)).getElementTypeDescriptor();
        if (elementType2 == null && originalAllowed && !this.propertyEditorRegistry.hasCustomEditorForElement(null, propertyName)) {
            return original;
        }
        try {
            it = original.iterator();
            if (it == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Collection of type [" + original.getClass().getName() + "] returned null Iterator - injecting original Collection as-is");
                }
                return original;
            }
        }
        catch (Throwable ex2) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cannot access Collection of type [" + original.getClass().getName() + "] - injecting original Collection as-is: " + ex2);
            }
            return original;
        }
        try {
            convertedCopy = approximable ? CollectionFactory.createApproximateCollection(original, original.size()) : (Collection)requiredType.newInstance();
        }
        catch (Throwable ex3) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cannot create copy of Collection type [" + original.getClass().getName() + "] - injecting original Collection as-is: " + ex3);
            }
            return original;
        }
        int i = 0;
        while (it.hasNext()) {
            Object element2 = it.next();
            String indexedPropertyName = this.buildIndexedPropertyName(propertyName, i);
            Object convertedElement = this.convertIfNecessary(indexedPropertyName, null, element2, elementType2 != null ? elementType2.getType() : null, elementType2);
            try {
                convertedCopy.add(convertedElement);
            }
            catch (Throwable ex4) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Collection type [" + original.getClass().getName() + "] seems to be read-only - injecting original Collection as-is: " + ex4);
                }
                return original;
            }
            originalAllowed = originalAllowed && element2 == convertedElement;
            ++i;
        }
        return originalAllowed ? original : convertedCopy;
    }

    /*
     * Unable to fully structure code
     */
    protected Map convertToTypedMap(Map original, String propertyName, Class requiredType, TypeDescriptor typeDescriptor) {
        if (!Map.class.isAssignableFrom(requiredType)) {
            return original;
        }
        approximable = CollectionFactory.isApproximableMapType(requiredType);
        if (!approximable && !this.canCreateCopy(requiredType)) {
            if (TypeConverterDelegate.logger.isDebugEnabled()) {
                TypeConverterDelegate.logger.debug("Custom Map type [" + original.getClass().getName() + "] does not allow for creating a copy - injecting original Map as-is");
            }
            return original;
        }
        originalAllowed = requiredType.isInstance(original);
        typeDescriptor = typeDescriptor.narrow(original);
        keyType = typeDescriptor.getMapKeyTypeDescriptor();
        valueType = typeDescriptor.getMapValueTypeDescriptor();
        if (keyType == null && valueType == null && originalAllowed && !this.propertyEditorRegistry.hasCustomEditorForElement(null, propertyName)) {
            return original;
        }
        try {
            it = original.entrySet().iterator();
            if (it == null) {
                if (TypeConverterDelegate.logger.isDebugEnabled()) {
                    TypeConverterDelegate.logger.debug("Map of type [" + original.getClass().getName() + "] returned null Iterator - injecting original Map as-is");
                }
                return original;
            }
        }
        catch (Throwable ex) {
            if (TypeConverterDelegate.logger.isDebugEnabled()) {
                TypeConverterDelegate.logger.debug("Cannot access Map of type [" + original.getClass().getName() + "] - injecting original Map as-is: " + ex);
            }
            return original;
        }
        try {
            block16: {
                if (!approximable) break block16;
                convertedCopy = CollectionFactory.createApproximateMap(original, original.size());
                ** GOTO lbl52
            }
            convertedCopy = (Map)requiredType.newInstance();
            if (true) ** GOTO lbl52
        }
        catch (Throwable ex) {
            if (TypeConverterDelegate.logger.isDebugEnabled()) {
                TypeConverterDelegate.logger.debug("Cannot create copy of Map type [" + original.getClass().getName() + "] - injecting original Map as-is: " + ex);
            }
            return original;
        }
        do {
            entry = it.next();
            key = entry.getKey();
            value = entry.getValue();
            keyedPropertyName = this.buildKeyedPropertyName(propertyName, key);
            convertedKey = this.convertIfNecessary(keyedPropertyName, null, key, keyType != null ? keyType.getType() : null, keyType);
            convertedValue = this.convertIfNecessary(keyedPropertyName, null, value, valueType != null ? valueType.getType() : null, valueType);
            try {
                convertedCopy.put(convertedKey, convertedValue);
            }
            catch (Throwable ex) {
                if (TypeConverterDelegate.logger.isDebugEnabled()) {
                    TypeConverterDelegate.logger.debug("Map type [" + original.getClass().getName() + "] seems to be read-only - injecting original Map as-is: " + ex);
                }
                return original;
            }
            v0 = originalAllowed = originalAllowed != false && key == convertedKey && value == convertedValue;
lbl52:
            // 3 sources

        } while (it.hasNext());
        return originalAllowed != false ? original : convertedCopy;
    }

    private String buildIndexedPropertyName(String propertyName, int index2) {
        return propertyName != null ? String.valueOf(propertyName) + "[" + index2 + "]" : null;
    }

    private String buildKeyedPropertyName(String propertyName, Object key) {
        return propertyName != null ? String.valueOf(propertyName) + "[" + key + "]" : null;
    }

    private boolean canCreateCopy(Class requiredType) {
        return !requiredType.isInterface() && !Modifier.isAbstract(requiredType.getModifiers()) && Modifier.isPublic(requiredType.getModifiers()) && ClassUtils.hasConstructor(requiredType, new Class[0]);
    }
}

