/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.annotation;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutowiredAnnotationBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements MergedBeanDefinitionPostProcessor,
PriorityOrdered,
BeanFactoryAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Set<Class<? extends Annotation>> autowiredAnnotationTypes = new LinkedHashSet<Class<? extends Annotation>>();
    private String requiredParameterName = "required";
    private boolean requiredParameterValue = true;
    private int order = 0x7FFFFFFD;
    private ConfigurableListableBeanFactory beanFactory;
    private final Map<Class<?>, Constructor<?>[]> candidateConstructorsCache = new ConcurrentHashMap();
    private final Map<Class<?>, InjectionMetadata> injectionMetadataCache = new ConcurrentHashMap();

    public AutowiredAnnotationBeanPostProcessor() {
        this.autowiredAnnotationTypes.add(Autowired.class);
        this.autowiredAnnotationTypes.add(Value.class);
        ClassLoader cl = AutowiredAnnotationBeanPostProcessor.class.getClassLoader();
        try {
            this.autowiredAnnotationTypes.add(cl.loadClass("javax.inject.Inject"));
            this.logger.info("JSR-330 'javax.inject.Inject' annotation found and supported for autowiring");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public void setAutowiredAnnotationType(Class<? extends Annotation> autowiredAnnotationType) {
        Assert.notNull(autowiredAnnotationType, "'autowiredAnnotationType' must not be null");
        this.autowiredAnnotationTypes.clear();
        this.autowiredAnnotationTypes.add(autowiredAnnotationType);
    }

    public void setAutowiredAnnotationTypes(Set<Class<? extends Annotation>> autowiredAnnotationTypes) {
        Assert.notEmpty(autowiredAnnotationTypes, "'autowiredAnnotationTypes' must not be empty");
        this.autowiredAnnotationTypes.clear();
        this.autowiredAnnotationTypes.addAll(autowiredAnnotationTypes);
    }

    public void setRequiredParameterName(String requiredParameterName) {
        this.requiredParameterName = requiredParameterName;
    }

    public void setRequiredParameterValue(boolean requiredParameterValue) {
        this.requiredParameterValue = requiredParameterValue;
    }

    public void setOrder(int order2) {
        this.order = order2;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            throw new IllegalArgumentException("AutowiredAnnotationBeanPostProcessor requires a ConfigurableListableBeanFactory");
        }
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    @Override
    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
        if (beanType != null) {
            InjectionMetadata metadata = this.findAutowiringMetadata(beanType);
            metadata.checkConfigMembers(beanDefinition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constructor<?>[] determineCandidateConstructors(Class<?> beanClass, String beanName) throws BeansException {
        Constructor<?>[] candidateConstructors = this.candidateConstructorsCache.get(beanClass);
        if (candidateConstructors == null) {
            Map<Class<?>, Constructor<?>[]> map3 = this.candidateConstructorsCache;
            synchronized (map3) {
                candidateConstructors = this.candidateConstructorsCache.get(beanClass);
                if (candidateConstructors == null) {
                    Constructor<?>[] rawCandidates = beanClass.getDeclaredConstructors();
                    ArrayList candidates = new ArrayList(rawCandidates.length);
                    Constructor<?> requiredConstructor = null;
                    Constructor<?> defaultConstructor = null;
                    Constructor<?>[] constructorArray = rawCandidates;
                    int n = rawCandidates.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Constructor<?> candidate = constructorArray[n2];
                        Annotation annotation2 = this.findAutowiredAnnotation(candidate);
                        if (annotation2 != null) {
                            if (requiredConstructor != null) {
                                throw new BeanCreationException("Invalid autowire-marked constructor: " + candidate + ". Found another constructor with 'required' Autowired annotation: " + requiredConstructor);
                            }
                            if (candidate.getParameterTypes().length == 0) {
                                throw new IllegalStateException("Autowired annotation requires at least one argument: " + candidate);
                            }
                            boolean required = this.determineRequiredStatus(annotation2);
                            if (required) {
                                if (!candidates.isEmpty()) {
                                    throw new BeanCreationException("Invalid autowire-marked constructors: " + candidates + ". Found another constructor with 'required' Autowired annotation: " + requiredConstructor);
                                }
                                requiredConstructor = candidate;
                            }
                            candidates.add(candidate);
                        } else if (candidate.getParameterTypes().length == 0) {
                            defaultConstructor = candidate;
                        }
                        ++n2;
                    }
                    if (!candidates.isEmpty()) {
                        if (requiredConstructor == null && defaultConstructor != null) {
                            candidates.add(defaultConstructor);
                        }
                        candidateConstructors = candidates.toArray(new Constructor[candidates.size()]);
                    } else {
                        candidateConstructors = new Constructor[]{};
                    }
                    this.candidateConstructorsCache.put(beanClass, candidateConstructors);
                }
            }
        }
        return candidateConstructors.length > 0 ? candidateConstructors : null;
    }

    @Override
    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        InjectionMetadata metadata = this.findAutowiringMetadata(bean.getClass());
        try {
            metadata.inject(bean, beanName, pvs);
        }
        catch (Throwable ex2) {
            throw new BeanCreationException(beanName, "Injection of autowired dependencies failed", ex2);
        }
        return pvs;
    }

    public void processInjection(Object bean) throws BeansException {
        Class<?> clazz2 = bean.getClass();
        InjectionMetadata metadata = this.findAutowiringMetadata(clazz2);
        try {
            metadata.inject(bean, null, null);
        }
        catch (Throwable ex2) {
            throw new BeanCreationException("Injection of autowired dependencies failed for class [" + clazz2 + "]", ex2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InjectionMetadata findAutowiringMetadata(Class<?> clazz2) {
        InjectionMetadata metadata = this.injectionMetadataCache.get(clazz2);
        if (metadata == null) {
            Map<Class<?>, InjectionMetadata> map3 = this.injectionMetadataCache;
            synchronized (map3) {
                metadata = this.injectionMetadataCache.get(clazz2);
                if (metadata == null) {
                    metadata = this.buildAutowiringMetadata(clazz2);
                    this.injectionMetadataCache.put(clazz2, metadata);
                }
            }
        }
        return metadata;
    }

    private InjectionMetadata buildAutowiringMetadata(Class<?> clazz2) {
        LinkedList<InjectionMetadata.InjectedElement> elements = new LinkedList<InjectionMetadata.InjectedElement>();
        Class<?> targetClass = clazz2;
        do {
            LinkedList<InjectionMetadata.InjectedElement> currElements = new LinkedList<InjectionMetadata.InjectedElement>();
            AccessibleObject[] accessibleObjectArray = targetClass.getDeclaredFields();
            int n = accessibleObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field2 = accessibleObjectArray[n2];
                Annotation annotation2 = this.findAutowiredAnnotation(field2);
                if (annotation2 != null) {
                    if (Modifier.isStatic(field2.getModifiers())) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Autowired annotation is not supported on static fields: " + field2);
                        }
                    } else {
                        boolean required = this.determineRequiredStatus(annotation2);
                        currElements.add(new AutowiredFieldElement(field2, required));
                    }
                }
                ++n2;
            }
            accessibleObjectArray = targetClass.getDeclaredMethods();
            n = accessibleObjectArray.length;
            n2 = 0;
            while (n2 < n) {
                Annotation annotation3;
                AccessibleObject method = accessibleObjectArray[n2];
                Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)method);
                Annotation annotation4 = annotation3 = BridgeMethodResolver.isVisibilityBridgeMethodPair((Method)method, bridgedMethod) ? this.findAutowiredAnnotation(bridgedMethod) : this.findAutowiredAnnotation(method);
                if (annotation3 != null && ((Method)method).equals(ClassUtils.getMostSpecificMethod((Method)method, clazz2))) {
                    if (Modifier.isStatic(((Method)method).getModifiers())) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Autowired annotation is not supported on static methods: " + method);
                        }
                    } else {
                        if (((Method)method).getParameterTypes().length == 0 && this.logger.isWarnEnabled()) {
                            this.logger.warn("Autowired annotation should be used on methods with actual parameters: " + method);
                        }
                        boolean required = this.determineRequiredStatus(annotation3);
                        PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)method);
                        currElements.add(new AutowiredMethodElement((Method)method, required, pd));
                    }
                }
                ++n2;
            }
            elements.addAll(0, currElements);
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return new InjectionMetadata(clazz2, elements);
    }

    private Annotation findAutowiredAnnotation(AccessibleObject ao) {
        for (Class<? extends Annotation> type : this.autowiredAnnotationTypes) {
            Annotation annotation2 = ao.getAnnotation(type);
            if (annotation2 == null) continue;
            return annotation2;
        }
        return null;
    }

    protected <T> Map<String, T> findAutowireCandidates(Class<T> type) throws BeansException {
        if (this.beanFactory == null) {
            throw new IllegalStateException("No BeanFactory configured - override the getBeanOfType method or specify the 'beanFactory' property");
        }
        return BeanFactoryUtils.beansOfTypeIncludingAncestors(this.beanFactory, type);
    }

    protected boolean determineRequiredStatus(Annotation annotation2) {
        try {
            Method method = ReflectionUtils.findMethod(annotation2.annotationType(), this.requiredParameterName);
            return this.requiredParameterValue == (Boolean)ReflectionUtils.invokeMethod(method, annotation2);
        }
        catch (Exception exception) {
            return true;
        }
    }

    private void registerDependentBeans(String beanName, Set<String> autowiredBeanNames) {
        if (beanName != null) {
            for (String autowiredBeanName : autowiredBeanNames) {
                this.beanFactory.registerDependentBean(autowiredBeanName, beanName);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Autowiring by type from bean name '" + beanName + "' to bean named '" + autowiredBeanName + "'");
            }
        }
    }

    private Object resolvedCachedArgument(String beanName, Object cachedArgument) {
        if (cachedArgument instanceof DependencyDescriptor) {
            DependencyDescriptor descriptor = (DependencyDescriptor)cachedArgument;
            TypeConverter typeConverter = this.beanFactory.getTypeConverter();
            return this.beanFactory.resolveDependency(descriptor, beanName, null, typeConverter);
        }
        if (cachedArgument instanceof RuntimeBeanReference) {
            return this.beanFactory.getBean(((RuntimeBeanReference)cachedArgument).getBeanName());
        }
        return cachedArgument;
    }

    private class AutowiredFieldElement
    extends InjectionMetadata.InjectedElement {
        private final boolean required;
        private volatile boolean cached;
        private volatile Object cachedFieldValue;

        public AutowiredFieldElement(Field field2, boolean required) {
            super(field2, null);
            this.cached = false;
            this.required = required;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void inject(Object bean, String beanName, PropertyValues pvs) throws Throwable {
            Field field2 = (Field)this.member;
            try {
                Object value2;
                if (this.cached) {
                    value2 = AutowiredAnnotationBeanPostProcessor.this.resolvedCachedArgument(beanName, this.cachedFieldValue);
                } else {
                    DependencyDescriptor descriptor = new DependencyDescriptor(field2, this.required);
                    LinkedHashSet<String> autowiredBeanNames = new LinkedHashSet<String>(1);
                    TypeConverter typeConverter = AutowiredAnnotationBeanPostProcessor.this.beanFactory.getTypeConverter();
                    value2 = AutowiredAnnotationBeanPostProcessor.this.beanFactory.resolveDependency(descriptor, beanName, autowiredBeanNames, typeConverter);
                    AutowiredFieldElement autowiredFieldElement = this;
                    synchronized (autowiredFieldElement) {
                        if (!this.cached) {
                            if (value2 != null || this.required) {
                                this.cachedFieldValue = descriptor;
                                AutowiredAnnotationBeanPostProcessor.this.registerDependentBeans(beanName, autowiredBeanNames);
                                if (autowiredBeanNames.size() == 1) {
                                    String autowiredBeanName = (String)autowiredBeanNames.iterator().next();
                                    if (AutowiredAnnotationBeanPostProcessor.this.beanFactory.containsBean(autowiredBeanName) && AutowiredAnnotationBeanPostProcessor.this.beanFactory.isTypeMatch(autowiredBeanName, field2.getType())) {
                                        this.cachedFieldValue = new RuntimeBeanReference(autowiredBeanName);
                                    }
                                }
                            } else {
                                this.cachedFieldValue = null;
                            }
                            this.cached = true;
                        }
                    }
                }
                if (value2 != null) {
                    ReflectionUtils.makeAccessible(field2);
                    field2.set(bean, value2);
                }
            }
            catch (Throwable ex2) {
                throw new BeanCreationException("Could not autowire field: " + field2, ex2);
            }
        }
    }

    private class AutowiredMethodElement
    extends InjectionMetadata.InjectedElement {
        private final boolean required;
        private volatile boolean cached;
        private volatile Object[] cachedMethodArguments;

        public AutowiredMethodElement(Method method, boolean required, PropertyDescriptor pd) {
            super(method, pd);
            this.cached = false;
            this.required = required;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void inject(Object bean, String beanName, PropertyValues pvs) throws Throwable {
            if (this.checkPropertySkipping(pvs)) {
                return;
            }
            Method method = (Method)this.member;
            try {
                Object[] arguments2;
                if (this.cached) {
                    arguments2 = this.resolveCachedArguments(beanName);
                } else {
                    Class<?>[] paramTypes2 = method.getParameterTypes();
                    arguments2 = new Object[paramTypes2.length];
                    DependencyDescriptor[] descriptors = new DependencyDescriptor[paramTypes2.length];
                    LinkedHashSet<String> autowiredBeanNames = new LinkedHashSet<String>(paramTypes2.length);
                    TypeConverter typeConverter = AutowiredAnnotationBeanPostProcessor.this.beanFactory.getTypeConverter();
                    int i = 0;
                    while (i < arguments2.length) {
                        MethodParameter methodParam = new MethodParameter(method, i);
                        GenericTypeResolver.resolveParameterType(methodParam, bean.getClass());
                        descriptors[i] = new DependencyDescriptor(methodParam, this.required);
                        arguments2[i] = AutowiredAnnotationBeanPostProcessor.this.beanFactory.resolveDependency(descriptors[i], beanName, autowiredBeanNames, typeConverter);
                        if (arguments2[i] == null && !this.required) {
                            arguments2 = null;
                            break;
                        }
                        ++i;
                    }
                    AutowiredMethodElement autowiredMethodElement = this;
                    synchronized (autowiredMethodElement) {
                        if (!this.cached) {
                            if (arguments2 != null) {
                                this.cachedMethodArguments = new Object[arguments2.length];
                                int i2 = 0;
                                while (i2 < arguments2.length) {
                                    this.cachedMethodArguments[i2] = descriptors[i2];
                                    ++i2;
                                }
                                AutowiredAnnotationBeanPostProcessor.this.registerDependentBeans(beanName, autowiredBeanNames);
                                if (autowiredBeanNames.size() == paramTypes2.length) {
                                    Iterator it = autowiredBeanNames.iterator();
                                    int i3 = 0;
                                    while (i3 < paramTypes2.length) {
                                        String autowiredBeanName = (String)it.next();
                                        if (AutowiredAnnotationBeanPostProcessor.this.beanFactory.containsBean(autowiredBeanName) && AutowiredAnnotationBeanPostProcessor.this.beanFactory.isTypeMatch(autowiredBeanName, paramTypes2[i3])) {
                                            this.cachedMethodArguments[i3] = new RuntimeBeanReference(autowiredBeanName);
                                        }
                                        ++i3;
                                    }
                                }
                            } else {
                                this.cachedMethodArguments = null;
                            }
                            this.cached = true;
                        }
                    }
                }
                if (arguments2 != null) {
                    ReflectionUtils.makeAccessible(method);
                    method.invoke(bean, arguments2);
                }
            }
            catch (InvocationTargetException ex2) {
                throw ex2.getTargetException();
            }
            catch (Throwable ex3) {
                throw new BeanCreationException("Could not autowire method: " + method, ex3);
            }
        }

        private Object[] resolveCachedArguments(String beanName) {
            if (this.cachedMethodArguments == null) {
                return null;
            }
            Object[] arguments2 = new Object[this.cachedMethodArguments.length];
            int i = 0;
            while (i < arguments2.length) {
                arguments2[i] = AutowiredAnnotationBeanPostProcessor.this.resolvedCachedArgument(beanName, this.cachedMethodArguments[i]);
                ++i;
            }
            return arguments2;
        }
    }
}

