/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanNameReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDefinitionVisitor {
    private StringValueResolver valueResolver;

    public BeanDefinitionVisitor(StringValueResolver valueResolver) {
        Assert.notNull(valueResolver, "StringValueResolver must not be null");
        this.valueResolver = valueResolver;
    }

    protected BeanDefinitionVisitor() {
    }

    public void visitBeanDefinition(BeanDefinition beanDefinition) {
        this.visitParentName(beanDefinition);
        this.visitBeanClassName(beanDefinition);
        this.visitFactoryBeanName(beanDefinition);
        this.visitFactoryMethodName(beanDefinition);
        this.visitScope(beanDefinition);
        this.visitPropertyValues(beanDefinition.getPropertyValues());
        ConstructorArgumentValues cas = beanDefinition.getConstructorArgumentValues();
        this.visitIndexedArgumentValues(cas.getIndexedArgumentValues());
        this.visitGenericArgumentValues(cas.getGenericArgumentValues());
    }

    protected void visitParentName(BeanDefinition beanDefinition) {
        String resolvedName;
        String parentName = beanDefinition.getParentName();
        if (parentName != null && !parentName.equals(resolvedName = this.resolveStringValue(parentName))) {
            beanDefinition.setParentName(resolvedName);
        }
    }

    protected void visitBeanClassName(BeanDefinition beanDefinition) {
        String resolvedName;
        String beanClassName = beanDefinition.getBeanClassName();
        if (beanClassName != null && !beanClassName.equals(resolvedName = this.resolveStringValue(beanClassName))) {
            beanDefinition.setBeanClassName(resolvedName);
        }
    }

    protected void visitFactoryBeanName(BeanDefinition beanDefinition) {
        String resolvedName;
        String factoryBeanName = beanDefinition.getFactoryBeanName();
        if (factoryBeanName != null && !factoryBeanName.equals(resolvedName = this.resolveStringValue(factoryBeanName))) {
            beanDefinition.setFactoryBeanName(resolvedName);
        }
    }

    protected void visitFactoryMethodName(BeanDefinition beanDefinition) {
        String resolvedName;
        String factoryMethodName = beanDefinition.getFactoryMethodName();
        if (factoryMethodName != null && !factoryMethodName.equals(resolvedName = this.resolveStringValue(factoryMethodName))) {
            beanDefinition.setFactoryMethodName(resolvedName);
        }
    }

    protected void visitScope(BeanDefinition beanDefinition) {
        String resolvedScope;
        String scope = beanDefinition.getScope();
        if (scope != null && !scope.equals(resolvedScope = this.resolveStringValue(scope))) {
            beanDefinition.setScope(resolvedScope);
        }
    }

    protected void visitPropertyValues(MutablePropertyValues pvs) {
        PropertyValue[] pvArray;
        PropertyValue[] propertyValueArray = pvArray = pvs.getPropertyValues();
        int n = pvArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyValue pv2 = propertyValueArray[n2];
            Object newVal = this.resolveValue(pv2.getValue());
            if (!ObjectUtils.nullSafeEquals(newVal, pv2.getValue())) {
                pvs.add(pv2.getName(), newVal);
            }
            ++n2;
        }
    }

    protected void visitIndexedArgumentValues(Map<Integer, ConstructorArgumentValues.ValueHolder> ias) {
        for (ConstructorArgumentValues.ValueHolder valueHolder : ias.values()) {
            Object newVal = this.resolveValue(valueHolder.getValue());
            if (ObjectUtils.nullSafeEquals(newVal, valueHolder.getValue())) continue;
            valueHolder.setValue(newVal);
        }
    }

    protected void visitGenericArgumentValues(List<ConstructorArgumentValues.ValueHolder> gas) {
        for (ConstructorArgumentValues.ValueHolder valueHolder : gas) {
            Object newVal = this.resolveValue(valueHolder.getValue());
            if (ObjectUtils.nullSafeEquals(newVal, valueHolder.getValue())) continue;
            valueHolder.setValue(newVal);
        }
    }

    protected Object resolveValue(Object value2) {
        if (value2 instanceof BeanDefinition) {
            this.visitBeanDefinition((BeanDefinition)value2);
        } else if (value2 instanceof BeanDefinitionHolder) {
            this.visitBeanDefinition(((BeanDefinitionHolder)value2).getBeanDefinition());
        } else if (value2 instanceof RuntimeBeanReference) {
            RuntimeBeanReference ref = (RuntimeBeanReference)value2;
            String newBeanName = this.resolveStringValue(ref.getBeanName());
            if (!newBeanName.equals(ref.getBeanName())) {
                return new RuntimeBeanReference(newBeanName);
            }
        } else if (value2 instanceof RuntimeBeanNameReference) {
            RuntimeBeanNameReference ref = (RuntimeBeanNameReference)value2;
            String newBeanName = this.resolveStringValue(ref.getBeanName());
            if (!newBeanName.equals(ref.getBeanName())) {
                return new RuntimeBeanNameReference(newBeanName);
            }
        } else if (value2 instanceof Object[]) {
            this.visitArray((Object[])value2);
        } else if (value2 instanceof List) {
            this.visitList((List)value2);
        } else if (value2 instanceof Set) {
            this.visitSet((Set)value2);
        } else if (value2 instanceof Map) {
            this.visitMap((Map)value2);
        } else if (value2 instanceof TypedStringValue) {
            TypedStringValue typedStringValue = (TypedStringValue)value2;
            String stringValue = typedStringValue.getValue();
            if (stringValue != null) {
                String visitedString = this.resolveStringValue(stringValue);
                typedStringValue.setValue(visitedString);
            }
        } else if (value2 instanceof String) {
            return this.resolveStringValue((String)value2);
        }
        return value2;
    }

    protected void visitArray(Object[] arrayVal) {
        int i = 0;
        while (i < arrayVal.length) {
            Object elem2 = arrayVal[i];
            Object newVal = this.resolveValue(elem2);
            if (!ObjectUtils.nullSafeEquals(newVal, elem2)) {
                arrayVal[i] = newVal;
            }
            ++i;
        }
    }

    protected void visitList(List listVal) {
        int i = 0;
        while (i < listVal.size()) {
            Object elem2 = listVal.get(i);
            Object newVal = this.resolveValue(elem2);
            if (!ObjectUtils.nullSafeEquals(newVal, elem2)) {
                listVal.set(i, newVal);
            }
            ++i;
        }
    }

    protected void visitSet(Set setVal) {
        LinkedHashSet<Object> newContent = new LinkedHashSet<Object>();
        boolean entriesModified = false;
        for (Object elem2 : setVal) {
            int elemHash = elem2 != null ? elem2.hashCode() : 0;
            Object newVal = this.resolveValue(elem2);
            int newValHash = newVal != null ? newVal.hashCode() : 0;
            newContent.add(newVal);
            boolean bl = entriesModified = entriesModified || newVal != elem2 || newValHash != elemHash;
        }
        if (entriesModified) {
            setVal.clear();
            setVal.addAll(newContent);
        }
    }

    protected void visitMap(Map<?, ?> mapVal) {
        LinkedHashMap<Object, Object> newContent = new LinkedHashMap<Object, Object>();
        boolean entriesModified = false;
        for (Map.Entry<?, ?> entry2 : mapVal.entrySet()) {
            Object key = entry2.getKey();
            int keyHash = key != null ? key.hashCode() : 0;
            Object newKey = this.resolveValue(key);
            int newKeyHash = newKey != null ? newKey.hashCode() : 0;
            Object val = entry2.getValue();
            Object newVal = this.resolveValue(val);
            newContent.put(newKey, newVal);
            boolean bl = entriesModified = entriesModified || newVal != val || newKey != key || newKeyHash != keyHash;
        }
        if (entriesModified) {
            mapVal.clear();
            mapVal.putAll(newContent);
        }
    }

    protected String resolveStringValue(String strVal) {
        if (this.valueResolver == null) {
            throw new IllegalStateException("No StringValueResolver specified - pass a resolver object into the constructor or override the 'resolveStringValue' method");
        }
        String resolvedValue = this.valueResolver.resolveStringValue(strVal);
        return strVal.equals(resolvedValue) ? strVal : resolvedValue;
    }
}

