/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomScopeConfigurer
implements BeanFactoryPostProcessor,
BeanClassLoaderAware,
Ordered {
    private Map<String, Object> scopes;
    private int order = Integer.MAX_VALUE;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();

    public void setScopes(Map<String, Object> scopes) {
        this.scopes = scopes;
    }

    public void setOrder(int order2) {
        this.order = order2;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.scopes != null) {
            for (Map.Entry<String, Object> entry2 : this.scopes.entrySet()) {
                Class<?> scopeClass;
                String scopeKey = entry2.getKey();
                Object value2 = entry2.getValue();
                if (value2 instanceof Scope) {
                    beanFactory.registerScope(scopeKey, (Scope)value2);
                    continue;
                }
                if (value2 instanceof Class) {
                    scopeClass = (Class<?>)value2;
                    Assert.isAssignable(Scope.class, scopeClass);
                    beanFactory.registerScope(scopeKey, (Scope)BeanUtils.instantiateClass(scopeClass));
                    continue;
                }
                if (value2 instanceof String) {
                    scopeClass = ClassUtils.resolveClassName((String)value2, this.beanClassLoader);
                    Assert.isAssignable(Scope.class, scopeClass);
                    beanFactory.registerScope(scopeKey, (Scope)BeanUtils.instantiateClass(scopeClass));
                    continue;
                }
                throw new IllegalArgumentException("Mapped value [" + value2 + "] for scope key [" + scopeKey + "] is not an instance of required type [" + Scope.class.getName() + "] or a corresponding Class or String value indicating a Scope implementation");
            }
        }
    }
}

